/*
 * Decompiled with CFR 0.152.
 */
package cfrishausen.potionfoods.data;

import cfrishausen.potionfoods.PotionFoodItem;
import cfrishausen.potionfoods.data.Data;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fml.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;

public class PotionLanguageProvider
extends LanguageProvider {
    public PotionLanguageProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "potionfoods", "en_us");
    }

    public static String convertSyntax(String food, String effect, Boolean isCake) {
        if (!isCake.booleanValue()) {
            String foodSpace = food.replace("_", " ");
            String effectSpace = effect.replace("_", " ");
            String combinedStrings = foodSpace + " of " + effectSpace;
            String withCap = WordUtils.capitalizeFully((String)combinedStrings);
            String finalName = withCap.replace(" Of ", " of ");
            if (food.equals("porkchop") || food.equals("cod") || food.equals("salmon") || food.equals("beef") || food.equals("chicken") || food.equals("rabbit") || food.equals("mutton")) {
                String rawFinalName = "Raw " + finalName;
                return rawFinalName;
            }
            return finalName;
        }
        String cakeEffectSpace = food.replace("_cake_item", "");
        String cakeEffectSpace2 = cakeEffectSpace.replace("_", " ");
        String cakeCombinedName = "cake of " + cakeEffectSpace2;
        String cakeCamelCase = WordUtils.capitalizeFully((String)cakeCombinedName);
        String cakeFinalName = cakeCamelCase.replace(" Of ", " of ");
        return cakeFinalName;
    }

    protected void addTranslations() {
        for (RegistryObject<PotionFoodItem> registryObject : Data.NEW_ITEMS) {
            this.addItem((Supplier)registryObject, PotionLanguageProvider.convertSyntax(Data.BASE_FOOD_NAMES.get(registryObject), Data.EFFECT_NAMES.get(registryObject), false));
        }
        for (RegistryObject<PotionFoodItem> registryObject : Data.NEW_CAKE_BLOCK_ITEMS) {
            this.addItem((Supplier)registryObject, PotionLanguageProvider.convertSyntax(registryObject.getId().func_110623_a(), "", true));
        }
    }
}

