/*
 * Decompiled with CFR 0.152.
 */
package cfrishausen.potionfoods.data;

import cfrishausen.potionfoods.PotionFoodItem;
import cfrishausen.potionfoods.data.Data;
import cfrishausen.potionfoods.data.IngredientNBTWrapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.RegistryObject;

public class PotionRecipeProvider
extends RecipeProvider {
    public static final Map<Potion, Ingredient> FOOD_INGREDIENTS = Maps.newHashMap();

    public PotionRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    private static Ingredient makePotionIngredient(Potion potion) {
        ItemStack swiftnessPotion = new ItemStack((IItemProvider)Items.field_151068_bn);
        PotionUtils.func_185188_a((ItemStack)swiftnessPotion, (Potion)potion);
        return new IngredientNBTWrapper(swiftnessPotion);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        for (Potion potion : Data.EFFECTS) {
            FOOD_INGREDIENTS.put(potion, PotionRecipeProvider.makePotionIngredient(potion));
        }
        for (RegistryObject registryObject : Data.NEW_ITEMS) {
            Ingredient newIngredient = FOOD_INGREDIENTS.get(((PotionFoodItem)registryObject.get()).getPotion());
            Item baseFood = Data.BASE_FOODS.get(registryObject);
            PotionRecipeProvider.createShapedRecipe((RegistryObject<PotionFoodItem>)registryObject, baseFood, newIngredient, consumer);
        }
        for (RegistryObject registryObject : Data.NEW_CAKE_BLOCK_ITEMS) {
            Block modCake = ((BlockItem)registryObject.get()).func_179223_d();
            Ingredient ingredient = null;
            for (RegistryObject<Block> block : Data.CAKES_WITH_POTIONS.keySet()) {
                if (block.get() != modCake) continue;
                ingredient = FOOD_INGREDIENTS.get(Data.CAKES_WITH_POTIONS.get(block));
            }
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)registryObject.get()), (int)1).func_200489_a(ingredient).func_200487_b((IItemProvider)Items.field_222070_lD).func_200490_a("potionfoods").func_200483_a("has_item", (ICriterionInstance)PotionRecipeProvider.func_200403_a((IItemProvider)Items.field_222070_lD)).func_200482_a(consumer);
        }
        PotionRecipeProvider.createSmeltRecipes(consumer);
    }

    public static void createShapedRecipe(RegistryObject<PotionFoodItem> object, Item baseFood, Ingredient ingredient, Consumer<IFinishedRecipe> subConsumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)object.get()), (int)8).func_200472_a("xxx").func_200472_a("xyx").func_200472_a("xxx").func_200462_a(Character.valueOf('x'), (IItemProvider)baseFood.getItem()).func_200471_a(Character.valueOf('y'), ingredient).func_200473_b("potionfoods").func_200465_a("has_item", (ICriterionInstance)PotionRecipeProvider.func_200403_a((IItemProvider)baseFood.getItem())).func_200464_a(subConsumer);
    }

    public static void createSmeltRecipes(Consumer<IFinishedRecipe> subConsumer) {
        HashMap foodToCooked = Maps.newHashMap();
        foodToCooked.put(Items.field_151147_al, Items.field_151157_am);
        foodToCooked.put(Items.field_196086_aW, Items.field_196102_ba);
        foodToCooked.put(Items.field_196087_aX, Items.field_196104_bb);
        foodToCooked.put(Items.field_151082_bd, Items.field_151083_be);
        foodToCooked.put(Items.field_151076_bf, Items.field_151077_bg);
        foodToCooked.put(Items.field_179558_bo, Items.field_179559_bp);
        foodToCooked.put(Items.field_179561_bm, Items.field_179557_bn);
        foodToCooked.put(Items.field_151174_bG, Items.field_151168_bH);
        for (RegistryObject<PotionFoodItem> object : Data.NEW_ITEMS) {
            if (!foodToCooked.containsKey(Data.BASE_FOODS.get(object))) continue;
            CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)object.get()}), (IItemProvider)((IItemProvider)foodToCooked.get(Data.BASE_FOODS.get(object))), (float)0.35f, (int)200).func_218628_a("has_item", (ICriterionInstance)PotionRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)object.get()))).func_218632_a(subConsumer, ((PotionFoodItem)object.get()).getRegistryName().func_110623_a());
            CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)object.get()}), (IItemProvider)((IItemProvider)foodToCooked.get(Data.BASE_FOODS.get(object))), (float)0.35f, (int)100, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a("has_item", (ICriterionInstance)PotionRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)object.get()))).func_218632_a(subConsumer, ((PotionFoodItem)object.get()).getRegistryName().func_110623_a() + "_from_smoking");
        }
    }
}

