/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import superlord.prehistoricfauna.config.PrehistoricConfigHolder;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.core.world.PFFeatureRegistration;
import superlord.prehistoricfauna.core.world.PHFBiomes;
import superlord.prehistoricfauna.core.world.PHFConfiguredFeatures;
import superlord.prehistoricfauna.core.world.PHFDecorators;
import superlord.prehistoricfauna.core.world.PHFFeatures;
import superlord.prehistoricfauna.core.world.PHFOverworldBiomeRegistry;
import superlord.prehistoricfauna.core.world.PHFStructures;
import superlord.prehistoricfauna.core.world.PHFSurfaceBuilders;
import superlord.prehistoricfauna.entity.HesperornithoidesEntity;
import superlord.prehistoricfauna.entity.render.PFSignTileEntityRenderer;
import superlord.prehistoricfauna.entity.tile.MessageUpdatePaleoscribe;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.ContainerRegistry;
import superlord.prehistoricfauna.init.DimensionInit;
import superlord.prehistoricfauna.init.ItemInit;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.init.ParticleInit;
import superlord.prehistoricfauna.init.PrehistoricPointofInterest;
import superlord.prehistoricfauna.init.TileEntityRegistry;
import superlord.prehistoricfauna.recipes.RecipeRegistry;
import superlord.prehistoricfauna.server.command.PHFCommand;
import superlord.prehistoricfauna.util.ClientProxy;
import superlord.prehistoricfauna.util.CommonEvents;
import superlord.prehistoricfauna.util.CommonProxy;
import superlord.prehistoricfauna.util.PFPacketHandler;
import superlord.prehistoricfauna.util.QuarkFlagRecipeCondition;
import superlord.prehistoricfauna.util.RegistryHelper;
import superlord.prehistoricfauna.world.PrehistoricFeature;

@Mod(value="prehistoricfauna")
@Mod.EventBusSubscriber(modid="prehistoricfauna", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PrehistoricFauna {
    public static final String MODID = "prehistoricfauna";
    public static Logger LOGGER = LogManager.getLogger();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("prehistoricfauna");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_WRAPPER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("prehistoricfauna", "main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();
    private static int packetsRegistered = 0;
    public static CommonProxy PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public PrehistoricFauna() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CraftingHelper.register((IConditionSerializer)new QuarkFlagRecipeCondition.Serializer());
        BlockInit.BLOCKS.register(modEventBus);
        PrehistoricPointofInterest.POI_TYPES.register(modEventBus);
        DimensionInit.MOD_DIMENSIONS.register(modEventBus);
        REGISTRY_HELPER.getDeferredBlockRegister().register(modEventBus);
        REGISTRY_HELPER.getDeferredItemRegister().register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        PrehistoricFeature.FEATURES.register(modEventBus);
        TileEntityRegistry.TILE_ENTITY_TYPES.register(modEventBus);
        ContainerRegistry.CONTAINER_TYPES.register(modEventBus);
        RecipeRegistry.RECIPES.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        ParticleInit.PARTICLE_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        PFPacketHandler.registerPackets();
        PROXY.init();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::spaceTimeContinuumWarping);
        modEventBus.addListener(this::chickenExtinction);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, PrehistoricConfigHolder.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, PrehistoricConfigHolder.SERVER_SPEC);
    }

    private boolean setIsKilled(boolean isKilled) {
        return isKilled;
    }

    public void spaceTimeContinuumWarping(LivingDeathEvent event) {
        if (PrehistoricFaunaConfig.spaceTimeContinuumWarping && event.getEntity() instanceof HesperornithoidesEntity && event.getSource().func_76346_g() instanceof PlayerEntity) {
            this.setIsKilled(true);
        }
        this.setIsKilled(false);
    }

    public void chickenExtinction(LivingSpawnEvent.CheckSpawn event) {
        if (this.setIsKilled(true) && event.getEntity() instanceof ChickenEntity) {
            event.getEntity().func_70106_y();
            event.setResult(Event.Result.DENY);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageUpdatePaleoscribe.class, MessageUpdatePaleoscribe::write, MessageUpdatePaleoscribe::read, MessageUpdatePaleoscribe.Handler::handle);
        CommonEvents.setup();
        ArrayList<Structure<NoFeatureConfig>> tempList = new ArrayList<Structure<NoFeatureConfig>>(Feature.field_214488_aQ);
        tempList.add(PrehistoricFeature.TIME_TEMPLE);
        Feature.field_214488_aQ = ImmutableList.copyOf(tempList);
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvents());
        PFFeatureRegistration.addFeatures();
        PROXY.setup();
        this.addBiomeFeatures();
        PHFOverworldBiomeRegistry.addBiomesToWeightSystem();
        Collections.sort(PHFOverworldBiomeRegistry.biomeList);
    }

    private void addBiomeFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome != PHFBiomes.HELL_CREEK_HILLS && biome != PHFBiomes.HELL_CREEK_RIVER && biome != PHFBiomes.ISCHIGUALASTO_CLEARING && biome != PHFBiomes.ISCHIGUALASTO_HILLS && biome != PHFBiomes.ISCHIGUALASTO_RIVER && biome != PHFBiomes.MORRISON_HILLS && biome != PHFBiomes.HELL_CREEK_CLEARING && biome != PHFBiomes.HELL_CREEK && biome != PHFBiomes.ISCHIGUALASTO_FOREST && biome != PHFBiomes.MORRISON_SAVANNAH && biome != Biomes.field_203616_V && biome != Biomes.field_203619_Y && biome != Biomes.field_203620_Z && biome != Biomes.field_203618_X && biome != Biomes.field_150575_M && biome != Biomes.field_203617_W && biome != Biomes.field_76776_l && biome != Biomes.field_203615_U && biome != Biomes.field_76771_b && biome != Biomes.field_203614_T && biome != Biomes.field_76777_m && biome != Biomes.field_76781_i && biome != Biomes.field_76787_r && biome != Biomes.field_150577_O && biome != Biomes.field_201939_S && biome != Biomes.field_201938_R && biome != Biomes.field_201937_Q && biome != Biomes.field_201936_P && biome != Biomes.field_76779_k && biome != Biomes.field_76778_j && biome != Biomes.field_150576_N && biome != Biomes.field_185440_P) {
                biome.func_226711_a_(PrehistoricFeature.TIME_TEMPLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
            if (biome != PHFBiomes.DUMMY) {
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, PrehistoricFeature.TIME_TEMPLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, PrehistoricFeature.PORTAL_CHAMBER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, PHFConfiguredFeatures.FOSSILIZED_CRETACEOUS_CHALK);
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, PHFConfiguredFeatures.FOSSILIZED_TRIASSIC_SANDSTONE);
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, PHFConfiguredFeatures.FOSSILIZED_JURASSIC_SILTSTONE);
                biome.func_226711_a_(PrehistoricFeature.PORTAL_CHAMBER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
            if (biome != Biomes.field_76772_c && biome != Biomes.field_185441_Q && biome != Biomes.field_76767_f && biome != Biomes.field_150583_P && biome != Biomes.field_150582_Q && biome != Biomes.field_185444_T && biome != Biomes.field_185448_Z && biome != Biomes.field_185432_ad && biome != Biomes.field_76768_g && biome != Biomes.field_76784_u && biome != Biomes.field_150590_f && biome != Biomes.field_185433_ae && biome != Biomes.field_150578_U && biome != Biomes.field_150581_V && biome != Biomes.field_150584_S && biome != Biomes.field_150579_T && biome != Biomes.field_185431_ac && biome != Biomes.field_76783_v && biome != Biomes.field_76770_e && biome != Biomes.field_185443_S && biome != Biomes.field_150588_X && biome != Biomes.field_150587_Y && biome != Biomes.field_76774_n && biome != Biomes.field_76785_t && biome != Biomes.field_150580_W && biome != PHFOverworldBiomeRegistry.PETRIFIED_FOREST) continue;
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, PrehistoricFeature.GEOLOGIST_CAMP.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            biome.func_226711_a_(PrehistoricFeature.GEOLOGIST_CAMP.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T entry, String registryKey) {
        entry.setRegistryName(new ResourceLocation(MODID, registryKey));
        registry.register(entry);
        return entry;
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        PrehistoricFauna.trySetRandomPanorama();
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void loadCompleteEvent(FMLLoadCompleteEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void trySetRandomPanorama() {
        ModFileResourcePack resourcePack;
        Set<String> folders;
        Optional optionalResourcePack = ResourcePackLoader.getResourcePackFor((String)MODID);
        if (optionalResourcePack.isPresent() && (folders = PrehistoricFauna.getSubfoldersFromDirectory((resourcePack = (ModFileResourcePack)optionalResourcePack.get()).getModFile(), "assets/prehistoricfauna/panoramas")).size() > 0) {
            String chosenPanorama = (String)folders.toArray()[new Random().nextInt(folders.size())];
            ResourceLocation panoramaLoc = new ResourceLocation(MODID, "panoramas/" + chosenPanorama + "/panorama");
            ResourceLocation[] ResourceLocationsArray = new ResourceLocation[6];
            for (int i = 0; i < 6; ++i) {
                ResourceLocationsArray[i] = new ResourceLocation(panoramaLoc.func_110624_b(), panoramaLoc.func_110623_a() + '_' + i + ".png");
            }
            ObfuscationReflectionHelper.setPrivateValue(RenderSkyboxCube.class, (Object)MainMenuScreen.field_213098_a, (Object)ResourceLocationsArray, (String)"field_209143_a");
        }
    }

    private static Set<String> getSubfoldersFromDirectory(ModFile modFile, String directoryName) {
        try {
            Path root = modFile.getLocator().findPath((IModFile)modFile, new String[]{directoryName}).toAbsolutePath();
            return Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    public static <MSG> void sendMSGToServer(MSG message) {
        NETWORK_WRAPPER.sendToServer(message);
    }

    public static <MSG> void sendMSGToAll(MSG message) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            PrehistoricFauna.sendNonLocal(message, player);
        }
    }

    public static <MSG> void sendNonLocal(MSG msg, ServerPlayerEntity player) {
        if (player.field_71133_b.func_71262_S() || !player.func_200200_C_().equals(player.field_71133_b.func_71214_G())) {
            NETWORK_WRAPPER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TileEntityRegistry.PF_SIGNS.get()), PFSignTileEntityRenderer::new);
    }

    public static class ServerEvents {
        @SubscribeEvent
        public void commandRegisterEvent(FMLServerStartingEvent event) {
            LOGGER.debug("Prehistoric Fauna: \"Server Starting\" Event Starting...");
            PHFCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
            LOGGER.info("Prehistoric Fauna: \"Server Starting\" Event Complete!");
        }
    }

    @Mod.EventBusSubscriber(modid="prehistoricfauna", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class PHFWorldGenRegistries {
        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            LOGGER.debug("PHF: Registering biomes...");
            PHFBiomes.init();
            PHFBiomes.biomes.sort(Comparator.comparingInt(PHFBiomes.PreserveBiomeOrder::getOrderPosition));
            PHFBiomes.biomes.forEach(preserveBiomeOrder -> event.getRegistry().register((IForgeRegistryEntry)preserveBiomeOrder.getBiome()));
            LOGGER.info("PHF: Biomes registered!");
        }

        @SubscribeEvent
        public static void registerDecorators(RegistryEvent.Register<Placement<?>> event) {
            LOGGER.debug("PHF: Registering decorators...");
            PHFDecorators.init();
            PHFDecorators.decorators.forEach(decorator -> event.getRegistry().register((IForgeRegistryEntry)decorator));
            LOGGER.info("PHF: Decorators registered!");
        }

        @SubscribeEvent
        public static void registerStructures(RegistryEvent.Register<Feature<?>> event) {
            LOGGER.debug("PHF: Registering structures...");
            PHFStructures.init();
            LOGGER.info("PHF: Structures registered!");
        }

        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            LOGGER.debug("PHF: Registering features...");
            PHFFeatures.init();
            PHFFeatures.features.forEach(feature -> event.getRegistry().register((IForgeRegistryEntry)feature));
            LOGGER.info("PHF: Features registered!");
        }

        @SubscribeEvent
        public static void registerSurfaceBuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            LOGGER.debug("PHF: Registering surface builders...");
            PHFSurfaceBuilders.init();
            PHFSurfaceBuilders.surfaceBuilders.forEach(surfaceBuilder -> event.getRegistry().register((IForgeRegistryEntry)surfaceBuilder));
            LOGGER.info("PHF: Surface builders Registered!");
        }
    }

    public static class PFSkeleton
    extends ItemGroup {
        public static final PFSkeleton instance = new PFSkeleton(ItemGroup.field_78032_a.length, "prehistoric_skeleton_tab");

        private PFSkeleton(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemInit.TYRANNOSAURUS_SKULL.get());
        }
    }

    public static class PFDecoration
    extends ItemGroup {
        public static final PFDecoration instance = new PFDecoration(ItemGroup.field_78032_a.length, "prehistoric_decoration_tab");

        private PFDecoration(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)BlockInit.LARGE_AMMONITE_FOSSIL.func_199767_j());
        }
    }

    public static class PFEggs
    extends ItemGroup {
        public static final PFEggs instance = new PFEggs(ItemGroup.field_78032_a.length, "prehistoric_eggs_tab");

        private PFEggs(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemInit.ALLOSAURUS_SPAWN_EGG.get());
        }
    }

    public static class PFFood
    extends ItemGroup {
        public static final PFFood instance = new PFFood(ItemGroup.field_78032_a.length, "prehistoric_food_tab");

        private PFFood(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemInit.RAW_THESCELOSAURUS_MEAT.get());
        }
    }

    public static class PFBuilding
    extends ItemGroup {
        public static final PFBuilding instance = new PFBuilding(ItemGroup.field_78032_a.length, "prehistoric_building_tab");

        private PFBuilding(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)BlockInit.ARAUCARIA_LOG);
        }
    }

    public static class PFMisc
    extends ItemGroup {
        public static final PFMisc instance = new PFMisc(ItemGroup.field_78032_a.length, "prehistoric_misc_tab");

        private PFMisc(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemInit.PALEOPEDIA.get());
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
            PrehistoricFeature.registerFeatures(event);
            LOGGER.log(Level.INFO, "features/structures registered.");
        }
    }
}

