/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.entity.DidelphodonEntity;
import superlord.prehistoricfauna.init.BlockInit;

public class CrassostreaOysterBlock
extends BushBlock
implements IGrowable,
ILiquidContainer {
    public static final IntegerProperty AGE = BlockStateProperties.field_208167_T;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public CrassostreaOysterBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_224755_d(worldIn, pos, Direction.UP) && state.func_177230_c() == Blocks.field_150354_m;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 2;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float f;
        int i;
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = CrassostreaOysterBlock.getGrowthChance((Block)this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8 ? super.func_196258_a(context) : null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState blockstate = super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!blockstate.func_196958_f()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return blockstate;
    }

    public void grow(World worldIn, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)1, (int)2);
    }

    protected static float getGrowthChance(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof DidelphodonEntity && ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entityIn)) {
            world.func_225521_a_(pos, false, entityIn);
        }
        super.func_196262_a(state, world, pos, entityIn);
    }

    protected IItemProvider getSeedsItem() {
        return BlockInit.CRASSOSTREA_OYSTER.func_199767_j();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getSeedsItem());
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow((World)worldIn, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public IFluidState func_204507_t(BlockState state) {
        return Fluids.field_204546_a.func_207204_a(false);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return false;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        return false;
    }
}

