/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.block;

import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.DimensionTypeInit;
import superlord.prehistoricfauna.init.ParticleInit;
import superlord.prehistoricfauna.util.TeleporterCretaceous;

public class CretaceousPortalBlock
extends BreakableBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public CretaceousPortalBlock(Block.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean tryToCreatePortal(World worldIn, BlockPos pos) {
        Size portalSize = this.isPortal((IWorld)worldIn, pos);
        if (portalSize != null && this.canCreatePortalByWorld(worldIn, pos)) {
            portalSize.placePortalBlocks();
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(World world, BlockPos pos) {
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_) {
            return true;
        }
        return world.func_201675_m().func_186058_p() == DimensionTypeInit.CRETACEOUS_DIMENSION_TYPE || world.func_201675_m().func_186058_p() == DimensionTypeInit.JURASSIC_DIMENSION_TYPE || world.func_201675_m().func_186058_p() == DimensionTypeInit.TRIASSIC_DIMENSION_TYPE;
    }

    @Nullable
    public Size isPortal(IWorld world, BlockPos pos) {
        Size gaiaPortalSizeX = new Size(world, pos, Direction.Axis.X);
        if (gaiaPortalSizeX.isValid() && gaiaPortalSizeX.portalBlockCount == 0) {
            return gaiaPortalSizeX;
        }
        Size gaiaPortalSizeZ = new Size(world, pos, Direction.Axis.Z);
        return gaiaPortalSizeZ.isValid() && gaiaPortalSizeZ.portalBlockCount == 0 ? gaiaPortalSizeZ : null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new NetherPortalBlock.Size(worldIn, currentPos, direction$axis1).func_208508_f() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = entity.func_82147_ab();
            } else {
                if (!entity.field_70170_p.field_72995_K && !pos.equals((Object)entity.field_181016_an)) {
                    entity.field_181016_an = new BlockPos((Vec3i)pos);
                    BlockPattern.PatternHelper helper = CretaceousPortalBlock.createPatternHelper((IWorld)entity.field_70170_p, entity.field_181016_an);
                    double axis = helper.func_177669_b().func_176740_k() == Direction.Axis.X ? (double)helper.func_181117_a().func_177952_p() : (double)helper.func_181117_a().func_177958_n();
                    double x = Math.abs(MathHelper.func_181160_c((double)((helper.func_177669_b().func_176740_k() == Direction.Axis.X ? entity.func_226281_cx_() : entity.func_226277_ct_()) - (double)(helper.func_177669_b().func_176746_e().func_176743_c() == Direction.AxisDirection.NEGATIVE ? 1 : 0)), (double)axis, (double)(axis - (double)helper.func_181118_d())));
                    double y = MathHelper.func_181160_c((double)(entity.func_226278_cu_() - 1.0), (double)helper.func_181117_a().func_177956_o(), (double)(helper.func_181117_a().func_177956_o() - helper.func_181119_e()));
                    entity.field_181017_ao = new Vec3d(x, y, 0.0);
                    entity.field_181018_ap = helper.func_177669_b();
                }
                if (entity.field_70170_p instanceof ServerWorld && entity.field_70170_p.func_73046_m().func_71255_r() && !entity.func_184218_aH()) {
                    entity.field_71088_bW = entity.func_82147_ab();
                    DimensionType type = worldIn.field_73011_w.func_186058_p() == DimensionTypeInit.CRETACEOUS_DIMENSION_TYPE ? DimensionType.field_223227_a_ : DimensionTypeInit.CRETACEOUS_DIMENSION_TYPE;
                    entity.changeDimension(type, (ITeleporter)new TeleporterCretaceous());
                }
            }
        }
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (float)pos.func_177958_n() + rand.nextFloat();
            double y = (float)pos.func_177956_o() + rand.nextFloat();
            double z = (float)pos.func_177952_p() + rand.nextFloat();
            double sX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int mul = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)mul;
                sX = rand.nextFloat() * 2.0f * (float)mul;
            } else {
                z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)mul;
                sZ = rand.nextFloat() * 2.0f * (float)mul;
            }
            world.func_195594_a((IParticleData)ParticleInit.CRETACEOUS.get(), x, y, z, sX, sY, sZ);
        }
    }

    public static BlockPattern.PatternHelper createPatternHelper(IWorld worldIn, BlockPos pos) {
        Direction.Axis axis = Direction.Axis.Z;
        Size size = new Size(worldIn, pos, Direction.Axis.X);
        LoadingCache cache = BlockPattern.func_181627_a((IWorldReader)worldIn, (boolean)true);
        if (!size.isValid()) {
            axis = Direction.Axis.X;
            size = new Size(worldIn, pos, Direction.Axis.Z);
        }
        if (!size.isValid()) {
            return new BlockPattern.PatternHelper(pos, Direction.NORTH, Direction.UP, cache, 1, 1, 1);
        }
        int[] axes = new int[Direction.AxisDirection.values().length];
        Direction direction = size.rightDir.func_176735_f();
        BlockPos blockpos = size.bottomLeft.func_177981_b(size.getHeight() - 1);
        for (Direction.AxisDirection axisDir : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper helper = new BlockPattern.PatternHelper(direction.func_176743_c() == axisDir ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)axisDir, (Direction.Axis)axis), Direction.UP, cache, size.getWidth(), size.getHeight(), 1);
            for (int i = 0; i < size.getWidth(); ++i) {
                for (int j = 0; j < size.getHeight(); ++j) {
                    CachedBlockInfo cacheInfo = helper.func_177670_a(i, j, 1);
                    if (cacheInfo.func_177509_a().func_196958_f()) continue;
                    int n = axisDir.ordinal();
                    axes[n] = axes[n] + 1;
                }
            }
        }
        Direction.AxisDirection axisDirPos = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection axisDir : Direction.AxisDirection.values()) {
            if (axes[axisDir.ordinal()] >= axes[axisDirPos.ordinal()]) continue;
            axisDirPos = axisDir;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == axisDirPos ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)axisDirPos, (Direction.Axis)axis), Direction.UP, cache, size.getWidth(), size.getHeight(), 1);
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private final Block PORTAL_FRAME = BlockInit.PORTAL_FRAME;
        private final Block PORTAL = (Block)BlockInit.CRETACEOUS_PORTAL.get();

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis facing) {
            this.world = worldIn;
            this.axis = facing;
            if (facing == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 3 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.world.func_180495_p(blockpos.func_177977_b()) == this.PORTAL_FRAME.func_176223_P(); ++i) {
            }
            Block block = this.world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c();
            return block == this.PORTAL_FRAME ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.isEmptyBlock(blockstate)) break block0;
                    if (blockstate.func_177230_c() == this.PORTAL) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (blockstate = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir))) != this.PORTAL_FRAME.func_176223_P() : i == this.width && (blockstate = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir))) != this.PORTAL_FRAME.func_176223_P()) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)) == this.PORTAL_FRAME.func_176223_P()) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        boolean isEmptyBlock(BlockState state) {
            Block block = state.func_177230_c();
            return state.func_196958_f() || block == BlockInit.CRETACEOUS_TIME_BLOCK || block == this.PORTAL;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 3 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)this.PORTAL.func_176223_P().func_206870_a(AXIS, (Comparable)this.axis), 2);
                }
            }
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }
    }
}

