/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import superlord.prehistoricfauna.block.PtilophyllumBlock;
import superlord.prehistoricfauna.init.BlockInit;

public class PtilophyllumBaseBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.field_208169_V;
    private final PtilophyllumBlock plantBlock;
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public PtilophyllumBaseBlock(PtilophyllumBlock plantBlockIn, Block.Properties builder) {
        super(builder);
        this.plantBlock = plantBlockIn;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else {
            int i;
            BlockPos blockpos = pos.func_177984_a();
            if (worldIn.func_175623_d(blockpos) && blockpos.func_177956_o() < worldIn.func_201675_m().getHeight() && (i = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) < 5 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                boolean flag = false;
                boolean flag1 = false;
                BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
                Block block = blockstate.func_177230_c();
                if (block == BlockInit.SILT || block == BlockInit.HARDENED_SILT) {
                    flag = true;
                } else if (block == this.plantBlock) {
                    int j = 1;
                    for (int k = 0; k < 4; ++k) {
                        Block block1 = worldIn.func_180495_p(pos.func_177979_c(j + 1)).func_177230_c();
                        if (block1 != this.plantBlock) {
                            if (block1 != BlockInit.SILT && block1 != BlockInit.HARDENED_SILT) break;
                            flag1 = true;
                            break;
                        }
                        ++j;
                    }
                    if (j < 2 || j <= rand.nextInt(flag1 ? 5 : 4)) {
                        flag = true;
                    }
                } else if (blockstate.isAir((IBlockReader)worldIn, pos.func_177977_b())) {
                    flag = true;
                }
                if (flag && PtilophyllumBaseBlock.areAllNeighborsEmpty((IWorldReader)worldIn, blockpos, null) && worldIn.func_175623_d(pos.func_177981_b(2))) {
                    worldIn.func_180501_a(pos, this.plantBlock.makeConnections((IBlockReader)worldIn, pos), 2);
                    this.placeGrownFlower((World)worldIn, blockpos, i);
                } else if (i < 4) {
                    int l = rand.nextInt(4);
                    if (flag1) {
                        ++l;
                    }
                    boolean flag2 = false;
                    for (int i1 = 0; i1 < l; ++i1) {
                        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                        BlockPos blockpos1 = pos.func_177972_a(direction);
                        if (!worldIn.func_175623_d(blockpos1) || !worldIn.func_175623_d(blockpos1.func_177977_b()) || !PtilophyllumBaseBlock.areAllNeighborsEmpty((IWorldReader)worldIn, blockpos1, direction.func_176734_d())) continue;
                        this.placeGrownFlower((World)worldIn, blockpos1, i + 1);
                        flag2 = true;
                    }
                    if (flag2) {
                        worldIn.func_180501_a(pos, this.plantBlock.makeConnections((IBlockReader)worldIn, pos), 2);
                    } else {
                        this.placeDeadFlower((World)worldIn, pos);
                    }
                } else {
                    this.placeDeadFlower((World)worldIn, pos);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private void placeGrownFlower(World worldIn, BlockPos pos, int age) {
        worldIn.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), 2);
    }

    private void placeDeadFlower(World worldIn, BlockPos pos) {
        worldIn.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(5)), 2);
    }

    private static boolean areAllNeighborsEmpty(IWorldReader worldIn, BlockPos pos, @Nullable Direction excludingSide) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == excludingSide || worldIn.func_175623_d(pos.func_177972_a(direction))) continue;
            return false;
        }
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = blockstate.func_177230_c();
        if (block != this.plantBlock && block != BlockInit.SILT || block != this.plantBlock && block != BlockInit.HARDENED_SILT) {
            if (!blockstate.isAir((IBlockReader)worldIn, pos.func_177977_b())) {
                return false;
            }
            boolean flag = false;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction));
                if (blockstate1.func_177230_c() == this.plantBlock) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                    continue;
                }
                if (blockstate1.isAir((IBlockReader)worldIn, pos.func_177972_a(direction))) continue;
                return false;
            }
            return flag;
        }
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public static void generatePlant(IWorld worldIn, BlockPos pos, Random rand, int p_185603_3_) {
        worldIn.func_180501_a(pos, ((PtilophyllumBlock)BlockInit.PTILOPHYLLUM_WOOD).makeConnections((IBlockReader)worldIn, pos), 2);
        PtilophyllumBaseBlock.growTreeRecursive(worldIn, pos, rand, pos, p_185603_3_, 0);
    }

    private static void growTreeRecursive(IWorld worldIn, BlockPos p_185601_1_, Random rand, BlockPos p_185601_3_, int p_185601_4_, int p_185601_5_) {
        PtilophyllumBlock ptilophullumwoodblock = (PtilophyllumBlock)BlockInit.PTILOPHYLLUM_WOOD;
        int i = rand.nextInt(4) + 1;
        if (p_185601_5_ == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockpos = p_185601_1_.func_177981_b(j + 1);
            if (!PtilophyllumBaseBlock.areAllNeighborsEmpty((IWorldReader)worldIn, blockpos, null)) {
                return;
            }
            worldIn.func_180501_a(blockpos, ptilophullumwoodblock.makeConnections((IBlockReader)worldIn, blockpos), 2);
            worldIn.func_180501_a(blockpos.func_177977_b(), ptilophullumwoodblock.makeConnections((IBlockReader)worldIn, blockpos.func_177977_b()), 2);
        }
        boolean flag = false;
        if (p_185601_5_ < 4) {
            int l = rand.nextInt(4);
            if (p_185601_5_ == 0) {
                ++l;
            }
            for (int k = 0; k < l; ++k) {
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                BlockPos blockpos1 = p_185601_1_.func_177981_b(i).func_177972_a(direction);
                if (Math.abs(blockpos1.func_177958_n() - p_185601_3_.func_177958_n()) >= p_185601_4_ || Math.abs(blockpos1.func_177952_p() - p_185601_3_.func_177952_p()) >= p_185601_4_ || !worldIn.func_175623_d(blockpos1) || !worldIn.func_175623_d(blockpos1.func_177977_b()) || !PtilophyllumBaseBlock.areAllNeighborsEmpty((IWorldReader)worldIn, blockpos1, direction.func_176734_d())) continue;
                flag = true;
                worldIn.func_180501_a(blockpos1, ptilophullumwoodblock.makeConnections((IBlockReader)worldIn, blockpos1), 2);
                worldIn.func_180501_a(blockpos1.func_177972_a(direction.func_176734_d()), ptilophullumwoodblock.makeConnections((IBlockReader)worldIn, blockpos1.func_177972_a(direction.func_176734_d())), 2);
                PtilophyllumBaseBlock.growTreeRecursive(worldIn, blockpos1, rand, p_185601_3_, p_185601_4_, p_185601_5_ + 1);
            }
        }
        if (!flag) {
            worldIn.func_180501_a(p_185601_1_.func_177981_b(i), (BlockState)BlockInit.PTILOPHYLLUM_BASE.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(5)), 2);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BASE_SHAPE;
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        BlockPos blockpos = hit.func_216350_a();
        worldIn.func_225521_a_(blockpos, true, projectile);
    }
}

