/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import superlord.prehistoricfauna.init.CustomDamageSourceInit;

public class TrapBlock
extends Block {
    protected static final VoxelShape PRESSED_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    protected static final VoxelShape UNPRESSED_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final AxisAlignedBB PRESSURE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 15.0, 16.0, 15.0);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private final Sensitivity sensitivity;

    public TrapBlock(Sensitivity sensitivity, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = sensitivity;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getRedstoneStrength(state) > 0 ? PRESSED_AABB : UNPRESSED_AABB;
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 20;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int i = this.getRedstoneStrength(state);
        if (i > 0) {
            this.updateState((World)worldIn, pos, state, i);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            int i = this.getRedstoneStrength(state);
            if (i == 0) {
                this.updateState(worldIn, pos, state, i);
            }
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                entityIn.func_70097_a(CustomDamageSourceInit.HENOSTONE_TRAP, 2.0f);
            }
        }
    }

    protected void updateState(World worldIn, BlockPos pos, BlockState state, int oldRedstoneStrength) {
        boolean flag1;
        int i = this.computeRedstoneStrength(worldIn, pos);
        boolean flag = oldRedstoneStrength > 0;
        boolean bl = flag1 = i > 0;
        if (oldRedstoneStrength != i) {
            BlockState blockstate = this.setRedstoneStrength(state, i);
            worldIn.func_180501_a(pos, blockstate, 2);
            this.updateNeighbors(worldIn, pos);
            worldIn.func_225319_b(pos, state, blockstate);
        }
        if (!flag1 && flag) {
            this.playClickOffSound((IWorld)worldIn, pos);
        } else if (flag1 && !flag) {
            this.playClickOnSound((IWorld)worldIn, pos);
        }
        if (flag1) {
            worldIn.func_205220_G_().func_205360_a(new BlockPos((Vec3i)pos), (Object)this, this.func_149738_a((IWorldReader)worldIn));
        }
    }

    protected void playClickOnSound(IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
    }

    protected void playClickOffSound(IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (this.getRedstoneStrength(state) > 0) {
                this.updateNeighbors(worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.func_195593_d(pos, (Block)this);
    }

    protected int getRedstoneStrength(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    protected BlockState setRedstoneStrength(BlockState state, int strength) {
        return (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    protected int computeRedstoneStrength(World worldIn, BlockPos pos) {
        List list;
        AxisAlignedBB axisalignedbb = PRESSURE_AABB.func_186670_a(pos);
        switch (this.sensitivity) {
            case MOBS: {
                list = worldIn.func_217357_a(LivingEntity.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_145773_az()) continue;
                return 15;
            }
        }
        return 0;
    }

    public static enum Sensitivity {
        MOBS;

    }
}

