/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.core.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import superlord.prehistoricfauna.world.biomes.PetrifiedForestBiome;

@Mod.EventBusSubscriber(modid="prehistoricfauna", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PHFOverworldBiomeRegistry {
    public static List<String> biomeList = new ArrayList<String>();
    public static final Biome PETRIFIED_FOREST = new PetrifiedForestBiome();

    @SubscribeEvent
    public static void registerPFBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        PHFOverworldBiomeRegistry.registerBiome((IForgeRegistry<Biome>)registry, PETRIFIED_FOREST, "petrified_forest", true, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WASTELAND);
    }

    public static void addBiomesToWeightSystem() {
        PHFOverworldBiomeRegistry.addBiomeEntry(PETRIFIED_FOREST, 4, BiomeManager.BiomeType.DESERT);
    }

    private static void registerBiome(IForgeRegistry<Biome> registry, Biome biome, String name, boolean spawn, BiomeDictionary.Type ... types) {
        registry.register(biome.setRegistryName("prehistoricfauna", name));
        if (spawn) {
            BiomeManager.addSpawnBiome((Biome)biome);
        }
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        biomeList.add(name);
    }

    public static void addBiomeEntry(Biome biome, int weight, BiomeManager.BiomeType type) {
        if (weight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
        }
    }
}

