/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.core.world.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import superlord.prehistoricfauna.PrehistoricFauna;
import superlord.prehistoricfauna.core.world.PHFBiomes;
import superlord.prehistoricfauna.core.world.PHFDecorators;
import superlord.prehistoricfauna.core.world.PHFFeatures;
import superlord.prehistoricfauna.core.world.PHFStructures;

public class WorldGenRegistrationHelper {
    static Set<Integer> integerList = new HashSet<Integer>();

    public static <SBC extends ISurfaceBuilderConfig, SB extends SurfaceBuilder<SBC>> SB createSurfaceBuilder(String id, SB surfaceBuilder) {
        ResourceLocation phfID = new ResourceLocation("prehistoricfauna", id);
        if (Registry.field_218378_p.func_148742_b().contains(phfID)) {
            throw new IllegalStateException("Surface Builder ID: \"" + phfID.toString() + "\" already exists in the Surface Builder registry!");
        }
        surfaceBuilder.setRegistryName(phfID);
        return surfaceBuilder;
    }

    public static <SC extends ISurfaceBuilderConfig, CSB extends ConfiguredSurfaceBuilder<SC>> CSB createConfiguredSurfaceBuilder(String id, CSB configuredSurfaceBuilder) {
        ResourceLocation phfID = new ResourceLocation("prehistoricfauna", id);
        return configuredSurfaceBuilder;
    }

    public static <C extends IFeatureConfig, F extends Feature<C>> F createFeature(String id, F feature) {
        ResourceLocation phfID = new ResourceLocation("prehistoricfauna", id);
        if (Registry.field_218379_q.func_148742_b().contains(phfID)) {
            throw new IllegalStateException("Feature ID: \"" + phfID.toString() + "\" already exists in the Features registry!");
        }
        feature.setRegistryName(phfID);
        PHFFeatures.features.add(feature);
        return feature;
    }

    public static <C extends IFeatureConfig, F extends Structure<C>> F createStructure(String id, F structure, int minChunkDistance, int maxChunkDistance, int seedModifier, GenerationStage.Decoration decorationStage) {
        ResourceLocation phfID = new ResourceLocation("prehistoricfauna", id);
        if (Registry.field_218361_B.func_148742_b().contains(phfID)) {
            throw new IllegalStateException("Structure Feature ID: \"" + phfID.toString() + "\" already exists in the Structure Features registry!");
        }
        structure.setRegistryName(phfID);
        PHFStructures.structures.add(structure);
        return structure;
    }

    public static IStructurePieceType createStructurePiece(String id, IStructurePieceType piece) {
        Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("prehistoricfauna", id), (Object)piece);
        return piece;
    }

    public static <FC extends IFeatureConfig, F extends Feature<FC>, CF extends ConfiguredFeature<FC, F>> CF createConfiguredFeature(String id, CF configuredFeature) {
        ResourceLocation phfID = new ResourceLocation("prehistoricfauna", id);
        return configuredFeature;
    }

    public static <DC extends IPlacementConfig, D extends Placement<DC>> D createDecorator(String id, D decorator) {
        ResourceLocation phfID = new ResourceLocation("prehistoricfauna", id);
        if (Registry.field_218380_r.func_148742_b().contains(phfID)) {
            throw new IllegalStateException("Decorator ID: \"" + phfID.toString() + "\" already exists in the Decorator registry!");
        }
        decorator.setRegistryName(phfID);
        PHFDecorators.decorators.add(decorator);
        return decorator;
    }

    public static Biome createBiome(String id, Biome biome, int numericalID) {
        ResourceLocation phfID = new ResourceLocation("prehistoricfauna", id);
        if (Registry.field_212624_m.func_148742_b().contains(phfID)) {
            throw new IllegalStateException("Biome ID: \"" + phfID.toString() + "\" already exists in the Biome registry!");
        }
        biome.setRegistryName(phfID);
        if (integerList.contains(numericalID)) {
            PrehistoricFauna.LOGGER.warn("Duplicate Biome Numerical ID: " + numericalID + " at byg:" + id);
        }
        PHFBiomes.biomes.add(new PHFBiomes.PreserveBiomeOrder(biome, numericalID));
        integerList.add(numericalID);
        return biome;
    }
}

