/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity;

import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.block.BasilemysEggBlock;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.util.SoundHandler;

public class BasilemysEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(BasilemysEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(BasilemysEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_PANICING = EntityDataManager.func_187226_a(BasilemysEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{BlockInit.HORSETAIL.func_199767_j()});
    private int isDigging;

    public BasilemysEntity(EntityType<? extends BasilemysEntity> type, World world) {
        super(type, world);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean isPanicing() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_PANICING);
    }

    private void setPanicing(boolean isPanicing) {
        this.field_70180_af.func_187227_b(IS_PANICING, (Object)isPanicing);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == BlockInit.HORSETAIL.func_199767_j();
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        BasilemysEntity entity = new BasilemysEntity(ModEntityTypes.BASILEMYS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.BREEDING, null, null);
        return entity;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(IS_PANICING, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("IsPanicing", this.isPanicing());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setPanicing(compound.func_74767_n("IsPanicing"));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.BASILEMYS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundHandler.BASILEMYS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.BASILEMYS_DEATH;
    }

    public boolean func_204701_dC() {
        return super.func_204701_dC() && !this.hasEgg();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    static class MateGoal
    extends BreedGoal {
        private final BasilemysEntity basilemys;

        MateGoal(BasilemysEntity basilemys, double speed) {
            super((AnimalEntity)basilemys, speed);
            this.basilemys = basilemys;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.basilemys.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() != null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.basilemys.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final BasilemysEntity basilemys;

        LayEggGoal(BasilemysEntity basilemys, double speed) {
            super((CreatureEntity)basilemys, speed, 16);
            this.basilemys = basilemys;
        }

        public boolean func_75250_a() {
            return this.basilemys.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.basilemys.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos((Entity)this.basilemys);
            if (this.basilemys.func_70090_H() && this.func_179487_f()) {
                if (this.basilemys.isDigging < 1) {
                    this.basilemys.setDigging(true);
                } else if (this.basilemys.isDigging > 200) {
                    World world = this.basilemys.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)BlockInit.BASILEMYS_EGG.func_176223_P().func_206870_a((IProperty)BasilemysEggBlock.EGGS, (Comparable)Integer.valueOf(this.basilemys.field_70146_Z.nextInt(4) + 1)), 3);
                    this.basilemys.setHasEgg(false);
                    this.basilemys.setDigging(false);
                    this.basilemys.func_204700_e(600);
                }
                if (this.basilemys.isDigging()) {
                    this.basilemys.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
            if (!world.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = world.func_180495_p(pos).func_177230_c();
            return block == BlockInit.LOAM || block == BlockInit.MOSSY_DIRT || block == Blocks.field_196661_l;
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        PanicGoal(BasilemysEntity turtle, double speedIn) {
            super((CreatureEntity)turtle, speedIn);
        }

        public boolean func_75250_a() {
            return this.field_75267_a.func_70643_av() != null || this.field_75267_a.func_70027_ad();
        }

        public void func_75249_e() {
            BasilemysEntity.this.setPanicing(true);
            BasilemysEntity.this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(100.0);
            BasilemysEntity.this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
            BasilemysEntity.this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(100.0);
        }

        public void func_75251_c() {
            BasilemysEntity.this.setPanicing(false);
            BasilemysEntity.this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            BasilemysEntity.this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            BasilemysEntity.this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(0.0);
        }
    }
}

