/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.block.DakotaraptorEggBlock;
import superlord.prehistoricfauna.entity.AllosaurusEntity;
import superlord.prehistoricfauna.entity.AnkylosaurusEntity;
import superlord.prehistoricfauna.entity.BasilemysEntity;
import superlord.prehistoricfauna.entity.CamarasaurusEntity;
import superlord.prehistoricfauna.entity.CeratosaurusEntity;
import superlord.prehistoricfauna.entity.DidelphodonEntity;
import superlord.prehistoricfauna.entity.DryosaurusEntity;
import superlord.prehistoricfauna.entity.EilenodonEntity;
import superlord.prehistoricfauna.entity.HesperornithoidesEntity;
import superlord.prehistoricfauna.entity.StegosaurusEntity;
import superlord.prehistoricfauna.entity.ThescelosaurusEntity;
import superlord.prehistoricfauna.entity.TriceratopsEntity;
import superlord.prehistoricfauna.entity.TyrannosaurusEntity;
import superlord.prehistoricfauna.entity.goal.HuntGoal;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.ItemInit;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.util.SoundHandler;

public class DakotaraptorEntity
extends AnimalEntity {
    private static final DataParameter<Byte> DAKOTARAPTOR_FLAGS = EntityDataManager.func_187226_a(DakotaraptorEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(DakotaraptorEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Predicate<Entity> IS_PREY = p_213498_0_ -> p_213498_0_ instanceof ThescelosaurusEntity || p_213498_0_ instanceof BasilemysEntity || p_213498_0_ instanceof DryosaurusEntity || p_213498_0_ instanceof HesperornithoidesEntity || p_213498_0_ instanceof EilenodonEntity || p_213498_0_ instanceof DidelphodonEntity || p_213498_0_ instanceof PlayerEntity;
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(DakotaraptorEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(DakotaraptorEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private Goal attackAnimals;
    private float interestedAngle;
    private float interestedAngleO;
    private float crouchAmount;
    private float crouchAmountO;
    private int warningSoundTicks;
    private int isDigging;
    private int eatTicks;

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ItemInit.RAW_THESCELOSAURUS_MEAT.get();
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    public DakotaraptorEntity(EntityType<? extends DakotaraptorEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new LookHelperController();
        this.field_70765_h = new MoveHelperController();
        this.func_184644_a(PathNodeType.DANGER_OTHER, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_OTHER, 0.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(DAKOTARAPTOR_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected void func_184651_r() {
        this.attackAnimals = new HuntGoal((MobEntity)this, AnimalEntity.class, 10, false, false, p_213487_0_ -> p_213487_0_ instanceof ThescelosaurusEntity || p_213487_0_ instanceof BasilemysEntity || p_213487_0_ instanceof DryosaurusEntity || p_213487_0_ instanceof HesperornithoidesEntity || p_213487_0_ instanceof EilenodonEntity || p_213487_0_ instanceof DidelphodonEntity || p_213487_0_ instanceof HorseEntity || p_213487_0_ instanceof DonkeyEntity || p_213487_0_ instanceof MuleEntity || p_213487_0_ instanceof SheepEntity || p_213487_0_ instanceof CowEntity || p_213487_0_ instanceof PigEntity || p_213487_0_ instanceof OcelotEntity);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new JumpGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new MateGoal(this, 1.0));
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowTargetGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new PounceGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new FindShelterGoal(1.25));
        this.field_70714_bg.func_75776_a(7, (Goal)new BiteGoal(1.2f, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new SleepGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowGoal(this, 1.25));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70714_bg.func_75776_a(10, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(11, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(12, (Goal)new WatchGoal((MobEntity)this, PlayerEntity.class, 24.0f));
        this.field_70714_bg.func_75776_a(13, (Goal)new SitAndLookGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, AnkylosaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, TriceratopsEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, TyrannosaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, CamarasaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, StegosaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, AllosaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, CeratosaurusEntity.class, 7.0f, 1.25, 1.25));
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            LivingEntity livingentity;
            ++this.eatTicks;
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (this.canEatItem(itemstack)) {
                if (this.eatTicks > 600) {
                    ItemStack itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                    if (!itemstack1.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                    }
                    this.eatTicks = 0;
                } else if (this.eatTicks > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
            }
            if ((livingentity = this.func_70638_az()) == null || !livingentity.func_70089_S()) {
                this.setCrouching(false);
                this.func_213502_u(false);
            }
        }
        if (this.func_70638_az() != null && this.func_184187_bx() != null && this.func_184187_bx() == this.func_70638_az() && this.field_70173_aa % 20 == 0) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)iattributeinstance.func_111125_b());
        }
        if (this.func_70608_bn() || this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        }
        super.func_70636_d();
        if (!this.isDakotaraptorAggroed() || this.field_70146_Z.nextFloat() < 0.05f) {
            // empty if block
        }
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.func_77973_b().func_219971_r() && itemStackIn.func_77973_b().func_219967_s().func_221467_c() && this.func_70638_az() == null && this.field_70122_E && !this.func_70608_bn();
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f;
    }

    public boolean func_175448_a(ItemStack stack) {
        Item item = stack.func_77973_b();
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        return itemstack.func_190926_b() || this.eatTicks > 0 && item.func_219971_r();
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stackIn);
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_175448_a(itemstack)) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.spawnItem(itemstack.func_77979_a(i - 1));
            }
            this.spitOutItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.field_70146_Z.nextFloat() < 0.2f) {
            float f = this.field_70146_Z.nextFloat();
            ItemStack itemstack = f < 0.05f ? new ItemStack((IItemProvider)Items.field_151166_bC) : (f < 0.2f ? new ItemStack((IItemProvider)Items.field_151110_aK) : (f < 0.4f ? (this.field_70146_Z.nextBoolean() ? new ItemStack((IItemProvider)Items.field_179556_br) : new ItemStack((IItemProvider)Items.field_179555_bs)) : (f < 0.6f ? new ItemStack((IItemProvider)Items.field_151015_O) : (f < 0.8f ? new ItemStack((IItemProvider)Items.field_151116_aA) : new ItemStack((IItemProvider)Items.field_151008_G)))));
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.func_70638_az() != null && this.func_70638_az() == entity && !this.field_70122_E && this.func_184187_bx() != entity) {
            this.func_184220_m(entity);
        }
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.func_184187_bx() != null && this.func_110144_aD() != null && this.func_110144_aD() == this.func_184187_bx() && this.func_70681_au().nextInt(2) == 0) {
            this.func_184210_p();
        }
        return super.func_70097_a(dmg, i);
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        DakotaraptorEntity entity = new DakotaraptorEntity(ModEntityTypes.DAKOTARAPTOR_ENTITY, this.field_70170_p);
        entity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.BREEDING, null, null);
        return entity;
    }

    private void setAttackGoals() {
        this.field_70715_bh.func_75776_a(4, this.attackAnimals);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sleeping", this.func_70608_bn());
        compound.func_74757_a("Sitting", this.isSitting());
        compound.func_74757_a("Crouching", this.func_213453_ef());
        compound.func_74757_a("HasEgg", this.hasEgg());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSleeping(compound.func_74767_n("Sleeping"));
        this.setSitting(compound.func_74767_n("Sitting"));
        this.setCrouching(compound.func_74767_n("Crouching"));
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setAttackGoals();
    }

    public boolean isSitting() {
        return this.getDakotaraptorFlag(1);
    }

    public void setSitting(boolean p_213466_1_) {
        this.setDakotaraptorFlag(1, p_213466_1_);
    }

    public boolean isStuck() {
        return this.getDakotaraptorFlag(64);
    }

    private void setStuck(boolean p_213492_1_) {
        this.setDakotaraptorFlag(64, p_213492_1_);
    }

    private boolean isDakotaraptorAggroed() {
        return this.getDakotaraptorFlag(128);
    }

    private void setDakotaraptorAggroed(boolean p_213482_1_) {
        this.setDakotaraptorFlag(128, p_213482_1_);
    }

    public boolean func_70608_bn() {
        return this.getDakotaraptorFlag(32);
    }

    private void setSleeping(boolean p_213485_1_) {
        this.setDakotaraptorFlag(32, p_213485_1_);
    }

    private void setDakotaraptorFlag(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.field_70180_af.func_187227_b(DAKOTARAPTOR_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(DAKOTARAPTOR_FLAGS) | p_213505_1_)));
        } else {
            this.field_70180_af.func_187227_b(DAKOTARAPTOR_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(DAKOTARAPTOR_FLAGS) & ~p_213505_1_)));
        }
    }

    private boolean getDakotaraptorFlag(int p_213507_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(DAKOTARAPTOR_FLAGS) & p_213507_1_) != 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70613_aW()) {
            boolean flag = this.func_70090_H();
            if (flag || this.func_70638_az() != null || this.field_70170_p.func_72911_I()) {
                this.func_213454_em();
            }
            if (flag || this.func_70608_bn()) {
                this.setSitting(false);
            }
            if (this.isStuck() && this.field_70170_p.field_73012_v.nextFloat() < 0.2f) {
                BlockPos blockpos = new BlockPos((Entity)this);
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                this.field_70170_p.func_217379_c(2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            }
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.func_213467_eg() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        this.crouchAmountO = this.crouchAmount;
        if (this.func_213453_ef()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_213480_dY() {
        return this.getDakotaraptorFlag(16);
    }

    public void func_213461_s(boolean p_213461_1_) {
        this.setDakotaraptorFlag(16, p_213461_1_);
    }

    public boolean func_213490_ee() {
        return this.crouchAmount == 3.0f;
    }

    public void setCrouching(boolean p_213451_1_) {
        this.setDakotaraptorFlag(4, p_213451_1_);
    }

    public boolean func_213453_ef() {
        return this.getDakotaraptorFlag(4);
    }

    public void func_213502_u(boolean p_213502_1_) {
        this.setDakotaraptorFlag(8, p_213502_1_);
    }

    public boolean func_213467_eg() {
        return this.getDakotaraptorFlag(8);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213475_v(float p_213475_1_) {
        return MathHelper.func_219799_g((float)p_213475_1_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213503_w(float p_213503_1_) {
        return MathHelper.func_219799_g((float)p_213503_1_, (float)this.crouchAmountO, (float)this.crouchAmount);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.isDakotaraptorAggroed() && entitylivingbaseIn == null) {
            this.setDakotaraptorAggroed(false);
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    protected int func_225508_e_(float p_225508_1_, float p_225508_2_) {
        return MathHelper.func_76123_f((float)((p_225508_1_ - 5.0f) * p_225508_2_));
    }

    private void func_213454_em() {
        this.setSleeping(false);
    }

    private void func_213499_en() {
        this.func_213502_u(false);
        this.setCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setDakotaraptorAggroed(false);
        this.setStuck(false);
    }

    private boolean func_213478_eo() {
        return !this.func_70608_bn() && !this.isSitting() && !this.isStuck();
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.DAKOTARAPTOR_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundHandler.DAKOTARAPTOR_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.DAKOTARAPTOR_DEATH;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundHandler.DAKOTARAPTOR_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public static boolean func_213481_a(DakotaraptorEntity p_213481_0_, LivingEntity p_213481_1_) {
        double d0 = p_213481_1_.func_226281_cx_() - p_213481_0_.func_226281_cx_();
        double d1 = p_213481_1_.func_226277_ct_() - p_213481_0_.func_226277_ct_();
        double d2 = d0 / d1;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_213481_0_.field_70170_p.func_180495_p(new BlockPos(p_213481_0_.func_226277_ct_() + d4, p_213481_0_.func_226278_cu_() + (double)k, p_213481_0_.func_226281_cx_() + d3)).func_185904_a().func_76222_j()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entity);
        }
        return flag;
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)DakotaraptorEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    DakotaraptorEntity.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)DakotaraptorEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (DakotaraptorEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity entity, LivingEntity target) {
            if (entity instanceof DakotaraptorEntity && !entity.func_70631_g_()) {
                super.func_220793_a(entity, target);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)DakotaraptorEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (DakotaraptorEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (DakotaraptorEntity dakotaraptor : DakotaraptorEntity.this.field_70170_p.func_217357_a(DakotaraptorEntity.class, DakotaraptorEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!DakotaraptorEntity.this.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }

    class WatchGoal
    extends LookAtGoal {
        public WatchGoal(MobEntity p_i50733_2_, Class<? extends LivingEntity> p_i50733_3_, float p_i50733_4_) {
            super(p_i50733_2_, p_i50733_3_, p_i50733_4_);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !DakotaraptorEntity.this.isStuck() && !DakotaraptorEntity.this.func_213467_eg();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !DakotaraptorEntity.this.isStuck() && !DakotaraptorEntity.this.func_213467_eg();
        }
    }

    class SwimGoal
    extends net.minecraft.entity.ai.goal.SwimGoal {
        public SwimGoal() {
            super((MobEntity)DakotaraptorEntity.this);
        }

        public void func_75249_e() {
            super.func_75249_e();
            DakotaraptorEntity.this.func_213499_en();
        }

        public boolean func_75250_a() {
            return DakotaraptorEntity.this.func_70090_H() && DakotaraptorEntity.this.func_212107_bY() > 0.25 || DakotaraptorEntity.this.func_180799_ab();
        }
    }

    class SleepGoal
    extends BaseGoal {
        private int field_220825_c;

        public SleepGoal() {
            this.field_220825_c = DakotaraptorEntity.this.field_70146_Z.nextInt(140);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if (DakotaraptorEntity.this.field_70702_br == 0.0f && DakotaraptorEntity.this.field_70701_bs == 0.0f && DakotaraptorEntity.this.field_191988_bg == 0.0f) {
                return this.func_220823_j() || DakotaraptorEntity.this.func_70608_bn();
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_220823_j();
        }

        private boolean func_220823_j() {
            if (this.field_220825_c > 0) {
                --this.field_220825_c;
                return false;
            }
            return DakotaraptorEntity.this.field_70170_p.func_72935_r() && this.func_220813_g() && !this.func_220814_h();
        }

        public void func_75251_c() {
            this.field_220825_c = DakotaraptorEntity.this.field_70146_Z.nextInt(140);
            DakotaraptorEntity.this.func_213499_en();
        }

        public void func_75249_e() {
            DakotaraptorEntity.this.setSitting(false);
            DakotaraptorEntity.this.setCrouching(false);
            DakotaraptorEntity.this.func_213502_u(false);
            DakotaraptorEntity.this.func_70637_d(false);
            DakotaraptorEntity.this.setSleeping(true);
            DakotaraptorEntity.this.func_70661_as().func_75499_g();
            DakotaraptorEntity.this.func_70605_aq().func_75642_a(DakotaraptorEntity.this.func_226277_ct_(), DakotaraptorEntity.this.func_226278_cu_(), DakotaraptorEntity.this.func_226281_cx_(), 0.0);
        }
    }

    class SitAndLookGoal
    extends BaseGoal {
        private double field_220819_c;
        private double field_220820_d;
        private int field_220821_e;
        private int field_220822_f;

        public SitAndLookGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return DakotaraptorEntity.this.func_70643_av() == null && DakotaraptorEntity.this.func_70681_au().nextFloat() < 0.02f && !DakotaraptorEntity.this.func_70608_bn() && DakotaraptorEntity.this.func_70638_az() == null && DakotaraptorEntity.this.func_70661_as().func_75500_f() && !this.func_220814_h() && !DakotaraptorEntity.this.func_213480_dY() && !DakotaraptorEntity.this.func_213453_ef();
        }

        public boolean func_75253_b() {
            return this.field_220822_f > 0;
        }

        public void func_75249_e() {
            this.func_220817_j();
            this.field_220822_f = 2 + DakotaraptorEntity.this.func_70681_au().nextInt(3);
            DakotaraptorEntity.this.setSitting(true);
            DakotaraptorEntity.this.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            DakotaraptorEntity.this.setSitting(false);
        }

        public void func_75246_d() {
            --this.field_220821_e;
            if (this.field_220821_e <= 0) {
                --this.field_220822_f;
                this.func_220817_j();
            }
            DakotaraptorEntity.this.func_70671_ap().func_75650_a(DakotaraptorEntity.this.func_226277_ct_() + this.field_220819_c, DakotaraptorEntity.this.func_226280_cw_(), DakotaraptorEntity.this.func_226281_cx_() + this.field_220820_d, (float)DakotaraptorEntity.this.func_184649_cE(), (float)DakotaraptorEntity.this.func_70646_bf());
        }

        private void func_220817_j() {
            double d0 = Math.PI * 2 * DakotaraptorEntity.this.func_70681_au().nextDouble();
            this.field_220819_c = Math.cos(d0);
            this.field_220820_d = Math.sin(d0);
            this.field_220821_e = 80 + DakotaraptorEntity.this.func_70681_au().nextInt(20);
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final DakotaraptorEntity dakotaraptor;

        MateGoal(DakotaraptorEntity dakotaraptor, double speed) {
            super((AnimalEntity)dakotaraptor, speed);
            this.dakotaraptor = dakotaraptor;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.dakotaraptor.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() == null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.dakotaraptor.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final DakotaraptorEntity dakotaraptor;

        LayEggGoal(DakotaraptorEntity dakotaraptor, double speed) {
            super((CreatureEntity)dakotaraptor, speed, 16);
            this.dakotaraptor = dakotaraptor;
        }

        public boolean func_75250_a() {
            return this.dakotaraptor.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.dakotaraptor.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos((Entity)this.dakotaraptor);
            if (!this.dakotaraptor.func_70090_H() && this.func_179487_f()) {
                if (this.dakotaraptor.isDigging < 1) {
                    this.dakotaraptor.setDigging(true);
                } else if (this.dakotaraptor.isDigging > 200) {
                    World world = this.dakotaraptor.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)BlockInit.DAKOTARAPTOR_EGG.func_176223_P().func_206870_a((IProperty)DakotaraptorEggBlock.EGGS, (Comparable)Integer.valueOf(this.dakotaraptor.field_70146_Z.nextInt(4) + 1)), 3);
                    this.dakotaraptor.setHasEgg(false);
                    this.dakotaraptor.setDigging(false);
                    this.dakotaraptor.func_204700_e(600);
                }
                if (this.dakotaraptor.isDigging()) {
                    this.dakotaraptor.isDigging++;
                }
            }
        }

        public boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == BlockInit.LOAM || block == BlockInit.MOSSY_DIRT || block == Blocks.field_196661_l;
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)DakotaraptorEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !DakotaraptorEntity.this.func_70631_g_() && !DakotaraptorEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    public class PounceGoal
    extends net.minecraft.entity.ai.goal.JumpGoal {
        public boolean func_75250_a() {
            if (!DakotaraptorEntity.this.func_213490_ee()) {
                return false;
            }
            LivingEntity livingentity = DakotaraptorEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                if (livingentity.func_184172_bi() != livingentity.func_174811_aO()) {
                    return false;
                }
                boolean flag = DakotaraptorEntity.func_213481_a(DakotaraptorEntity.this, livingentity);
                if (!flag) {
                    DakotaraptorEntity.this.func_70661_as().func_75494_a((Entity)livingentity, 0);
                    DakotaraptorEntity.this.setCrouching(false);
                    DakotaraptorEntity.this.func_213502_u(false);
                }
                return flag;
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = DakotaraptorEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                double d0 = DakotaraptorEntity.this.func_213322_ci().field_72448_b;
                return !(d0 * d0 < (double)0.05f && Math.abs(DakotaraptorEntity.this.field_70125_A) < 15.0f && DakotaraptorEntity.this.field_70122_E || DakotaraptorEntity.this.isStuck());
            }
            return false;
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75249_e() {
            DakotaraptorEntity.this.func_70637_d(true);
            DakotaraptorEntity.this.func_213461_s(true);
            DakotaraptorEntity.this.func_213502_u(false);
            LivingEntity livingentity = DakotaraptorEntity.this.func_70638_az();
            DakotaraptorEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, 60.0f, 30.0f);
            Vec3d vec3d = new Vec3d(livingentity.func_226277_ct_() - DakotaraptorEntity.this.func_226277_ct_(), livingentity.func_226278_cu_() - DakotaraptorEntity.this.func_226278_cu_(), livingentity.func_226281_cx_() - DakotaraptorEntity.this.func_226281_cx_()).func_72432_b();
            DakotaraptorEntity.this.func_213317_d(DakotaraptorEntity.this.func_213322_ci().func_72441_c(vec3d.field_72450_a * 0.8, 0.9, vec3d.field_72449_c * 0.8));
            DakotaraptorEntity.this.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            DakotaraptorEntity.this.setCrouching(false);
            DakotaraptorEntity.this.crouchAmount = 0.0f;
            DakotaraptorEntity.this.crouchAmountO = 0.0f;
            DakotaraptorEntity.this.func_213502_u(false);
            DakotaraptorEntity.this.func_213461_s(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = DakotaraptorEntity.this.func_70638_az();
            if (livingentity != null) {
                DakotaraptorEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, 60.0f, 30.0f);
            }
            if (!DakotaraptorEntity.this.isStuck()) {
                Vec3d vec3d = DakotaraptorEntity.this.func_213322_ci();
                if (vec3d.field_72448_b * vec3d.field_72448_b < (double)0.03f && DakotaraptorEntity.this.field_70125_A != 0.0f) {
                    DakotaraptorEntity.this.field_70125_A = MathHelper.func_226167_j_((float)DakotaraptorEntity.this.field_70125_A, (float)0.0f, (float)0.2f);
                } else {
                    double d0 = Math.sqrt(Entity.func_213296_b((Vec3d)vec3d));
                    double d1 = Math.signum(-vec3d.field_72448_b) * Math.acos(d0 / vec3d.func_72433_c()) * 57.2957763671875;
                    DakotaraptorEntity.this.field_70125_A = (float)d1;
                }
            }
            if (livingentity != null && DakotaraptorEntity.this.func_70032_d((Entity)livingentity) <= 2.0f) {
                DakotaraptorEntity.this.func_70652_k((Entity)livingentity);
            } else if (DakotaraptorEntity.this.field_70125_A > 0.0f && DakotaraptorEntity.this.field_70122_E && (float)DakotaraptorEntity.this.func_213322_ci().field_72448_b != 0.0f && DakotaraptorEntity.this.field_70170_p.func_180495_p(new BlockPos((Entity)DakotaraptorEntity.this)).func_177230_c() == Blocks.field_150433_aE) {
                DakotaraptorEntity.this.field_70125_A = 60.0f;
                DakotaraptorEntity.this.func_70624_b(null);
                DakotaraptorEntity.this.setStuck(true);
            }
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController() {
            super((MobEntity)DakotaraptorEntity.this);
        }

        public void func_75641_c() {
            if (DakotaraptorEntity.this.func_213478_eo()) {
                super.func_75641_c();
            }
        }
    }

    public class LookHelperController
    extends LookController {
        public LookHelperController() {
            super((MobEntity)DakotaraptorEntity.this);
        }

        public void func_75649_a() {
            if (!DakotaraptorEntity.this.func_70608_bn()) {
                super.func_75649_a();
            }
        }

        protected boolean func_220680_b() {
            return !DakotaraptorEntity.this.func_213480_dY() && !DakotaraptorEntity.this.func_213453_ef() && !DakotaraptorEntity.this.func_213467_eg() & !DakotaraptorEntity.this.isStuck();
        }
    }

    class JumpGoal
    extends Goal {
        int delay;

        public JumpGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return DakotaraptorEntity.this.isStuck();
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && this.delay > 0;
        }

        public void func_75249_e() {
            this.delay = 40;
        }

        public void func_75251_c() {
            DakotaraptorEntity.this.setStuck(false);
        }

        public void func_75246_d() {
            --this.delay;
        }
    }

    class FollowTargetGoal
    extends Goal {
        public FollowTargetGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (DakotaraptorEntity.this.func_70608_bn()) {
                return false;
            }
            LivingEntity livingentity = DakotaraptorEntity.this.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && IS_PREY.test(livingentity) && DakotaraptorEntity.this.func_70068_e((Entity)livingentity) > 36.0 && !DakotaraptorEntity.this.func_213453_ef() && !DakotaraptorEntity.this.func_213467_eg() && !DakotaraptorEntity.this.field_70703_bu;
        }

        public void func_75249_e() {
            DakotaraptorEntity.this.setSitting(false);
            DakotaraptorEntity.this.setStuck(false);
        }

        public void func_75251_c() {
            LivingEntity livingentity = DakotaraptorEntity.this.func_70638_az();
            if (livingentity != null && DakotaraptorEntity.func_213481_a(DakotaraptorEntity.this, livingentity)) {
                DakotaraptorEntity.this.func_213502_u(true);
                DakotaraptorEntity.this.setCrouching(true);
                DakotaraptorEntity.this.func_70661_as().func_75499_g();
                DakotaraptorEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, (float)DakotaraptorEntity.this.func_184649_cE(), (float)DakotaraptorEntity.this.func_70646_bf());
            } else {
                DakotaraptorEntity.this.func_213502_u(false);
                DakotaraptorEntity.this.setCrouching(false);
            }
        }

        public void func_75246_d() {
            LivingEntity livingentity = DakotaraptorEntity.this.func_70638_az();
            DakotaraptorEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, (float)DakotaraptorEntity.this.func_184649_cE(), (float)DakotaraptorEntity.this.func_70646_bf());
            if (DakotaraptorEntity.this.func_70068_e((Entity)livingentity) <= 36.0) {
                DakotaraptorEntity.this.func_213502_u(true);
                DakotaraptorEntity.this.setCrouching(true);
                DakotaraptorEntity.this.func_70661_as().func_75499_g();
            } else {
                DakotaraptorEntity.this.func_70661_as().func_75497_a((Entity)livingentity, 1.5);
            }
        }
    }

    class FollowGoal
    extends FollowParentGoal {
        private final DakotaraptorEntity owner;

        public FollowGoal(DakotaraptorEntity p_i50735_2_, double p_i50735_3_) {
            super((AnimalEntity)p_i50735_2_, p_i50735_3_);
            this.owner = p_i50735_2_;
        }

        public boolean func_75250_a() {
            return !this.owner.isDakotaraptorAggroed() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.owner.isDakotaraptorAggroed() && super.func_75253_b();
        }

        public void func_75249_e() {
            this.owner.func_213499_en();
            super.func_75249_e();
        }
    }

    class FindShelterGoal
    extends FleeSunGoal {
        private int cooldown;

        public FindShelterGoal(double p_i50724_2_) {
            super((CreatureEntity)DakotaraptorEntity.this, p_i50724_2_);
            this.cooldown = 100;
        }

        public boolean func_75250_a() {
            if (!DakotaraptorEntity.this.func_70608_bn() && this.field_75372_a.func_70638_az() == null) {
                if (DakotaraptorEntity.this.field_70170_p.func_72911_I()) {
                    return true;
                }
                if (this.cooldown > 0) {
                    --this.cooldown;
                    return false;
                }
                this.cooldown = 100;
                BlockPos blockpos = new BlockPos((Entity)this.field_75372_a);
                return DakotaraptorEntity.this.field_70170_p.func_72935_r() && DakotaraptorEntity.this.field_70170_p.func_226660_f_(blockpos) && !((ServerWorld)DakotaraptorEntity.this.field_70170_p).func_217483_b_(blockpos) && this.func_220702_g();
            }
            return false;
        }

        public void func_75249_e() {
            DakotaraptorEntity.this.func_213499_en();
            super.func_75249_e();
        }
    }

    class BiteGoal
    extends MeleeAttackGoal {
        public BiteGoal(double p_i50731_2_, boolean p_i50731_4_) {
        }

        @Override
        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)enemy);
            }
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((LivingEntity)null);
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            DakotaraptorEntity.this.func_213502_u(false);
            super.func_75249_e();
        }

        public boolean func_75250_a() {
            return !DakotaraptorEntity.this.isSitting() && !DakotaraptorEntity.this.func_70608_bn() && !DakotaraptorEntity.this.func_213453_ef() && !DakotaraptorEntity.this.isStuck() && super.func_75250_a();
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final EntityPredicate field_220816_b;

        private BaseGoal() {
            this.field_220816_b = new EntityPredicate().func_221013_a(12.0).func_221014_c().func_221012_a((Predicate)new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockpos = new BlockPos((Entity)DakotaraptorEntity.this);
            return !DakotaraptorEntity.this.field_70170_p.func_226660_f_(blockpos) && DakotaraptorEntity.this.func_180484_a(blockpos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !DakotaraptorEntity.this.field_70170_p.func_217374_a(LivingEntity.class, this.field_220816_b, (LivingEntity)DakotaraptorEntity.this, DakotaraptorEntity.this.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof DakotaraptorEntity) {
                return false;
            }
            if (!(p_test_1_ instanceof ChickenEntity || p_test_1_ instanceof RabbitEntity || p_test_1_ instanceof MonsterEntity)) {
                if (p_test_1_ instanceof TameableEntity) {
                    return !((TameableEntity)p_test_1_).func_70909_n();
                }
                if (!(p_test_1_ instanceof PlayerEntity) || !p_test_1_.func_175149_v() && !((PlayerEntity)p_test_1_).func_184812_l_()) {
                    return !p_test_1_.func_70608_bn() && !p_test_1_.func_226273_bm_();
                }
                return false;
            }
            return true;
        }
    }
}

