/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity;

import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.block.DryosaurusEggBlock;
import superlord.prehistoricfauna.entity.AllosaurusEntity;
import superlord.prehistoricfauna.entity.CamarasaurusEntity;
import superlord.prehistoricfauna.entity.CeratosaurusEntity;
import superlord.prehistoricfauna.entity.DakotaraptorEntity;
import superlord.prehistoricfauna.entity.HerrerasaurusEntity;
import superlord.prehistoricfauna.entity.SaurosuchusEntity;
import superlord.prehistoricfauna.entity.TyrannosaurusEntity;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.util.SoundHandler;

public class DryosaurusEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(DryosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(DryosaurusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{BlockInit.CONIOPTERIS.func_199767_j()});
    private int isDigging;

    public DryosaurusEntity(EntityType<? extends DryosaurusEntity> type, World world) {
        super(type, world);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == BlockInit.CONIOPTERIS.func_199767_j();
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        DryosaurusEntity entity = new DryosaurusEntity(ModEntityTypes.DRYOSAURUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.BREEDING, null, null);
        return entity;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, AllosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, CeratosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, CamarasaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, DakotaraptorEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, TyrannosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, HerrerasaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, SaurosuchusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LayEggGoal(this, 1.0));
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.DRYOSAURUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundHandler.DRYOSAURUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.DRYOSAURUS_DEATH;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    public void func_70077_a(LightningBoltEntity lightningBoltEntity) {
        this.func_184195_f(true);
    }

    static class MateGoal
    extends BreedGoal {
        private final DryosaurusEntity dryosaurus;

        MateGoal(DryosaurusEntity dryosaurus, double speed) {
            super((AnimalEntity)dryosaurus, speed);
            this.dryosaurus = dryosaurus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.dryosaurus.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() != null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.dryosaurus.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final DryosaurusEntity dryosaurus;

        LayEggGoal(DryosaurusEntity dryosaurus, double speed) {
            super((CreatureEntity)dryosaurus, speed, 16);
            this.dryosaurus = dryosaurus;
        }

        public boolean func_75250_a() {
            return this.dryosaurus.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.dryosaurus.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos((Entity)this.dryosaurus);
            if (this.dryosaurus.func_70090_H() && this.func_179487_f()) {
                if (this.dryosaurus.isDigging < 1) {
                    this.dryosaurus.setDigging(true);
                } else if (this.dryosaurus.isDigging > 200) {
                    World world = this.dryosaurus.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)BlockInit.DRYOSAURUS_EGG.func_176223_P().func_206870_a((IProperty)DryosaurusEggBlock.EGGS, (Comparable)Integer.valueOf(this.dryosaurus.field_70146_Z.nextInt(4) + 1)), 3);
                    this.dryosaurus.setHasEgg(false);
                    this.dryosaurus.setDigging(false);
                    this.dryosaurus.func_204700_e(600);
                }
                if (this.dryosaurus.isDigging()) {
                    this.dryosaurus.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == BlockInit.SILT || block == BlockInit.HARDENED_SILT || block == Blocks.field_150354_m;
        }
    }
}

