/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.block.EilenodonEggBlock;
import superlord.prehistoricfauna.entity.AllosaurusEntity;
import superlord.prehistoricfauna.entity.AnkylosaurusEntity;
import superlord.prehistoricfauna.entity.CamarasaurusEntity;
import superlord.prehistoricfauna.entity.CeratosaurusEntity;
import superlord.prehistoricfauna.entity.DakotaraptorEntity;
import superlord.prehistoricfauna.entity.DryosaurusEntity;
import superlord.prehistoricfauna.entity.ExaeretodonEntity;
import superlord.prehistoricfauna.entity.HerrerasaurusEntity;
import superlord.prehistoricfauna.entity.HesperornithoidesEntity;
import superlord.prehistoricfauna.entity.SaurosuchusEntity;
import superlord.prehistoricfauna.entity.StegosaurusEntity;
import superlord.prehistoricfauna.entity.ThescelosaurusEntity;
import superlord.prehistoricfauna.entity.TriceratopsEntity;
import superlord.prehistoricfauna.entity.TyrannosaurusEntity;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.util.SoundHandler;

public class EilenodonEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(EilenodonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(EilenodonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> EILENODON_FLAGS = EntityDataManager.func_187226_a(EilenodonEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{BlockInit.HORSETAIL.func_199767_j()});
    private int isDigging;

    public EilenodonEntity(EntityType<? extends EilenodonEntity> type, World world) {
        super(type, world);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == BlockInit.HORSETAIL.func_199767_j();
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        EilenodonEntity entity = new EilenodonEntity(ModEntityTypes.EILENODON_ENTITY, this.field_70170_p);
        entity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.BREEDING, null, null);
        return entity;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(EILENODON_FLAGS, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
        compound.func_74757_a("Sitting", this.isSitting());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
        this.setSitting(compound.func_74767_n("Sitting"));
    }

    private void setEilenodonFlag(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.field_70180_af.func_187227_b(EILENODON_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(EILENODON_FLAGS) | p_213505_1_)));
        } else {
            this.field_70180_af.func_187227_b(EILENODON_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(EILENODON_FLAGS) & ~p_213505_1_)));
        }
    }

    private boolean getEilenodonFlag(int p_213507_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(EILENODON_FLAGS) & p_213507_1_) != 0;
    }

    public boolean isSitting() {
        return this.getEilenodonFlag(1);
    }

    public void setSitting(boolean p_213466_1_) {
        this.setEilenodonFlag(1, p_213466_1_);
    }

    public boolean func_213480_dY() {
        return this.getEilenodonFlag(16);
    }

    public void func_213461_s(boolean p_213461_1_) {
        this.setEilenodonFlag(16, p_213461_1_);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, AllosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, CeratosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, StegosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, DryosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, HesperornithoidesEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, CamarasaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, TyrannosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, TriceratopsEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, AnkylosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, ThescelosaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, DakotaraptorEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, HerrerasaurusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, ExaeretodonEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new AvoidEntityGoal((CreatureEntity)this, SaurosuchusEntity.class, 10.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new SitAndLookGoal());
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundHandler.EILENODON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.EILENODON_DEATH;
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    class SitAndLookGoal
    extends BaseGoal {
        private double field_220819_c;
        private double field_220820_d;
        private int field_220821_e;
        private int field_220822_f;

        public SitAndLookGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EilenodonEntity.this.func_70643_av() == null && EilenodonEntity.this.func_70681_au().nextFloat() < 0.02f && !EilenodonEntity.this.func_70608_bn() && EilenodonEntity.this.func_70638_az() == null && EilenodonEntity.this.func_70661_as().func_75500_f() && !this.func_220814_h() && !EilenodonEntity.this.func_213480_dY() && !EilenodonEntity.this.func_213453_ef() && EilenodonEntity.this.field_70170_p.func_72820_D() <= 500L || EilenodonEntity.this.func_70643_av() == null && EilenodonEntity.this.func_70681_au().nextFloat() < 0.02f && !EilenodonEntity.this.func_70608_bn() && EilenodonEntity.this.func_70638_az() == null && EilenodonEntity.this.func_70661_as().func_75500_f() && !this.func_220814_h() && !EilenodonEntity.this.func_213480_dY() && !EilenodonEntity.this.func_213453_ef() && EilenodonEntity.this.field_70170_p.func_72820_D() >= 11500L && EilenodonEntity.this.field_70170_p.func_72820_D() <= 13500L || EilenodonEntity.this.func_70643_av() == null && EilenodonEntity.this.func_70681_au().nextFloat() < 0.02f && !EilenodonEntity.this.func_70608_bn() && EilenodonEntity.this.func_70638_az() == null && EilenodonEntity.this.func_70661_as().func_75500_f() && !this.func_220814_h() && !EilenodonEntity.this.func_213480_dY() && !EilenodonEntity.this.func_213453_ef() && EilenodonEntity.this.field_70170_p.func_72820_D() >= 22500L;
        }

        public boolean func_75253_b() {
            return this.field_220822_f == 4;
        }

        public void func_75249_e() {
            this.func_220817_j();
            this.field_220822_f = 2 + EilenodonEntity.this.func_70681_au().nextInt(3);
            EilenodonEntity.this.setSitting(true);
            EilenodonEntity.this.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            EilenodonEntity.this.setSitting(false);
        }

        public void func_75246_d() {
            --this.field_220821_e;
            if (this.field_220821_e <= 0) {
                --this.field_220822_f;
                this.func_220817_j();
            }
            EilenodonEntity.this.func_70671_ap().func_75650_a(EilenodonEntity.this.func_226277_ct_() + this.field_220819_c, EilenodonEntity.this.func_226280_cw_(), EilenodonEntity.this.func_226281_cx_() + this.field_220820_d, (float)EilenodonEntity.this.func_184649_cE(), (float)EilenodonEntity.this.func_70646_bf());
        }

        private void func_220817_j() {
            double d0 = Math.PI * 2 * EilenodonEntity.this.func_70681_au().nextDouble();
            this.field_220819_c = Math.cos(d0);
            this.field_220820_d = Math.sin(d0);
            this.field_220821_e = 80 + EilenodonEntity.this.func_70681_au().nextInt(20);
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final EntityPredicate field_220816_b;

        private BaseGoal() {
            this.field_220816_b = new EntityPredicate().func_221013_a(12.0).func_221014_c().func_221012_a((Predicate)new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockpos = new BlockPos((Entity)EilenodonEntity.this);
            return !EilenodonEntity.this.field_70170_p.func_226660_f_(blockpos) && EilenodonEntity.this.func_180484_a(blockpos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !EilenodonEntity.this.field_70170_p.func_217374_a(LivingEntity.class, this.field_220816_b, (LivingEntity)EilenodonEntity.this, EilenodonEntity.this.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof EilenodonEntity) {
                return false;
            }
            if (!(p_test_1_ instanceof ChickenEntity || p_test_1_ instanceof RabbitEntity || p_test_1_ instanceof MonsterEntity)) {
                if (p_test_1_ instanceof TameableEntity) {
                    return !((TameableEntity)p_test_1_).func_70909_n();
                }
                if (!(p_test_1_ instanceof PlayerEntity) || !p_test_1_.func_175149_v() && !((PlayerEntity)p_test_1_).func_184812_l_()) {
                    return !p_test_1_.func_70608_bn() && !p_test_1_.func_226273_bm_();
                }
                return false;
            }
            return true;
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final EilenodonEntity eilenodon;

        MateGoal(EilenodonEntity eilenodon, double speed) {
            super((AnimalEntity)eilenodon, speed);
            this.eilenodon = eilenodon;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.eilenodon.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() != null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.eilenodon.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final EilenodonEntity eilenodon;

        LayEggGoal(EilenodonEntity eilenodon, double speed) {
            super((CreatureEntity)eilenodon, speed, 16);
            this.eilenodon = eilenodon;
        }

        public boolean func_75250_a() {
            return this.eilenodon.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.eilenodon.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos((Entity)this.eilenodon);
            if (this.eilenodon.func_70090_H() && this.func_179487_f()) {
                if (this.eilenodon.isDigging < 1) {
                    this.eilenodon.setDigging(true);
                } else if (this.eilenodon.isDigging > 200) {
                    World world = this.eilenodon.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)BlockInit.EILENODON_EGG.func_176223_P().func_206870_a((IProperty)EilenodonEggBlock.EGGS, (Comparable)Integer.valueOf(this.eilenodon.field_70146_Z.nextInt(4) + 1)), 3);
                    this.eilenodon.setHasEgg(false);
                    this.eilenodon.setDigging(false);
                    this.eilenodon.func_204700_e(600);
                }
                if (this.eilenodon.isDigging()) {
                    this.eilenodon.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == BlockInit.SILT || block == BlockInit.HARDENED_SILT || block == Blocks.field_150354_m;
        }
    }
}

