/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import superlord.prehistoricfauna.block.SaurosuchusEggBlock;
import superlord.prehistoricfauna.entity.AllosaurusEntity;
import superlord.prehistoricfauna.entity.AnkylosaurusEntity;
import superlord.prehistoricfauna.entity.CamarasaurusEntity;
import superlord.prehistoricfauna.entity.DryosaurusEntity;
import superlord.prehistoricfauna.entity.HerrerasaurusEntity;
import superlord.prehistoricfauna.entity.IschigualastiaEntity;
import superlord.prehistoricfauna.entity.SillosuchusEntity;
import superlord.prehistoricfauna.entity.StegosaurusEntity;
import superlord.prehistoricfauna.entity.ThescelosaurusEntity;
import superlord.prehistoricfauna.entity.TriceratopsEntity;
import superlord.prehistoricfauna.entity.TyrannosaurusEntity;
import superlord.prehistoricfauna.entity.goal.HuntGoal;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.ItemInit;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.util.SoundHandler;

public class SaurosuchusEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(SaurosuchusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(SaurosuchusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> SAUROSUCHUS_FLAGS = EntityDataManager.func_187226_a(SaurosuchusEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int warningSoundTicks;
    private Goal attackAnimals;
    private int isDigging;

    public SaurosuchusEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        SaurosuchusEntity entity = new SaurosuchusEntity(ModEntityTypes.SAUROSUCHUS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.BREEDING, null, null);
        return entity;
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ItemInit.RAW_ISCHIGUALASTIA_MEAT.get();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.attackAnimals = new HuntGoal((MobEntity)this, AnimalEntity.class, 10, false, false, p_213487_0_ -> p_213487_0_ instanceof ThescelosaurusEntity || p_213487_0_ instanceof DryosaurusEntity || p_213487_0_ instanceof HerrerasaurusEntity || p_213487_0_ instanceof IschigualastiaEntity || p_213487_0_ instanceof SillosuchusEntity || p_213487_0_ instanceof HorseEntity || p_213487_0_ instanceof DonkeyEntity || p_213487_0_ instanceof MuleEntity || p_213487_0_ instanceof SheepEntity || p_213487_0_ instanceof CowEntity || p_213487_0_ instanceof PigEntity || p_213487_0_ instanceof OcelotEntity || p_213487_0_ instanceof PlayerEntity);
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MateGoal(this, 1.0));
        this.field_70715_bh.func_75776_a(1, this.attackAnimals);
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new SleepGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, AllosaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, StegosaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, CamarasaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, TriceratopsEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, AnkylosaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, TyrannosaurusEntity.class, 7.0f, 1.25, 1.25));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.SAUROSUCHUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundHandler.SAUROSUCHUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.SAUROSUCHUS_DEATH;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundHandler.SAUROSUCHUS_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    public boolean func_70608_bn() {
        return this.getSaurosuchusFlag(32);
    }

    private void setSleeping(boolean p_213485_1_) {
        this.setSaurosuchusFlag(32, p_213485_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(SAUROSUCHUS_FLAGS, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sleeping", this.func_70608_bn());
        compound.func_74757_a("Crouching", this.func_213453_ef());
        compound.func_74757_a("HasEgg", this.hasEgg());
    }

    private void setSaurosuchusFlag(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.field_70180_af.func_187227_b(SAUROSUCHUS_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(SAUROSUCHUS_FLAGS) | p_213505_1_)));
        } else {
            this.field_70180_af.func_187227_b(SAUROSUCHUS_FLAGS, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(SAUROSUCHUS_FLAGS) & ~p_213505_1_)));
        }
    }

    private boolean getSaurosuchusFlag(int p_213507_1_) {
        return ((Byte)this.field_70180_af.func_187225_a(SAUROSUCHUS_FLAGS) & p_213507_1_) != 0;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSleeping(compound.func_74767_n("Sleeping"));
        this.setHasEgg(compound.func_74767_n("HasEgg"));
    }

    class SleepGoal
    extends BaseGoal {
        private int field_220825_c;

        public SleepGoal() {
            this.field_220825_c = SaurosuchusEntity.this.field_70146_Z.nextInt(140);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if (SaurosuchusEntity.this.field_70702_br == 0.0f && SaurosuchusEntity.this.field_70701_bs == 0.0f && SaurosuchusEntity.this.field_191988_bg == 0.0f) {
                return this.func_220823_j() || SaurosuchusEntity.this.func_70608_bn();
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_220823_j();
        }

        private boolean func_220823_j() {
            if (this.field_220825_c > 0) {
                --this.field_220825_c;
                return false;
            }
            return SaurosuchusEntity.this.field_70170_p.func_72935_r() && this.func_220813_g() && !this.func_220814_h();
        }

        public void func_75251_c() {
            this.field_220825_c = SaurosuchusEntity.this.field_70146_Z.nextInt(140);
            SaurosuchusEntity.this.setSleeping(false);
        }

        public void func_75249_e() {
            SaurosuchusEntity.this.func_70637_d(false);
            SaurosuchusEntity.this.setSleeping(true);
            SaurosuchusEntity.this.func_70661_as().func_75499_g();
            SaurosuchusEntity.this.func_70605_aq().func_75642_a(SaurosuchusEntity.this.func_226277_ct_(), SaurosuchusEntity.this.func_226278_cu_(), SaurosuchusEntity.this.func_226281_cx_(), 0.0);
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof SaurosuchusEntity) {
                return false;
            }
            if (!(p_test_1_ instanceof ChickenEntity || p_test_1_ instanceof RabbitEntity || p_test_1_ instanceof MonsterEntity)) {
                if (p_test_1_ instanceof TameableEntity) {
                    return !((TameableEntity)p_test_1_).func_70909_n();
                }
                if (!(p_test_1_ instanceof PlayerEntity) || !p_test_1_.func_175149_v() && !((PlayerEntity)p_test_1_).func_184812_l_()) {
                    return !p_test_1_.func_70608_bn() && !p_test_1_.func_226273_bm_();
                }
                return false;
            }
            return true;
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final EntityPredicate field_220816_b;

        private BaseGoal() {
            this.field_220816_b = new EntityPredicate().func_221013_a(12.0).func_221014_c().func_221012_a((Predicate)new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockpos = new BlockPos((Entity)SaurosuchusEntity.this);
            return !SaurosuchusEntity.this.field_70170_p.func_226660_f_(blockpos) && SaurosuchusEntity.this.func_180484_a(blockpos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !SaurosuchusEntity.this.field_70170_p.func_217374_a(LivingEntity.class, this.field_220816_b, (LivingEntity)SaurosuchusEntity.this, SaurosuchusEntity.this.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final SaurosuchusEntity saurosuchus;

        MateGoal(SaurosuchusEntity saurosuchus, double speed) {
            super((AnimalEntity)saurosuchus, speed);
            this.saurosuchus = saurosuchus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.saurosuchus.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverPlayerEntity = this.field_75390_d.func_191993_do();
            if (serverPlayerEntity == null && this.field_75391_e.func_191993_do() == null) {
                serverPlayerEntity = this.field_75391_e.func_191993_do();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverPlayerEntity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.saurosuchus.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final SaurosuchusEntity saurosuchus;

        LayEggGoal(SaurosuchusEntity saurosuchus, double speed) {
            super((CreatureEntity)saurosuchus, speed, 16);
            this.saurosuchus = saurosuchus;
        }

        public boolean func_75250_a() {
            return this.saurosuchus.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.saurosuchus.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos((Entity)this.saurosuchus);
            if (!this.saurosuchus.func_70090_H() && this.func_179487_f()) {
                if (this.saurosuchus.isDigging < 1) {
                    this.saurosuchus.setDigging(true);
                } else if (this.saurosuchus.isDigging > 200) {
                    World world = this.saurosuchus.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)BlockInit.SAUROSUCHUS_EGG.func_176223_P().func_206870_a((IProperty)SaurosuchusEggBlock.EGGS, (Comparable)Integer.valueOf(this.saurosuchus.field_70146_Z.nextInt(4) + 1)), 3);
                    this.saurosuchus.setHasEgg(false);
                    this.saurosuchus.setDigging(false);
                    this.saurosuchus.func_204700_e(600);
                }
                if (this.saurosuchus.isDigging()) {
                    this.saurosuchus.isDigging++;
                }
            }
        }

        public boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == BlockInit.LOAM || block == BlockInit.PACKED_LOAM || block == Blocks.field_196661_l;
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)SaurosuchusEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !SaurosuchusEntity.this.func_70631_g_() && !SaurosuchusEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)SaurosuchusEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    SaurosuchusEntity.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
            }
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((LivingEntity)null);
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)SaurosuchusEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (SaurosuchusEntity.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity entity, LivingEntity target) {
            if (entity instanceof SaurosuchusEntity && !entity.func_70631_g_()) {
                super.func_220793_a(entity, target);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)SaurosuchusEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (SaurosuchusEntity.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (SaurosuchusEntity saurosuchus : SaurosuchusEntity.this.field_70170_p.func_217357_a(SaurosuchusEntity.class, SaurosuchusEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!SaurosuchusEntity.this.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }
}

