/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import superlord.prehistoricfauna.entity.PrehistoricEntity;
import superlord.prehistoricfauna.init.ItemInit;

public class StegosaurusSkeletonEntity
extends PrehistoricEntity {
    private static final DataParameter<Boolean> RESTING_POSE = EntityDataManager.func_187226_a(StegosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RETRO_POSE = EntityDataManager.func_187226_a(StegosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ACTION_LEFT_POSE = EntityDataManager.func_187226_a(StegosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ACTION_RIGHT_POSE = EntityDataManager.func_187226_a(StegosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PUSHING = EntityDataManager.func_187226_a(StegosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LOOKING = EntityDataManager.func_187226_a(StegosaurusSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public boolean isResting() {
        return (Boolean)this.field_70180_af.func_187225_a(RESTING_POSE);
    }

    private void setResting(boolean isResting) {
        this.field_70180_af.func_187227_b(RESTING_POSE, (Object)isResting);
    }

    public boolean isRetro() {
        return (Boolean)this.field_70180_af.func_187225_a(RETRO_POSE);
    }

    private void setRetro(boolean isRetro) {
        this.field_70180_af.func_187227_b(RETRO_POSE, (Object)isRetro);
    }

    public boolean isActionLeft() {
        return (Boolean)this.field_70180_af.func_187225_a(ACTION_LEFT_POSE);
    }

    private void setActionLeft(boolean isActionLeft) {
        this.field_70180_af.func_187227_b(ACTION_LEFT_POSE, (Object)isActionLeft);
    }

    public boolean isActionRight() {
        return (Boolean)this.field_70180_af.func_187225_a(ACTION_RIGHT_POSE);
    }

    private void setActionRight(boolean isActionRight) {
        this.field_70180_af.func_187227_b(ACTION_RIGHT_POSE, (Object)isActionRight);
    }

    public boolean isPushable() {
        return (Boolean)this.field_70180_af.func_187225_a(PUSHING);
    }

    private void setPushable(boolean isPushable) {
        this.field_70180_af.func_187227_b(PUSHING, (Object)isPushable);
    }

    public boolean isLooking() {
        return (Boolean)this.field_70180_af.func_187225_a(LOOKING);
    }

    private void setLooking(boolean isLooking) {
        this.field_70180_af.func_187227_b(LOOKING, (Object)isLooking);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RESTING_POSE, (Object)false);
        this.field_70180_af.func_187214_a(ACTION_LEFT_POSE, (Object)false);
        this.field_70180_af.func_187214_a(ACTION_RIGHT_POSE, (Object)false);
        this.field_70180_af.func_187214_a(RETRO_POSE, (Object)false);
        this.field_70180_af.func_187214_a(PUSHING, (Object)false);
        this.field_70180_af.func_187214_a(LOOKING, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsResting", this.isResting());
        compound.func_74757_a("IsActionLeft", this.isActionLeft());
        compound.func_74757_a("IsActionRight", this.isActionRight());
        compound.func_74757_a("IsRetro", this.isRetro());
        compound.func_74757_a("IsPushable", this.isPushable());
        compound.func_74757_a("IsLooking", this.isLooking());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setResting(compound.func_74767_n("IsResting"));
        this.setActionLeft(compound.func_74767_n("IsActionLeft"));
        this.setActionRight(compound.func_74767_n("IsActionRight"));
        this.setRetro(compound.func_74767_n("IsRetro"));
        this.setPushable(compound.func_74767_n("IsPushable"));
        this.setLooking(compound.func_74767_n("IsLooking"));
    }

    public StegosaurusSkeletonEntity(EntityType<? extends StegosaurusSkeletonEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new LookAtPlayerGoal(this, PlayerEntity.class, 8.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70104_M() {
        return this.isPushable();
    }

    @Override
    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == ItemInit.GEOLOGY_HAMMER.get()) {
            if (!(this.isResting() || player.func_225608_bj_() || this.isRetro() || this.isActionLeft() || this.isActionRight())) {
                this.setResting(true);
            } else if (this.isResting() && !player.func_225608_bj_()) {
                this.setResting(false);
                this.setRetro(true);
            } else if (!player.func_225608_bj_() && this.isRetro()) {
                this.setRetro(false);
                this.setActionLeft(true);
            } else if (!player.func_225608_bj_() && this.isActionLeft()) {
                this.setActionLeft(false);
                this.setActionRight(true);
            } else if (!player.func_225608_bj_() && this.isActionRight()) {
                this.setActionRight(false);
            } else if (player.func_225608_bj_() && !this.isPushable() && !this.isLooking()) {
                this.setPushable(true);
            } else if (player.func_225608_bj_() && this.isPushable()) {
                this.setPushable(false);
                this.setLooking(true);
            } else if (player.func_225608_bj_() && this.isLooking()) {
                this.setLooking(false);
            }
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_82167_n(Entity entityIn) {
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187856_fd, this.func_184176_by(), 1.0f, 1.0f);
    }

    private void playParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_189880_di.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof PlayerEntity) {
            this.func_70106_y();
            this.playBrokenSound();
            this.playParticles();
            this.spawnFossil(source);
        }
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    private void spawnFossil(DamageSource p_213815_1_) {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this), (ItemStack)new ItemStack((IItemProvider)ItemInit.STEGOSAURUS_SKELETON.get()));
    }

    static class LookAtPlayerGoal
    extends LookAtGoal {
        StegosaurusSkeletonEntity field_75332_b;

        public LookAtPlayerGoal(StegosaurusSkeletonEntity entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((MobEntity)entityIn, watchTargetClass, maxDistance);
            this.field_75332_b = entityIn;
        }

        public boolean func_75250_a() {
            if (this.field_75332_b.isLooking()) {
                return super.func_75250_a();
            }
            return false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_75332_b.isLooking();
        }
    }
}

