/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import superlord.prehistoricfauna.util.SoundHandler;

public class TimeGuardianEntity
extends MonsterEntity {
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> USE_BEAM = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> USE_REGULAR_ATTACK = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHARGING_BEAM = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> USING_BEAM = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> LASER_PITCH = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LASER_YAW = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PREV_LASER_PITCH = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PREV_LASER_YAW = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> IS_SUMMONED = EntityDataManager.func_187226_a(TimeGuardianEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);
    public float targetDistance;
    public float targetAngle;

    public TimeGuardianEntity(EntityType<? extends MonsterEntity> type, World world) {
        super(type, world);
    }

    public boolean isSummoned() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SUMMONED);
    }

    public void setSummoned(boolean isSummoned) {
        this.field_70180_af.func_187227_b(IS_SUMMONED, (Object)isSummoned);
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.HENOS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundHandler.HENOS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.HENOS_DEATH;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new BeamAttackAI(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal(this, 1.0, true));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(50.0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null) {
            this.targetDistance = this.func_70032_d((Entity)this.func_70638_az()) - this.func_70638_az().func_213311_cf() / 2.0f;
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.func_70638_az());
        }
        if (this.func_70638_az() != null && (!this.func_70638_az().func_70089_S() || this.func_70638_az().func_110143_aJ() <= 0.0f)) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd()) {
            if (this.isActive()) {
                if (this.func_70638_az() == null) {
                    this.setActive(false);
                }
            } else if (this.func_70638_az() != null && this.targetDistance <= 30.0f) {
                this.setActive(true);
            }
        }
        if (!this.isActive()) {
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
            this.field_70177_z = this.field_70126_B;
        }
        this.field_70761_aq = this.field_70177_z;
        if (!this.isActive() && !this.field_70170_p.field_72995_K) {
            this.func_70691_i(0.3f);
        }
    }

    public boolean func_70104_M() {
        return this.isActive();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT compound) {
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    public boolean func_213392_I() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ACTIVE, (Object)false);
        this.func_184212_Q().func_187214_a(USE_BEAM, (Object)false);
        this.func_184212_Q().func_187214_a(USE_REGULAR_ATTACK, (Object)false);
        this.func_184212_Q().func_187214_a(CHARGING_BEAM, (Object)false);
        this.func_184212_Q().func_187214_a(USING_BEAM, (Object)false);
        this.func_184212_Q().func_187214_a(LASER_PITCH, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(LASER_YAW, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(PREV_LASER_PITCH, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(PREV_LASER_YAW, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(IS_SUMMONED, (Object)false);
    }

    public boolean isUsingBeamAttack() {
        return (Boolean)this.func_184212_Q().func_187225_a(USE_BEAM);
    }

    public void useBeam(boolean isUsingBeam) {
        this.func_184212_Q().func_187227_b(USE_BEAM, (Object)isUsingBeam);
    }

    public boolean isUsingRegularAttack() {
        return (Boolean)this.func_184212_Q().func_187225_a(USE_REGULAR_ATTACK);
    }

    public void useRegularAttack(boolean isUsingRegularAttack) {
        this.func_184212_Q().func_187227_b(USE_REGULAR_ATTACK, (Object)isUsingRegularAttack);
    }

    public boolean isActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
    }

    public void setActive(boolean isActive) {
        this.func_184212_Q().func_187227_b(ACTIVE, (Object)isActive);
    }

    public float getHealthRatio() {
        return this.func_110143_aJ() / this.func_110138_aP();
    }

    public float getLaserPitch() {
        return ((Float)this.field_70180_af.func_187225_a(LASER_PITCH)).floatValue();
    }

    private void setLaserPitch(float laserPitch) {
        this.field_70180_af.func_187227_b(LASER_PITCH, (Object)Float.valueOf(laserPitch));
    }

    public float getLaserYaw() {
        return ((Float)this.field_70180_af.func_187225_a(LASER_YAW)).floatValue();
    }

    private void setLaserYaw(float laserYaw) {
        this.field_70180_af.func_187227_b(LASER_YAW, (Object)Float.valueOf(laserYaw));
    }

    public float getPrevLaserPitch() {
        return ((Float)this.field_70180_af.func_187225_a(PREV_LASER_PITCH)).floatValue();
    }

    private void setPrevLaserPitch(float prevLaserPitch) {
        this.field_70180_af.func_187227_b(PREV_LASER_PITCH, (Object)Float.valueOf(prevLaserPitch));
    }

    public float getPrevLaserYaw() {
        return ((Float)this.field_70180_af.func_187225_a(PREV_LASER_YAW)).floatValue();
    }

    private void setPrevLaserYaw(float prevLaserYaw) {
        this.field_70180_af.func_187227_b(PREV_LASER_YAW, (Object)Float.valueOf(prevLaserYaw));
    }

    public boolean isUsingBeam() {
        return (Boolean)this.field_70180_af.func_187225_a(USING_BEAM);
    }

    private void setUsingBeam(boolean isUsingBeam) {
        this.field_70180_af.func_187227_b(USING_BEAM, (Object)isUsingBeam);
    }

    public boolean isChargingBeam() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGING_BEAM);
    }

    private void setChargingBeam(boolean isChargingBeam) {
        this.field_70180_af.func_187227_b(CHARGING_BEAM, (Object)isChargingBeam);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("active", this.isActive());
        compound.func_74757_a("summoned", this.isSummoned());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setActive(compound.func_74767_n("active"));
        this.setSummoned(compound.func_74767_n("summoned"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.func_226281_cx_() - first.func_226281_cx_(), second.func_226277_ct_() - first.func_226277_ct_()) * 57.29577951308232 + 90.0;
    }

    public static class BeamAttackAI
    extends Goal {
        private TimeGuardianEntity timeGuardian;
        private int tickCounter;
        private int attackTick = 300;

        public BeamAttackAI(TimeGuardianEntity timeGuardian) {
            this.timeGuardian = timeGuardian;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public static boolean canSeeEntity(Vec3d observer, Entity subject) {
            if (observer == null || subject == null) {
                return false;
            }
            AxisAlignedBB axisalignedbb = subject.func_174813_aQ().func_186662_g((double)0.3f);
            Vec3d subjectLocation = new Vec3d(subject.func_226277_ct_(), subject.func_226278_cu_() + (double)subject.func_70047_e(), subject.func_226281_cx_());
            BlockRayTraceResult traceToBlocks = subject.field_70170_p.func_217299_a(new RayTraceContext(observer, subjectLocation, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, subject));
            if (traceToBlocks.func_216346_c() != RayTraceResult.Type.MISS) {
                subjectLocation = traceToBlocks.func_216347_e();
            }
            Optional traceToEntity = axisalignedbb.func_216365_b(observer, subjectLocation);
            return traceToEntity.isPresent();
        }

        public boolean func_75250_a() {
            return this.timeGuardian.func_110143_aJ() <= this.timeGuardian.func_110138_aP() / 2.0f && !this.timeGuardian.isUsingRegularAttack();
        }

        public boolean func_75253_b() {
            if (this.tickCounter > this.attackTick || !super.func_75253_b()) {
                this.timeGuardian.setChargingBeam(false);
                this.timeGuardian.setUsingBeam(false);
                return false;
            }
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.tickCounter = -45;
            this.timeGuardian.setChargingBeam(true);
            this.timeGuardian.func_70661_as().func_75499_g();
            this.timeGuardian.field_70160_al = true;
            this.timeGuardian.useBeam(true);
        }

        private float updateRotation(float currentAngle, float targetAngle, float maxChange) {
            float change = MathHelper.func_76142_g((float)(targetAngle - currentAngle));
            return MathHelper.func_76142_g((float)(currentAngle + this.timeGuardian.field_70146_Z.nextFloat() * 1.5f - 0.75f + change / maxChange));
        }

        private void updateLaser() {
            if (this.timeGuardian.field_70170_p != null && this.timeGuardian.func_70638_az() != null) {
                this.timeGuardian.setPrevLaserPitch(this.timeGuardian.getLaserPitch());
                this.timeGuardian.setPrevLaserYaw(this.timeGuardian.getLaserYaw());
                double targetX = this.timeGuardian.func_70638_az().func_226277_ct_();
                double targetY = this.timeGuardian.func_70638_az().func_226278_cu_() + (double)this.timeGuardian.func_70638_az().func_213302_cg() / 2.0;
                double targetZ = this.timeGuardian.func_70638_az().func_226281_cx_();
                double rot = (double)this.timeGuardian.field_70761_aq * 0.01745329238474369 + 1.5707963267948966;
                double lureX = Math.cos(rot) * (double)(this.timeGuardian.func_213311_cf() + 1.0f) + this.timeGuardian.func_226277_ct_();
                double lureY = (double)(this.timeGuardian.func_213302_cg() + 1.0f) + this.timeGuardian.func_226278_cu_();
                double lureZ = Math.sin(rot) * (double)(this.timeGuardian.func_213311_cf() + 1.0f) + this.timeGuardian.func_226281_cx_();
                Vec3d lureVec = new Vec3d(lureX, lureY, lureZ);
                double d0 = targetX - lureX;
                double d1 = targetY - lureY;
                double d2 = targetZ - lureZ;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float targetYaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                this.timeGuardian.setLaserPitch(this.updateRotation(this.timeGuardian.getLaserPitch(), targetPitch, 35.0f - (float)this.timeGuardian.field_70170_p.func_175659_aa().func_151525_a() * 2.0f));
                this.timeGuardian.setLaserYaw(this.updateRotation(this.timeGuardian.getLaserYaw(), targetYaw, 20.0f - (float)this.timeGuardian.field_70170_p.func_175659_aa().func_151525_a() * 2.0f));
                Vec3d laserAngle = Vec3d.func_189986_a((float)this.timeGuardian.getLaserPitch(), (float)this.timeGuardian.getLaserYaw());
                double range = 30.0;
                Vec3d hitVec = lureVec.func_178787_e(laserAngle.func_186678_a(range));
                BlockRayTraceResult trace = this.timeGuardian.field_70170_p.func_217299_a(new RayTraceContext(lureVec, hitVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.timeGuardian));
                if (trace.func_216346_c() != RayTraceResult.Type.MISS) {
                    hitVec = trace.func_216347_e();
                }
                float f = 1.0f;
                if (this.timeGuardian.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    f += 2.0f;
                }
                LivingEntity base = null;
                for (LivingEntity entity : this.timeGuardian.field_70170_p.func_217357_a(LivingEntity.class, this.timeGuardian.func_174813_aQ().func_186662_g(30.0))) {
                    AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)0.3f);
                    Optional traceToEntity = axisalignedbb.func_216365_b(lureVec, hitVec);
                    if (!traceToEntity.isPresent() || !BeamAttackAI.canSeeEntity(lureVec, (Entity)entity) || entity == this.timeGuardian || base != null && !(this.timeGuardian.func_70032_d((Entity)entity) < this.timeGuardian.func_70032_d((Entity)base))) continue;
                    base = entity;
                }
                if (base != null) {
                    base.func_70097_a(DamageSource.func_76354_b((Entity)this.timeGuardian, (Entity)this.timeGuardian), f);
                    base.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.timeGuardian), (float)this.timeGuardian.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 2.0f);
                    base.func_195064_c(new EffectInstance(Effects.field_76421_d, 140 * (int)f, 2));
                    base.func_195064_c(new EffectInstance(Effects.field_76437_t, 140 * (int)f, 2));
                }
            }
        }

        public void func_75246_d() {
            this.timeGuardian.func_70661_as().func_75499_g();
            if (this.tickCounter == 0) {
                this.timeGuardian.setChargingBeam(false);
                this.timeGuardian.setUsingBeam(true);
                this.timeGuardian.func_184185_a(SoundHandler.HENOS_LASER, 1.0f, this.timeGuardian.func_70647_i());
            } else if (this.tickCounter < this.attackTick) {
                this.updateLaser();
            }
            ++this.tickCounter;
            super.func_75246_d();
        }

        public void func_75251_c() {
            this.timeGuardian.useBeam(false);
        }
    }

    public class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        TimeGuardianEntity timeGuardian;

        public MeleeAttackGoal(TimeGuardianEntity timeGuardian, double speedIn, boolean useLongMemory) {
            super((CreatureEntity)timeGuardian, speedIn, useLongMemory);
            this.timeGuardian = timeGuardian;
        }

        public boolean func_75250_a() {
            if (this.timeGuardian.func_110143_aJ() >= this.timeGuardian.func_110138_aP() / 2.0f) {
                return super.func_75250_a();
            }
            if (this.timeGuardian.func_110143_aJ() <= this.timeGuardian.func_110138_aP() / 2.0f && !this.timeGuardian.isUsingBeamAttack()) {
                if (this.timeGuardian.func_70638_az() != null) {
                    if (this.timeGuardian.func_70068_e((Entity)this.timeGuardian.func_70638_az()) <= 10.0) {
                        return super.func_75250_a();
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (this.timeGuardian.func_110143_aJ() <= this.timeGuardian.func_110138_aP() / 2.0f && !this.timeGuardian.isUsingBeamAttack()) {
                if (this.timeGuardian.func_70638_az() != null) {
                    if (this.timeGuardian.func_70068_e((Entity)this.timeGuardian.func_70638_az()) <= 10.0) {
                        return super.func_75253_b();
                    }
                    return false;
                }
                return false;
            }
            if (this.timeGuardian.func_110143_aJ() > this.timeGuardian.func_110138_aP() / 2.0f) {
                return super.func_75253_b();
            }
            return false;
        }

        public void func_75249_e() {
            super.func_75251_c();
            this.timeGuardian.useRegularAttack(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.timeGuardian.useRegularAttack(false);
        }
    }
}

