/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import superlord.prehistoricfauna.block.TriceratopsEggBlock;
import superlord.prehistoricfauna.entity.AnkylosaurusEntity;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.util.SoundHandler;

public class TriceratopsEntity
extends AbstractChestedHorseEntity {
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_JUVENILE = EntityDataManager.func_187226_a(TriceratopsEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int warningSoundTicks;
    private int isDigging;
    public float ridingXZ;
    public float ridingY = 1.0f;
    private boolean allowStandSliding;

    public TriceratopsEntity(EntityType<? extends TriceratopsEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        TriceratopsEntity entity = new TriceratopsEntity(ModEntityTypes.TRICERATOPS_ENTITY, this.field_70170_p);
        entity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.BREEDING, null, null);
        return entity;
    }

    public void func_70873_a(int age) {
        super.func_70873_a(age);
        if (this.func_70874_b() >= -12000 && this.func_70874_b() < 0) {
            this.setJuvenile(true);
        } else if (this.func_70874_b() >= 0) {
            this.setJuvenile(false);
        }
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isJuvenile() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_JUVENILE);
    }

    private void setJuvenile(boolean isJuvenile) {
        this.field_70180_af.func_187227_b(IS_JUVENILE, (Object)isJuvenile);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == BlockInit.OSMUNDA.func_199767_j();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new TriceratopsFollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, AnkylosaurusEntity.class, 7.0f, 1.25, 1.25));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(2, (Goal)new AttackPlayerGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new MateGoal(this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected SoundEvent func_184639_G() {
        return SoundHandler.TRICERATOPS_IDLE;
    }

    protected void func_190680_a(SoundType p_190680_1_) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundHandler.TRICERATOPS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundHandler.TRICERATOPS_DEATH;
    }

    protected SoundEvent func_184785_dv() {
        return SoundHandler.TRICERATOPS_WARN;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        int i;
        if (distance > 1.0f) {
            this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
        }
        if ((i = this.func_225508_e_(distance, damageMultiplier)) <= 0) {
            return false;
        }
        this.func_70097_a(DamageSource.field_76379_h, i);
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184182_bu()) {
                entity.func_70097_a(DamageSource.field_76379_h, (float)i);
            }
        }
        this.func_226295_cZ_();
        return true;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundHandler.TRICERATOPS_WARN, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(IS_JUVENILE, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HasEgg", this.hasEgg());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHasEgg(compound.func_74767_n("HasEgg"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
        }
        if (this.getRidingPlayer() != null && this.getRidingPlayer() instanceof PlayerEntity && this.func_70638_az() != this.getRidingPlayer()) {
            this.field_70177_z = this.field_70761_aq;
            this.field_70177_z = this.getRidingPlayer().field_70177_z;
            this.field_70759_as = this.getRidingPlayer().field_70177_z;
            float radius = this.ridingXZ * 0.7f * -3.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = this.ridingY * 4.0f;
            this.getRidingPlayer().func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY - 1.75, this.func_226281_cx_() + extraZ);
        }
    }

    public void func_213352_e(Vec3d positionIn) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                    this.field_110285_bP = 0;
                }
                if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd() && !this.allowStandSliding) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
                    double d0 = this.func_110215_cj() * (double)this.field_110277_bt * (double)this.func_226269_ah_();
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    Vec3d vec3d = this.func_213322_ci();
                    this.func_213293_j(vec3d.field_72450_a, d1, vec3d.field_72449_c);
                    this.func_110255_k(true);
                    this.field_70160_al = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.field_110277_bt), 0.0, (double)(0.4f * f3 * this.field_110277_bt)));
                        this.func_205715_ee();
                    }
                    this.field_110277_bt = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_213352_e(new Vec3d((double)f, positionIn.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.field_110277_bt = 0.0f;
                    this.func_110255_k(false);
                }
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(positionIn);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected boolean func_190678_b(PlayerEntity player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        Item item = stack.func_77973_b();
        if (item == BlockInit.HORSETAIL.func_199767_j()) {
            f = 2.0f;
            i = 20;
        } else if (item == BlockInit.TALL_HORSETAIL.func_199767_j()) {
            f = 1.0f;
            i = 30;
        } else if (item == BlockInit.OSMUNDA.func_199767_j()) {
            f = 20.0f;
            i = 180;
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == BlockInit.TALL_OSMUNDA.func_199767_j()) {
            f = 3.0f;
            i = 60;
        } else if (item == BlockInit.CLUBMOSS.func_199767_j()) {
            f = 4.0f;
            i = 60;
        } else if (item == BlockInit.MARCHANTIA.func_199767_j()) {
            f = 3.0f;
            i = 80;
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        return flag;
    }

    class TriceratopsFollowParentGoal
    extends Goal {
        private final TriceratopsEntity babyTriceratopsEntity;
        private TriceratopsEntity parentTriceratopsEntity;
        private final double moveSpeed;
        private int delayCounter;

        public TriceratopsFollowParentGoal(TriceratopsEntity triceratops, double speed) {
            this.babyTriceratopsEntity = triceratops;
            this.moveSpeed = speed;
        }

        public boolean func_75250_a() {
            if (this.babyTriceratopsEntity.func_70631_g_() && !this.babyTriceratopsEntity.isJuvenile()) {
                List list = this.babyTriceratopsEntity.field_70170_p.func_217357_a(((Object)((Object)this.babyTriceratopsEntity)).getClass(), this.babyTriceratopsEntity.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                TriceratopsEntity triceratopsEntity = null;
                double d0 = Double.MAX_VALUE;
                for (TriceratopsEntity triceratopsEntity1 : list) {
                    double d1;
                    if (triceratopsEntity1.func_70631_g_() || (d1 = this.babyTriceratopsEntity.func_70068_e((Entity)triceratopsEntity1)) > d0) continue;
                    d0 = d1;
                    triceratopsEntity = triceratopsEntity1;
                }
                if (triceratopsEntity == null) {
                    return false;
                }
                if (d0 < 9.0) {
                    return false;
                }
                this.parentTriceratopsEntity = triceratopsEntity;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!this.babyTriceratopsEntity.isJuvenile() || !this.babyTriceratopsEntity.func_70631_g_()) {
                return false;
            }
            if (!this.parentTriceratopsEntity.func_70089_S()) {
                return false;
            }
            if (this.babyTriceratopsEntity.func_70631_g_() && !this.babyTriceratopsEntity.isJuvenile()) {
                double d0 = this.babyTriceratopsEntity.func_70068_e((Entity)this.parentTriceratopsEntity);
                return !(d0 < 9.0) && !(d0 > 256.0);
            }
            return false;
        }

        public void func_75249_e() {
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            this.parentTriceratopsEntity = null;
        }

        public void func_75246_d() {
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                this.babyTriceratopsEntity.func_70661_as().func_75497_a((Entity)this.parentTriceratopsEntity, this.moveSpeed);
            }
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final TriceratopsEntity triceratops;

        MateGoal(TriceratopsEntity triceratops, double speedIn) {
            super((AnimalEntity)triceratops, speedIn);
            this.triceratops = triceratops;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.triceratops.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)null);
            }
            this.triceratops.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final TriceratopsEntity triceratops;

        LayEggGoal(TriceratopsEntity triceratops, double speedIn) {
            super((CreatureEntity)triceratops, speedIn, 16);
            this.triceratops = triceratops;
        }

        public boolean func_75250_a() {
            return this.triceratops.hasEgg() ? super.func_75250_a() : false;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.triceratops.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = new BlockPos((Entity)this.triceratops);
            if (!this.triceratops.func_70090_H() && this.func_179487_f()) {
                if (this.triceratops.isDigging < 1) {
                    this.triceratops.setDigging(true);
                } else if (this.triceratops.isDigging > 200) {
                    World world = this.triceratops.field_70170_p;
                    world.func_184133_a((PlayerEntity)null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)BlockInit.TRICERATOPS_EGG.func_176223_P().func_206870_a((IProperty)TriceratopsEggBlock.EGGS, (Comparable)Integer.valueOf(this.triceratops.field_70146_Z.nextInt(4) + 1)), 3);
                    this.triceratops.setHasEgg(false);
                    this.triceratops.setDigging(false);
                    this.triceratops.func_204700_e(600);
                }
                if (this.triceratops.isDigging()) {
                    this.triceratops.isDigging++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == BlockInit.LOAM || block == BlockInit.MOSSY_DIRT || block == Blocks.field_196661_l;
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)TriceratopsEntity.this, 2.0);
        }

        public boolean func_75250_a() {
            return !TriceratopsEntity.this.func_70631_g_() && !TriceratopsEntity.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)TriceratopsEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.field_75439_d <= 0 && !TriceratopsEntity.this.func_110248_bS()) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0 && !TriceratopsEntity.this.func_110248_bS()) {
                if (this.field_75439_d <= 0) {
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    TriceratopsEntity.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)TriceratopsEntity.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (TriceratopsEntity.this.func_70631_g_() && !TriceratopsEntity.this.isJuvenile()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof TriceratopsEntity && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)TriceratopsEntity.this, PlayerEntity.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (TriceratopsEntity.this.func_70631_g_() && !TriceratopsEntity.this.isJuvenile() || TriceratopsEntity.this.func_110248_bS()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (TriceratopsEntity triceratops : TriceratopsEntity.this.field_70170_p.func_217357_a(TriceratopsEntity.class, TriceratopsEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!triceratops.func_70631_g_() || triceratops.isJuvenile()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }
}

