/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity.tile;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import superlord.prehistoricfauna.block.PaleontologyTableBlock;
import superlord.prehistoricfauna.entity.tile.PaleontologyTableTileEntity;
import superlord.prehistoricfauna.init.ContainerRegistry;

public class PaleontologyTableContainer
extends Container {
    private final IWorldPosCallable canInteractWithCallable;
    private final PaleontologyTableTileEntity tileEntity;

    public PaleontologyTableContainer(int windowID, PlayerInventory playerInventory, final PaleontologyTableTileEntity tileEntity) {
        super((ContainerType)ContainerRegistry.PALEONTOLOGY_TABLE.get(), windowID);
        int i;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.tileEntity = tileEntity;
        int playerX = 8;
        int playerY = 84;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, playerX + i * 18, playerY + 58));
        }
        for (i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)playerInventory, k + i * 9 + 9, playerX + k * 18, playerY + i * 18));
            }
        }
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.tileEntity.getItemStackHandler(), 0, 36, 42){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return super.func_75214_a(stack) && tileEntity.isFossilStack(stack);
            }
        });
        int resultX = 92;
        int resultY = 23;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new PaleontologyTaleResultSlot(playerInventory.field_70458_d, this.tileEntity.getInventory(), PaleontologyTableTileEntity.SLOT_RESULTS[0] + j * 3 + i2, resultX + i2 * 18, resultY + j * 18));
            }
        }
        this.func_216961_a(this.tileEntity.getIntArray());
    }

    public PaleontologyTableContainer(int windowID, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowID, playerInventory, PaleontologyTableContainer.getTileEntity(playerInventory, data));
    }

    private static PaleontologyTableTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "Error: " + PaleontologyTableContainer.class.getSimpleName() + " - Player Inventory cannot be null!");
        Objects.requireNonNull(data, "Error: " + PaleontologyTableContainer.class.getSimpleName() + " - Packer Buffer Data cannot be null!");
        TileEntity tileEntityAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileEntityAtPos instanceof PaleontologyTableTileEntity) {
            return (PaleontologyTableTileEntity)tileEntityAtPos;
        }
        throw new IllegalStateException("Error: " + PaleontologyTableContainer.class.getSimpleName() + " - TileEntity is not corrent! " + tileEntityAtPos);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return (Boolean)this.canInteractWithCallable.func_221485_a((world, blockPos) -> world.func_180495_p(blockPos).func_177230_c() instanceof PaleontologyTableBlock ? playerIn.func_70092_e((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5) <= 64.0 : false, (Object)true);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        int playerInvSize = this.field_75151_b.size() - this.tileEntity.getInventorySize();
        Slot sourceSlot = (Slot)this.field_75151_b.get(index);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (index >= playerInvSize) {
            if (!this.func_75135_a(sourceStack, 0, playerInvSize, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (this.tileEntity.isFossilStack(sourceStack)) {
            int slotIndex = 0;
            if (!this.func_75135_a(sourceStack, playerInvSize + slotIndex, playerInvSize + slotIndex + 1, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190926_b()) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        if (sourceStack.func_190916_E() == copyOfSourceStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        sourceSlot.func_190901_a(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getWorkProgressionScaled(int size) {
        return this.tileEntity.getWorkProgressionScaled(size);
    }

    public class PaleontologyTaleResultSlot
    extends Slot {
        private final PlayerEntity player;
        private int removeCount;

        public PaleontologyTaleResultSlot(PlayerEntity player, IInventory inventoryIn, int slotIndex, int xPosition, int yPosition) {
            super(inventoryIn, slotIndex, xPosition, yPosition);
            this.player = player;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int amount) {
            if (this.func_75216_d()) {
                this.removeCount += Math.min(amount, this.func_75211_c().func_190916_E());
            }
            return super.func_75209_a(amount);
        }

        public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
            this.func_75208_c(stack);
            super.func_190901_a(thePlayer, stack);
            return stack;
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.func_75208_c(stack);
        }

        protected void func_75208_c(ItemStack stack) {
            stack.func_77980_a(this.player.field_70170_p, this.player, this.removeCount);
            if (!this.player.field_70170_p.field_72995_K && this.field_75224_c instanceof PaleontologyTableTileEntity) {
                ((PaleontologyTableTileEntity)this.field_75224_c).givePlayerXP(this.player, this.removeCount);
            }
            this.removeCount = 0;
        }
    }
}

