/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.entity.tile;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import superlord.prehistoricfauna.entity.tile.PaleontologyTableContainer;
import superlord.prehistoricfauna.init.TileEntityRegistry;
import superlord.prehistoricfauna.item.FossilItem;
import superlord.prehistoricfauna.recipes.RecipePaleontologyTable;

public class PaleontologyTableTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
INameable {
    public static final float RECIPE_DEFAULT_XP = 0.7f;
    public static final int WORK_TIME_MAX = 40;
    public static final int SLOT_FOSSIL = 0;
    public static final int[] SLOT_RESULTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final LazyOptional<TileRecipeInventory> inventoryCapabilityExternal;
    private final LazyOptional<RangedWrapper> inventoryCapabilityExternalUp;
    private final LazyOptional<RangedWrapper> inventoryCapabilityExternalDown;
    private final LazyOptional<RangedWrapper> inventoryCapabilityExternalSides;
    private final TileRecipeInventory inventory;
    private int workTime = 0;
    private RecipePaleontologyTable recipe;
    private ITextComponent customName;
    private final IIntArray syncVariables = new IIntArray(){

        public int func_221476_a(int index) {
            return PaleontologyTableTileEntity.this.workTime;
        }

        public void func_221477_a(int index, int value) {
            PaleontologyTableTileEntity.this.workTime = value;
        }

        public int func_221478_a() {
            return 1;
        }
    };

    public PaleontologyTableTileEntity() {
        super((TileEntityType)TileEntityRegistry.PALEONTOLOGY_TABLE.get());
        this.inventory = new TileRecipeInventory(10);
        this.inventoryCapabilityExternal = LazyOptional.of(() -> this.inventory);
        this.inventoryCapabilityExternalUp = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory.itemStackHandler, 0, 1));
        this.inventoryCapabilityExternalSides = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory.itemStackHandler, 0, 1));
        this.inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory.itemStackHandler, 1, 10));
    }

    public int getWorkTime() {
        return this.workTime;
    }

    public void setWorkTime(int time) {
        this.workTime = time;
    }

    public boolean isWorking() {
        return this.workTime > 0;
    }

    public IIntArray getIntArray() {
        return this.syncVariables;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getWorkProgressionScaled(int size) {
        return size * this.syncVariables.func_221476_a(0) / 40;
    }

    public ItemStack getFossilStack() {
        return this.inventory.func_70301_a(0);
    }

    public boolean isFossilStack(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof FossilItem;
    }

    public void updateRecipe() {
        if (!this.hasRecipe() || !this.hasInput()) {
            Optional<IRecipe<IInventory>> recipe = this.getCurrentRecipe();
            this.recipe = recipe.isPresent() && recipe.get() instanceof RecipePaleontologyTable ? (RecipePaleontologyTable)recipe.get() : null;
        }
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public boolean hasInput() {
        return this.recipe.func_77569_a(this.inventory, this.field_145850_b);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean hasWorkTimeLeft = false;
            if (!this.inventory.func_70301_a(0).func_190926_b()) {
                this.updateRecipe();
                if (this.hasRecipe() && this.hasInput() && this.hasFreeSlot(SLOT_RESULTS)) {
                    hasWorkTimeLeft = true;
                    if (this.workTime++ >= 40) {
                        ItemStack resultStack = this.recipe.func_77572_b(this.inventory);
                        boolean foundSameResult = false;
                        for (int index : SLOT_RESULTS) {
                            ItemStack nextResultStack = this.inventory.func_70301_a(index);
                            if (nextResultStack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)resultStack, (ItemStack)nextResultStack) || nextResultStack.func_190916_E() + resultStack.func_190916_E() >= this.inventory.getSlotLimit(index)) continue;
                            nextResultStack.func_190917_f(resultStack.func_190916_E());
                            this.getFossilStack().func_190918_g(1);
                            foundSameResult = true;
                            break;
                        }
                        if (!foundSameResult) {
                            this.inventory.func_70299_a(this.getNextFreeSlot(SLOT_RESULTS), resultStack);
                            this.getFossilStack().func_190918_g(1);
                        }
                        this.workTime = 0;
                    }
                }
            }
            if (!hasWorkTimeLeft) {
                this.workTime = 0;
            }
        }
    }

    public void givePlayerXP(PlayerEntity player, int totalOrbCount) {
        float experience = (float)totalOrbCount * 0.7f;
        if (experience < 1.0f) {
            int i = MathHelper.func_76141_d((float)((float)totalOrbCount * experience));
            if (i < MathHelper.func_76123_f((float)((float)totalOrbCount * experience)) && Math.random() < (double)((float)totalOrbCount * experience - (float)i)) {
                ++i;
            }
            totalOrbCount = i;
        }
        while (totalOrbCount > 0) {
            int orbCount = ExperienceOrbEntity.func_70527_a((int)totalOrbCount);
            totalOrbCount -= orbCount;
            player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, orbCount));
        }
    }

    public Optional<IRecipe<IInventory>> getCurrentRecipe() {
        return this.field_145850_b.func_199532_z().func_215371_a(RecipePaleontologyTable.RECIPE_TYPE_PALEONTOLOGY_TABLE, (IInventory)this.inventory, this.field_145850_b);
    }

    public TileRecipeInventory getInventory() {
        return this.inventory;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.inventory.itemStackHandler;
    }

    public int getInventorySize() {
        return this.inventory.func_70302_i_();
    }

    public int getNextFreeSlot(int[] indexes) {
        for (int index : indexes) {
            if (!this.inventory.func_70301_a(index).func_190926_b()) continue;
            return index;
        }
        return -1;
    }

    public int getNextFreeSlot() {
        for (int index = 0; index < this.inventory.func_70302_i_(); ++index) {
            if (!this.inventory.func_70301_a(index).func_190926_b()) continue;
            return index;
        }
        return -1;
    }

    public boolean hasFreeSlot(int[] indexes) {
        for (int index : indexes) {
            if (!this.inventory.func_70301_a(index).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFreeSlot() {
        for (int index = 0; index < this.inventory.func_70302_i_(); ++index) {
            if (!this.inventory.func_70301_a(index).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean isSlotFull(int index) {
        ItemStack itemStack = this.inventory.func_70301_a(index);
        return itemStack.func_190916_E() >= itemStack.func_77976_d() && itemStack.func_190916_E() >= this.inventory.getSlotLimit(index);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.inventoryCapabilityExternal.cast();
            }
            switch (side) {
                case DOWN: {
                    return this.inventoryCapabilityExternalDown.cast();
                }
                case UP: {
                    return this.inventoryCapabilityExternalUp.cast();
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    return this.inventoryCapabilityExternalSides.cast();
                }
            }
        }
        return super.getCapability(capability, side);
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    private ITextComponent getDefaultName() {
        return new TranslationTextComponent("container.prehistoricfauna.paleontology_table", new Object[0]);
    }

    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new PaleontologyTableContainer(windowID, playerInventory, this);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.read(compound);
        this.workTime = compound.func_74765_d("WorkTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.inventory.write(compound);
        compound.func_74777_a("WorkTime", (short)this.workTime);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return compound;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternal.invalidate();
        this.inventoryCapabilityExternalUp.invalidate();
        this.inventoryCapabilityExternalSides.invalidate();
        this.inventoryCapabilityExternalDown.invalidate();
    }

    public class TileRecipeInventory
    implements IInventory {
        protected final ItemStackHandler itemStackHandler;

        public TileRecipeInventory(int size) {
            this.itemStackHandler = new ItemStackHandler(size){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    PaleontologyTableTileEntity.this.func_70296_d();
                }
            };
        }

        public ItemStackHandler getItemStackHandler() {
            return this.itemStackHandler;
        }

        public int func_70302_i_() {
            return this.itemStackHandler.getSlots();
        }

        public ItemStack func_70301_a(int slot) {
            return this.itemStackHandler.getStackInSlot(slot);
        }

        public ItemStack func_70298_a(int slot, int count) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(slot);
            return stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77979_a(count);
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.itemStackHandler.setStackInSlot(slot, stack);
        }

        public ItemStack func_70304_b(int index) {
            ItemStack itemStack = this.func_70301_a(index);
            if (itemStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            this.func_70299_a(index, ItemStack.field_190927_a);
            return itemStack;
        }

        public boolean func_191420_l() {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return this.itemStackHandler.isItemValid(slot, stack);
        }

        public void func_174888_l() {
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                this.itemStackHandler.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }

        public int func_70297_j_() {
            return this.itemStackHandler.getSlots();
        }

        public int getSlotLimit(int index) {
            return this.itemStackHandler.getSlotLimit(index);
        }

        public void func_70296_d() {
            PaleontologyTableTileEntity.this.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            BlockPos pos = PaleontologyTableTileEntity.this.func_174877_v();
            return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
        }

        public void read(CompoundNBT tag) {
            this.itemStackHandler.deserializeNBT(tag.func_74775_l("IInventory"));
        }

        public CompoundNBT write(CompoundNBT tag) {
            tag.func_218657_a("IInventory", (INBT)this.itemStackHandler.serializeNBT());
            return tag;
        }
    }
}

