/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;
import superlord.prehistoricfauna.gui.ChangePageButton;
import superlord.prehistoricfauna.gui.IndexPageButton;
import superlord.prehistoricfauna.init.ItemInit;
import superlord.prehistoricfauna.util.EnumPaleoPages;
import superlord.prehistoricfauna.util.StatCollector;

@OnlyIn(value=Dist.CLIENT)
public class GuiPaleo
extends Screen {
    protected static final int X = 390;
    protected static final int Y = 245;
    private static final ResourceLocation TEXTURE = new ResourceLocation("prehistoricfauna:textures/gui/paleopedia/paleopedia.png");
    private static final ResourceLocation DRAWINGS_0 = new ResourceLocation("prehistoricfauna:textures/gui/paleopedia/drawings_0.png");
    private static final Map<String, ResourceLocation> PICTURE_LOCATION_CACHE = Maps.newHashMap();
    public List<EnumPaleoPages> allPageTypes = new ArrayList<EnumPaleoPages>();
    public EnumPaleoPages pageType;
    public List<IndexPageButton> indexButtons = new ArrayList<IndexPageButton>();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    public int bookPages;
    public int bookPagesTotal = 1;
    public int indexPages;
    public int indexPagesTotal = 1;
    protected ItemStack book;
    protected boolean index;
    protected FontRenderer font = this.getFont();

    public GuiPaleo(ItemStack book) {
        super((ITextComponent)new TranslationTextComponent("paleopedia_gui", new Object[0]));
        this.book = book;
        if (!book.func_190926_b() && book.func_77973_b() != null && book.func_77973_b() == ItemInit.PALEOPEDIA.get() && book.func_77978_p() != null) {
            List<EnumPaleoPages> pages = EnumPaleoPages.containedPages(EnumPaleoPages.toList(book.func_77978_p().func_74759_k("Pages")));
            this.allPageTypes.addAll(pages);
            this.indexPagesTotal = (int)Math.ceil((double)pages.size() / 10.0);
        }
        this.index = true;
    }

    private FontRenderer getFont() {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        return font;
    }

    public void init() {
        super.init();
        int centerX = (this.width - 390) / 2;
        int centerY = (this.height - 245) / 2;
        this.previousPage = new ChangePageButton(centerX + 29, centerY + 215, false, this.bookPages, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages > 0 : this.pageType != null) {
                if (this.index) {
                    --this.indexPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                } else if (this.bookPages > 0) {
                    --this.bookPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                } else {
                    this.index = true;
                }
            }
        });
        this.addButton((Widget)this.previousPage);
        this.nextPage = new ChangePageButton(centerX + 328, centerY + 215, true, this.bookPages, 0, p_214132_1_ -> {
            if (this.index ? this.indexPages < this.indexPagesTotal - 1 : this.pageType != null && this.bookPages < this.pageType.pages) {
                if (this.index) {
                    ++this.indexPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                } else {
                    ++this.bookPages;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                }
            }
        });
        this.addButton((Widget)this.nextPage);
        if (!this.allPageTypes.isEmpty()) {
            for (int i = 0; i < this.allPageTypes.size(); ++i) {
                int xIndex = i % -2;
                int yIndex = i % 10;
                int id = 2 + i;
                IndexPageButton button = new IndexPageButton(id, centerX + 15 + xIndex * 200, centerY + 10 + yIndex * 20 - (xIndex == 1 ? 20 : 0), StatCollector.translateToLocal("paleopedia." + EnumPaleoPages.values()[this.allPageTypes.get(i).ordinal()].toString().toLowerCase()), p_214132_1_ -> {
                    if (this.indexButtons.get(id - 2) != null && this.allPageTypes.get(id - 2) != null) {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
                        this.index = false;
                        this.bookPages = 0;
                        this.pageType = this.allPageTypes.get(id - 2);
                    }
                });
                this.indexButtons.add(button);
                this.addButton((Widget)button);
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        for (Widget button : this.buttons) {
            if (!(button instanceof IndexPageButton)) continue;
            button.active = this.index;
            button.visible = this.index;
        }
        for (int i = 0; i < this.indexButtons.size(); ++i) {
            this.indexButtons.get((int)i).visible = i < 10 * (this.indexPages + 1) && i >= 10 * this.indexPages && this.index;
        }
        this.renderBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int cornerX = (this.width - 390) / 2;
        int cornerY = (this.height - 245) / 2;
        GuiPaleo.blit((int)cornerX, (int)cornerY, (float)0.0f, (float)0.0f, (int)390, (int)245, (int)390, (int)390);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        super.render(mouseX, mouseY, partialTicks);
        RenderHelper.func_227780_a_();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)cornerX, (float)cornerY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        if (!this.index) {
            this.drawPerPage(this.bookPages);
            int pageLeft = this.bookPages * 2 + 1;
            int pageRight = pageLeft + 1;
            this.font.func_211126_b("" + pageLeft, 169.56522f, 214.0f, 0x303030);
            this.font.func_211126_b("" + pageRight, 215.0f, 214.0f, 0x303030);
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_227780_a_();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void drawPerPage(int bookPages) {
        this.imageFromTxt();
        this.writeFromTxt();
    }

    public void imageFromTxt() {
        String fileName = this.pageType.toString().toLowerCase() + "_" + this.bookPages + ".txt";
        ResourceLocation fileLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "_0/" + fileName);
        ResourceLocation backupLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/en_us_0/" + fileName);
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(fileLoc);
        }
        catch (IOException e) {
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(backupLoc);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.func_199027_b(), (String)"UTF-8").iterator();
            String line = null;
            boolean linenumber = false;
            int zLevelAdd = 0;
            while (iterator.hasNext()) {
                String[] split;
                line = ((String)iterator.next()).trim();
                if ((line.contains("<") || line.contains(">")) && line.contains("<image>")) {
                    line = line.substring(8, line.length() - 1);
                    split = line.split(" ");
                    String texture = "prehistoricfauna:textures/gui/paleopedia/" + split[0];
                    ResourceLocation resourcelocation = PICTURE_LOCATION_CACHE.get(texture);
                    if (resourcelocation == null) {
                        resourcelocation = new ResourceLocation(texture);
                        PICTURE_LOCATION_CACHE.put(texture, resourcelocation);
                    }
                    GL11.glPushMatrix();
                    this.drawImage(resourcelocation, Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Float.parseFloat(split[7]) * 512.0f);
                    GL11.glPopMatrix();
                }
                if (line.contains("<item>")) {
                    line = line.substring(7, line.length() - 1);
                    split = line.split(" ");
                    RenderHelper.func_227780_a_();
                    this.drawItemStack(new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f);
                }
                if (line.contains("<block>")) {
                    line = line.substring(8, line.length() - 1);
                    split = line.split(" ");
                    RenderHelper.func_227780_a_();
                    this.drawBlockStack(new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Float.parseFloat(split[4]) * 2.0f, ++zLevelAdd);
                }
                if (!line.contains("<recipe>")) continue;
                line = line.substring(9, line.length() - 1);
                split = line.split(" ");
                RenderHelper.func_227780_a_();
                float scale = Float.parseFloat(split[split.length - 1]);
                int x = Integer.parseInt(split[split.length - 3]);
                int y = Integer.parseInt(split[split.length - 2]);
                ItemStack result = new ItemStack((IItemProvider)this.getItemByRegistryName(split[0]), 1);
                ItemStack[] ingredients = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                int j = 8;
                for (int i = split.length - 5; i >= 2; i -= 2) {
                    ingredients[j] = new ItemStack((IItemProvider)this.getItemByRegistryName(split[i]), 1);
                    --j;
                }
                RenderHelper.func_227780_a_();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)x, (float)y, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)0.0f);
                this.drawRecipe(result, ingredients);
                GL11.glPopMatrix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Item getItemByRegistryName(String registryName) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }

    private void drawRecipe(ItemStack result, ItemStack[] ingredients) {
        this.drawItemStack(result, 62, 17, 2.0f);
        for (int i = 0; i < 9; ++i) {
            this.drawItemStack(ingredients[i], i % 3 * 22 + 30, i / 3 * 22 + 10, 1.25f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)37.0f, (float)13.0f, (float)1.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
        this.drawImage(DRAWINGS_0, 0, 0, 389, 1, 50, 50, 512.0f);
        GL11.glPopMatrix();
    }

    public void writeFromTxt() {
        String fileName = this.pageType.toString().toLowerCase() + "_" + this.bookPages + ".txt";
        ResourceLocation fileLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab + "_0/" + fileName);
        ResourceLocation backupLoc = new ResourceLocation("prehistoricfauna:lang/paleopedia/en_us_0/" + fileName);
        IResource resource = null;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(fileLoc);
        }
        catch (IOException e) {
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(backupLoc);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.func_199027_b(), (String)"UTF-8").iterator();
            String line = null;
            int linenumber = 0;
            while (iterator.hasNext()) {
                line = ((String)iterator.next()).trim();
                if (line.contains("<") || line.contains(">")) continue;
                GL11.glPushMatrix();
                if (this.usingVanillaFont()) {
                    GL11.glScalef((float)0.945f, (float)0.945f, (float)0.945f);
                    GL11.glTranslatef((float)0.0f, (float)5.5f, (float)0.0f);
                }
                if (linenumber <= 19) {
                    this.font.func_211126_b(line, 20.0f, (float)(20 + linenumber * 10), 0x303030);
                } else {
                    this.font.func_211126_b(line, 220.0f, (float)((linenumber - 19) * 10), 0x303030);
                }
                ++linenumber;
                GL11.glPopMatrix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glPushMatrix();
        String s = StatCollector.translateToLocal("paleopedia." + this.pageType.toString().toLowerCase());
        float scale = this.font.func_78256_a(s) <= 85 ? 2.0f : (float)this.font.func_78256_a(s) * 0.019f;
        float scale2 = this.font.func_78256_a(s) <= 95 ? scale : (float)this.font.func_78256_a(s) * 0.015f;
        GL11.glScalef((float)scale2, (float)scale2, (float)scale2);
        this.font.func_211126_b(s, 15.0f, 5.0f, 0x303030);
        GL11.glPopMatrix();
    }

    private boolean usingVanillaFont() {
        return this.font == Minecraft.func_71410_x().field_71466_p;
    }

    public void drawImage(ResourceLocation texture, int x, int y, int u, int v, int width, int height, float scale) {
        RenderSystem.pushMatrix();
        this.minecraft.func_110434_K().func_110577_a(texture);
        RenderSystem.scalef((float)(scale / 512.0f), (float)(scale / 512.0f), (float)(scale / 512.0f));
        GuiPaleo.blit((int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)512, (int)512);
        RenderSystem.popMatrix();
    }

    private void drawItemStack(ItemStack stack, int x, int y, float scale) {
        GL11.glPushMatrix();
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)32.0f);
        float zLevel = 200.0f;
        this.itemRenderer.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.getFont();
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.itemRenderer.field_77023_b = -100.0f;
        this.itemRenderer.func_180450_b(stack, x, y);
        zLevel = 0.0f;
        this.itemRenderer.field_77023_b = 0.0f;
        GL11.glPopMatrix();
    }

    private void drawBlockStack(ItemStack stack, int x, int y, float scale, int zScale) {
        GL11.glPushMatrix();
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)32.0f);
        float zLevel = 200.0f;
        this.itemRenderer.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.getFont();
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.itemRenderer.field_77023_b = -100 + zScale * 10;
        this.itemRenderer.func_180450_b(stack, x, y);
        zLevel = 0.0f;
        this.itemRenderer.field_77023_b = 0.0f;
        GL11.glPopMatrix();
    }
}

