/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;

public class LocateBiome {
    public static ForgeRegistry<Biome> biomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;
    static TextFormatting[] textFormattingArray = new TextFormatting[]{TextFormatting.LIGHT_PURPLE, TextFormatting.YELLOW, TextFormatting.GOLD, TextFormatting.AQUA, TextFormatting.GREEN};

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return Commands.func_197057_a((String)"locatebiome").then(Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(biomeRegistry.getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)sb)).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1000, (int)25000)).executes(cs -> LocateBiome.getBiomePos((World)((CommandSource)cs.getSource()).func_197023_e(), (CommandSource)cs.getSource(), (Integer)cs.getArgument("radius", Integer.class), ((ResourceLocation)cs.getArgument("biome", ResourceLocation.class)).toString()))));
    }

    public static BlockPos biomePos(World world, CommandSource src, int radius, String biomeName) {
        BlockPos playerPos = new BlockPos(src.func_197036_d());
        BlockPos.Mutable biomePos = new BlockPos.Mutable(playerPos);
        int x = biomePos.func_177958_n() & 0xF;
        int z = biomePos.func_177952_p() & 0xF;
        int step = 50;
        for (int checkPos = 0; checkPos <= radius; checkPos += step) {
            for (int curX = -checkPos; curX <= checkPos; curX += step) {
                for (int curZ = -checkPos; curZ <= checkPos; curZ += step) {
                    if (Math.abs(curX) == checkPos || Math.abs(curZ) == checkPos) {
                        biomePos.func_223471_o(x + curX);
                        biomePos.func_223472_q(z + curZ);
                        Biome biome = world.func_226691_t_((BlockPos)biomePos);
                        if (!Objects.requireNonNull(biome.getRegistryName()).toString().equals(biomeName)) continue;
                        return biomePos;
                    }
                    curZ = checkPos - step;
                }
            }
        }
        return new BlockPos(src.func_197036_d());
    }

    public static int getBiomePos(World world, CommandSource source, int radius, String biomeName) {
        Random rand = new Random();
        BlockPos blockPos = new BlockPos(source.func_197036_d());
        BlockPos biomePos = new BlockPos((Vec3i)LocateBiome.biomePos(world, source, radius, biomeName));
        Biome biome = (Biome)biomeRegistry.getRaw(new ResourceLocation(biomeName));
        int distance = MathHelper.func_76141_d((float)LocateBiome.getBiomeDistanceFromPlayer(blockPos.func_177958_n(), blockPos.func_177952_p(), biomePos.func_177958_n(), biomePos.func_177952_p()));
        ITextComponent itextcomponent = TextComponentUtils.func_197676_a((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{biomePos.func_177958_n(), "~", biomePos.func_177952_p()})).func_211710_a(text -> text.func_150238_a(textFormattingArray[rand.nextInt(textFormattingArray.length)]).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + biomePos.func_177958_n() + " ~ " + biomePos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0]))));
        BlockPos blockPos2 = new BlockPos(source.func_197036_d());
        if (!blockPos2.equals((Object)biomePos)) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.locate.success", new Object[]{biome.getRegistryName(), itextcomponent, distance}), false);
        } else {
            source.func_197030_a(new TranslationTextComponent("commands.byg.locatebiome.failed", new Object[]{biome.getRegistryName()}).func_211710_a(text -> text.func_150238_a(TextFormatting.RED)), false);
        }
        return distance;
    }

    private static float getBiomeDistanceFromPlayer(int x1, int z1, int x2, int z2) {
        int i = x2 - x1;
        int j = z2 - z1;
        return MathHelper.func_76129_c((float)(i * i + j * j));
    }

    static CompletableFuture<Suggestions> suggest(Stream<Integer> intStream, SuggestionsBuilder builder) {
        intStream.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

