/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.server.command.debug.worldgen;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraftforge.fml.loading.FMLPaths;
import superlord.prehistoricfauna.core.world.PHFBiomes;
import superlord.prehistoricfauna.world.dimension.cretaceous.CretaceousBiomeProvider;

public class GetRiverSkyView {
    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return Commands.func_197057_a((String)"triassic").then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)500, (int)Integer.MAX_VALUE)).then(Commands.func_197056_a((String)"seed", (ArgumentType)LongArgumentType.longArg((long)0L, (long)Long.MAX_VALUE)).executes(cs -> GetRiverSkyView.test((Integer)cs.getArgument("radius", Integer.class), (Long)cs.getArgument("seed", Long.class)))));
    }

    public static int test(int range, long seed) {
        CretaceousBiomeProvider biomeProvider = new CretaceousBiomeProvider((Registry<Biome>)Registry.field_212624_m, seed);
        GetRiverSkyView.execute(biomeProvider, range);
        return 1;
    }

    public static void execute(BiomeProvider biomeProvider, int range) {
        int xRange = range;
        int zRange = range;
        BufferedImage img = new BufferedImage(xRange, zRange, 1);
        String pathLocation = FMLPaths.GAMEDIR.get().resolve("river-preview.png").toString();
        File file = new File(pathLocation);
        if (file.exists()) {
            file.delete();
        }
        for (int x = 0; x < xRange; ++x) {
            for (int z = 0; z < zRange; ++z) {
                img.setRGB(x, z, GetRiverSkyView.getColorFromBiome(biomeProvider.func_225526_b_(x, 0, z)).getRGB());
            }
        }
        try {
            file = new File(pathLocation);
            ImageIO.write((RenderedImage)img, "png", file);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private static Color getColorFromBiome(Biome biome) {
        if (biome == PHFBiomes.HELL_CREEK_RIVER) {
            return new Color(0, 55, 255);
        }
        return new Color(0, 255, 0);
    }
}

