/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.entity.TimeGuardianEntity;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.init.ItemInit;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.init.PrehistoricProfessionInit;

@Mod.EventBusSubscriber(modid="prehistoricfauna", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    public static Map<Block, Block> BLOCK_STRIPPING_MAP = new HashMap<Block, Block>();
    public static Map<Block, Block> ROCK_SMASHING_MAP = new HashMap<Block, Block>();
    public static Map<Block, Block> VANILLA_ROCK_SMASHING_MAP = new HashMap<Block, Block>();

    public static void setup() {
        CommonEvents.registerFlammable(BlockInit.ARAUCARIA_PLANKS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_PLANKS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ARAUCARIA_SLAB, 5, 20);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_SLAB, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ARAUCARIA_FENCE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_FENCE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ARAUCARIA_FENCE_GATE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_FENCE_GATE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ARAUCARIA_STAIRS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_STAIRS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOPICEOXYLON_PLANKS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOPICEOXYLON_SLAB, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOPICEOXYLON_FENCE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOPICEOXYLON_FENCE_GATE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOPICEOXYLON_STAIRS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ZAMITES_PLANKS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ZAMITES_SLAB, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ZAMITES_FENCE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ZAMITES_FENCE_GATE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ZAMITES_STAIRS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOJUNIPEROXYLON_PLANKS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOJUNIPEROXYLON_SLAB, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOJUNIPEROXYLON_FENCE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOJUNIPEROXYLON_FENCE_GATE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.PROTOJUNIPEROXYLON_STAIRS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.HEIDIPHYLLUM_PLANKS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.HEIDIPHYLLUM_SLAB, 5, 20);
        CommonEvents.registerFlammable(BlockInit.HEIDIPHYLLUM_FENCE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.HEIDIPHYLLUM_FENCE_GATE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.HEIDIPHYLLUM_STAIRS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.LIRIODENDRITES_PLANKS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.LIRIODENDRITES_SLAB, 5, 20);
        CommonEvents.registerFlammable(BlockInit.LIRIODENDRITES_FENCE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.LIRIODENDRITES_FENCE_GATE, 5, 20);
        CommonEvents.registerFlammable(BlockInit.LIRIODENDRITES_STAIRS, 5, 20);
        CommonEvents.registerFlammable(BlockInit.ARAUCARIA_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_ARAUCARIA_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_METASEQUOIA_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.ARAUCARIA_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_ARAUCARIA_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_METASEQUOIA_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.PROTOPICEOXYLON_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_PROTOPICEOXYLON_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.PROTOPICEOXYLON_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_PROTOPICEOXYLON_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.ZAMITES_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_ZAMITES_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.ZAMITES_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_ZAMITES_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.PROTOJUNIPEROXYLON_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_PROTOJUNIPEROXYLON_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.PROTOJUNIPEROXYLON_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_PROTOJUNIPEROXYLON_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.HEIDIPHYLLUM_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_HEIDIPHYLLUM_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.HEIDIPHYLLUM_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_HEIDIPHYLLUM_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.LIRIODENDRITES_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_LIRIODENDRITES_LOG, 5, 5);
        CommonEvents.registerFlammable(BlockInit.LIRIODENDRITES_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.STRIPPED_LIRIODENDRITES_WOOD, 5, 5);
        CommonEvents.registerFlammable(BlockInit.ARAUCARIA_LEAVES, 30, 60);
        CommonEvents.registerFlammable(BlockInit.METASEQUOIA_LEAVES, 30, 60);
        CommonEvents.registerFlammable(BlockInit.PROTOPICEOXYLON_LEAVES, 30, 60);
        CommonEvents.registerFlammable(BlockInit.ZAMITES_LEAVES, 30, 60);
        CommonEvents.registerFlammable(BlockInit.PROTOJUNIPEROXYLON_LEAVES, 30, 60);
        CommonEvents.registerFlammable(BlockInit.HEIDIPHYLLUM_LEAVES, 30, 60);
        CommonEvents.registerFlammable(BlockInit.LIRIODENDRITES_LEAVES, 30, 60);
        CommonEvents.registerFlammable(BlockInit.CLUBMOSS, 60, 100);
        CommonEvents.registerFlammable(BlockInit.HORSETAIL, 60, 100);
        CommonEvents.registerFlammable(BlockInit.OSMUNDA, 60, 100);
        CommonEvents.registerFlammable(BlockInit.OSMUNDACAULIS, 60, 100);
        CommonEvents.registerFlammable(BlockInit.DEAD_OSMUNDACAULIS, 60, 100);
        CommonEvents.registerFlammable(BlockInit.MARCHANTIA, 60, 100);
        CommonEvents.registerFlammable(BlockInit.TALL_HORSETAIL, 60, 100);
        CommonEvents.registerFlammable(BlockInit.TALL_OSMUNDA, 60, 100);
        CommonEvents.registerFlammable(BlockInit.CONIOPTERIS, 60, 100);
        CommonEvents.registerFlammable(BlockInit.TALL_OSMUNDACAULIS, 60, 100);
        CommonEvents.registerFlammable(BlockInit.MOSS_CARPET, 60, 20);
        CommonEvents.registerFlammable(BlockInit.MOSS_BLOCK, 60, 20);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.ARAUCARIA_LEAVES);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.METASEQUOIA_LEAVES);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.PROTOPICEOXYLON_LEAVES);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.ZAMITES_LEAVES);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.PROTOJUNIPEROXYLON_LEAVES);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.HEIDIPHYLLUM_LEAVES);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.LIRIODENDRITES_LEAVES);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.ARAUCARIA_SAPLING);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.METASEQUOIA_SAPLING);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.PROTOPICEOXYLON_SAPLING);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.ZAMITES_SAPLING);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.PROTOJUNIPEROXYLON_SAPLING);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.HEIDIPHYLLUM_SAPLING);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.LIRIODENDRITES_SAPLING);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.HORSETAIL);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.OSMUNDA);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.CONIOPTERIS);
        CommonEvents.registerCompostable(0.3f, (IItemProvider)BlockInit.OSMUNDACAULIS);
        CommonEvents.registerCompostable(0.5f, (IItemProvider)BlockInit.TALL_HORSETAIL);
        CommonEvents.registerCompostable(0.5f, (IItemProvider)BlockInit.TALL_OSMUNDA);
        CommonEvents.registerCompostable(0.5f, (IItemProvider)BlockInit.TALL_OSMUNDACAULIS);
        CommonEvents.registerCompostable(0.65f, (IItemProvider)BlockInit.CLUBMOSS);
        CommonEvents.registerCompostable(0.65f, (IItemProvider)BlockInit.MARCHANTIA);
    }

    public static void registerFlammable(Block block, int encouragement, int flammability) {
        FireBlock fireblock = (FireBlock)Blocks.field_150480_ab;
        fireblock.func_180686_a(block, encouragement, flammability);
    }

    public static void registerCompostable(float chance, IItemProvider item) {
        ComposterBlock.field_220299_b.put((Object)item.func_199767_j(), chance);
    }

    @SubscribeEvent
    public static void onBlockClicked(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        World world;
        BlockState state;
        Block block;
        if (event.getItemStack().func_77973_b() instanceof AxeItem && (block = BLOCK_STRIPPING_MAP.get((state = (world = event.getWorld()).func_180495_p(pos = event.getPos())).func_177230_c())) != null) {
            PlayerEntity entity = event.getPlayer();
            world.func_184133_a(entity, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, (BlockState)block.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, state.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                if (entity != null) {
                    event.getItemStack().func_222118_a(1, (LivingEntity)entity, p_220040_1_ -> p_220040_1_.func_213334_d(event.getHand()));
                }
            }
        }
        if (event.getItemStack().func_77973_b() == ItemInit.GEOLOGY_HAMMER.get() && PrehistoricFaunaConfig.geologyHammerMining) {
            double d2;
            double d1;
            double d0;
            PlayerEntity entity;
            world = event.getWorld();
            pos = event.getPos();
            state = world.func_180495_p(pos);
            Block block2 = ROCK_SMASHING_MAP.get(state.func_177230_c());
            Block block3 = VANILLA_ROCK_SMASHING_MAP.get(state.func_177230_c());
            if (block2 != null) {
                entity = event.getPlayer();
                world.func_184133_a(entity, pos, SoundEvents.field_187843_fX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                d0 = (double)pos.func_177958_n() + 0.5;
                d1 = (double)pos.func_177956_o() + 0.7;
                d2 = (double)pos.func_177952_p() + 0.5;
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, block2.func_176223_P(), 11);
                    if (entity != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)entity, p_220040_1_ -> p_220040_1_.func_213334_d(event.getHand()));
                    }
                }
            }
            if (block3 != null) {
                entity = event.getPlayer();
                world.func_184133_a(entity, pos, SoundEvents.field_187843_fX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                d0 = (double)pos.func_177958_n() + 0.5;
                d1 = (double)pos.func_177956_o() + 0.7;
                d2 = (double)pos.func_177952_p() + 0.5;
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, block3.func_176223_P(), 11);
                    if (entity != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)entity, p_220040_1_ -> p_220040_1_.func_213334_d(event.getHand()));
                    }
                }
            }
        }
    }

    public static void init() {
        if (PrehistoricFaunaConfig.geologyHammerMining) {
            DispenserBlock.func_199774_a((IItemProvider)((Item)ItemInit.GEOLOGY_HAMMER.get()).func_199767_j(), (IDispenseItemBehavior)new OptionalDispenseBehavior(){

                protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    World world = source.func_197524_h();
                    if (!world.func_201670_d()) {
                        this.field_218407_b = false;
                        BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
                        if (!this.field_218407_b) {
                            BlockState blockstate = world.func_180495_p(blockpos);
                            if (blockstate.func_177230_c() == Blocks.field_150348_b) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_150347_e.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_150347_e) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_150351_n.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_150322_A) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_150354_m.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_180395_cM) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196611_F.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196582_bJ) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_180395_cM.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196580_bH) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_150322_A.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196696_di) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196700_dk.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196700_dk) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_150347_e.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196799_hB) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_180395_cM.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196585_ak) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_150322_A.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196858_iR) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196884_jh.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196850_iN) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196880_jd.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196852_iO) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196881_je.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196846_iL) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196878_jb.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196842_iJ) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196874_iZ.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196854_iP) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196882_jf.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196834_iF) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196866_iV.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196844_iK) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196877_ja.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196838_iH) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196838_iH.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196832_iE) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196864_iU.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196830_iD) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196862_iT.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196840_iI) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196872_iY.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196848_iM) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196879_jc.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196856_iQ) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196883_jg.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196828_iC) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196860_iS.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == Blocks.field_196858_iR) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, Blocks.field_196884_jh.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == BlockInit.POLISHED_CHALK) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, BlockInit.CHALK.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == BlockInit.POLISHED_SILTSTONE) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, BlockInit.SILTSTONE.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == BlockInit.POLISHED_SANDSTONE) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, BlockInit.SANDSTONE.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == BlockInit.SMOOTH_CHALK) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, BlockInit.CHALK.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == BlockInit.SMOOTH_SILTSTONE) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, BlockInit.SILTSTONE.func_176223_P());
                                this.field_218407_b = true;
                            }
                            if (blockstate.func_177230_c() == BlockInit.SMOOTH_SANDSTONE) {
                                if (stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                                    stack.func_190920_e(0);
                                }
                                world.func_175656_a(blockpos, BlockInit.SANDSTONE.func_176223_P());
                                this.field_218407_b = true;
                            }
                        }
                    }
                    return stack;
                }
            });
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == PrehistoricProfessionInit.GEOLOGIST) {
            PrehistoricProfessionInit.addGeologistTrades((Int2ObjectMap<List<VillagerTrades.ITrade>>)event.getTrades());
        }
    }

    public static boolean trySpawnGolem(World world, BlockPos headPos) {
        if (world.field_72995_K) {
            return false;
        }
        BlockState stateBelow1 = world.func_180495_p(headPos.func_177979_c(1));
        BlockState stateBelow2 = world.func_180495_p(headPos.func_177979_c(2));
        BlockState stateArmNorth = world.func_180495_p(headPos.func_177979_c(1).func_177964_d(1));
        BlockState stateArmSouth = world.func_180495_p(headPos.func_177979_c(1).func_177970_e(1));
        BlockState stateArmEast = world.func_180495_p(headPos.func_177979_c(1).func_177965_g(1));
        BlockState stateArmWest = world.func_180495_p(headPos.func_177979_c(1).func_177985_f(1));
        double spawnX = (double)headPos.func_177958_n() + 0.5;
        double spawnY = (double)headPos.func_177956_o() - 1.95;
        double spawnZ = (double)headPos.func_177952_p() + 0.5;
        if (stateBelow1 == Blocks.field_150475_bE.func_176223_P() && stateBelow2 == BlockInit.HENOSTONE.func_176223_P() && stateArmNorth == BlockInit.HENOSTONE.func_176223_P() && stateArmSouth == BlockInit.HENOSTONE.func_176223_P()) {
            TimeGuardianEntity timeGuardianEntity = (TimeGuardianEntity)ModEntityTypes.TIME_GUARDIAN_ENTITY.func_200721_a(world);
            timeGuardianEntity.setSummoned(true);
            timeGuardianEntity.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.func_217376_c((Entity)timeGuardianEntity);
            world.func_175656_a(headPos.func_177979_c(1), Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(headPos.func_177979_c(2), Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(headPos.func_177979_c(1).func_177964_d(1), Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(headPos.func_177979_c(1).func_177970_e(1), Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(headPos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (stateBelow1 == Blocks.field_150475_bE.func_176223_P() && stateBelow2 == BlockInit.HENOSTONE.func_176223_P() && stateArmEast == BlockInit.HENOSTONE.func_176223_P() && stateArmWest == BlockInit.HENOSTONE.func_176223_P()) {
            TimeGuardianEntity timeGuardianEntity = (TimeGuardianEntity)ModEntityTypes.TIME_GUARDIAN_ENTITY.func_200721_a(world);
            timeGuardianEntity.setSummoned(true);
            timeGuardianEntity.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.func_217376_c((Entity)timeGuardianEntity);
            world.func_175656_a(headPos.func_177979_c(1), Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(headPos.func_177979_c(2), Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(headPos.func_177979_c(1).func_177965_g(1), Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(headPos.func_177979_c(1).func_177985_f(1), Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(headPos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void summonHenosEvent(BlockEvent.EntityPlaceEvent event) {
        if (!event.isCanceled() && event.getPlacedBlock().func_177230_c() == BlockInit.LARGE_AMMONITE_FOSSIL && event.getWorld() instanceof World) {
            CommonEvents.trySpawnGolem((World)event.getWorld(), event.getPos());
        }
    }

    static {
        BLOCK_STRIPPING_MAP.put(BlockInit.METASEQUOIA_LOG, BlockInit.STRIPPED_METASEQUOIA_LOG);
        BLOCK_STRIPPING_MAP.put(BlockInit.METASEQUOIA_WOOD, BlockInit.STRIPPED_METASEQUOIA_WOOD);
        BLOCK_STRIPPING_MAP.put(BlockInit.ARAUCARIA_LOG, BlockInit.STRIPPED_ARAUCARIA_LOG);
        BLOCK_STRIPPING_MAP.put(BlockInit.ARAUCARIA_WOOD, BlockInit.STRIPPED_ARAUCARIA_WOOD);
        BLOCK_STRIPPING_MAP.put(BlockInit.PROTOPICEOXYLON_LOG, BlockInit.STRIPPED_PROTOPICEOXYLON_LOG);
        BLOCK_STRIPPING_MAP.put(BlockInit.PROTOPICEOXYLON_WOOD, BlockInit.STRIPPED_PROTOPICEOXYLON_WOOD);
        BLOCK_STRIPPING_MAP.put(BlockInit.ZAMITES_LOG, BlockInit.STRIPPED_ZAMITES_LOG);
        BLOCK_STRIPPING_MAP.put(BlockInit.ZAMITES_WOOD, BlockInit.STRIPPED_ZAMITES_WOOD);
        BLOCK_STRIPPING_MAP.put(BlockInit.PROTOJUNIPEROXYLON_LOG, BlockInit.STRIPPED_PROTOJUNIPEROXYLON_LOG);
        BLOCK_STRIPPING_MAP.put(BlockInit.PROTOJUNIPEROXYLON_WOOD, BlockInit.STRIPPED_PROTOJUNIPEROXYLON_WOOD);
        BLOCK_STRIPPING_MAP.put(BlockInit.HEIDIPHYLLUM_LOG, BlockInit.STRIPPED_HEIDIPHYLLUM_LOG);
        BLOCK_STRIPPING_MAP.put(BlockInit.HEIDIPHYLLUM_WOOD, BlockInit.STRIPPED_HEIDIPHYLLUM_WOOD);
        BLOCK_STRIPPING_MAP.put(BlockInit.LIRIODENDRITES_LOG, BlockInit.STRIPPED_LIRIODENDRITES_LOG);
        BLOCK_STRIPPING_MAP.put(BlockInit.LIRIODENDRITES_WOOD, BlockInit.STRIPPED_LIRIODENDRITES_WOOD);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_150348_b, Blocks.field_150347_e);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_150347_e, Blocks.field_150351_n);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_150322_A, Blocks.field_150354_m);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_180395_cM, Blocks.field_196611_F);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196582_bJ, Blocks.field_180395_cM);
        ROCK_SMASHING_MAP.put(BlockInit.SMOOTH_CHALK, BlockInit.CHALK);
        ROCK_SMASHING_MAP.put(BlockInit.SMOOTH_SILTSTONE, BlockInit.SILTSTONE);
        ROCK_SMASHING_MAP.put(BlockInit.SMOOTH_SANDSTONE, BlockInit.SANDSTONE);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196580_bH, Blocks.field_150322_A);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196696_di, Blocks.field_196700_dk);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196700_dk, Blocks.field_150347_e);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196799_hB, Blocks.field_180395_cM);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196585_ak, Blocks.field_150322_A);
        ROCK_SMASHING_MAP.put(BlockInit.POLISHED_CHALK, BlockInit.CHALK);
        ROCK_SMASHING_MAP.put(BlockInit.POLISHED_SILTSTONE, BlockInit.SILTSTONE);
        ROCK_SMASHING_MAP.put(BlockInit.POLISHED_SANDSTONE, BlockInit.SANDSTONE);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196858_iR, Blocks.field_196884_jh);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196850_iN, Blocks.field_196880_jd);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196852_iO, Blocks.field_196881_je);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196846_iL, Blocks.field_196878_jb);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196842_iJ, Blocks.field_196874_iZ);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196854_iP, Blocks.field_196882_jf);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196834_iF, Blocks.field_196866_iV);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196844_iK, Blocks.field_196877_ja);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196838_iH, Blocks.field_196870_iX);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196832_iE, Blocks.field_196864_iU);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196830_iD, Blocks.field_196862_iT);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196840_iI, Blocks.field_196872_iY);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196848_iM, Blocks.field_196879_jc);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196856_iQ, Blocks.field_196883_jg);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196828_iC, Blocks.field_196860_iS);
        VANILLA_ROCK_SMASHING_MAP.put(Blocks.field_196836_iG, Blocks.field_196868_iW);
    }
}

