/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import superlord.prehistoricfauna.item.PaleopediaItem;

public enum EnumPaleoPages {
    INTRODUCTION(0),
    HELL_CREEK(2),
    TRICERATOPS(1),
    ANKYLOSAURUS(1),
    TYRANNOSAURUS(0),
    THESCELOSAURUS(0),
    BASILEMYS(0),
    DAKOTARAPTOR(0),
    DIDELPHODON(0),
    MORRISON(2),
    ALLOSAURUS(0),
    CAMARASAURUS(0),
    CERATOSAURUS(0),
    DRYOSAURUS(0),
    EILENODON(0),
    HESPERORNITHOIDES(0),
    STEGOSAURUS(0),
    ISCHIGUALASTO(3),
    HYPERODAPEDON(0),
    ISCHIGUALASTIA(0),
    SAUROSUCHUS(0),
    SILLOSUCHUS(0),
    CHROMOGISAURUS(0),
    EXAERETODON(0),
    HERRERASAURUS(0);

    public int pages;

    private EnumPaleoPages(int pages) {
        this.pages = pages;
    }

    public static List<Integer> toList(int[] containedpages) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int containedpage : containedpages) {
            if (containedpage < 0 || containedpage >= EnumPaleoPages.values().length) continue;
            intList.add(containedpage);
        }
        return intList;
    }

    public static int[] fromList(List<Integer> containedpages) {
        int[] pages = new int[containedpages.size()];
        for (int i = 0; i < pages.length; ++i) {
            pages[i] = containedpages.get(i);
        }
        return pages;
    }

    public static List<EnumPaleoPages> containedPages(List<Integer> pages) {
        ArrayList<EnumPaleoPages> list = new ArrayList<EnumPaleoPages>();
        for (Integer page : pages) {
            if (page < 0 || page >= EnumPaleoPages.values().length) continue;
            list.add(EnumPaleoPages.values()[page]);
        }
        return list;
    }

    public static boolean hasAllPages(ItemStack book) {
        ArrayList<EnumPaleoPages> allPages = new ArrayList<EnumPaleoPages>();
        for (int i = 0; i < EnumPaleoPages.values().length; ++i) {
            allPages.add(EnumPaleoPages.values()[i]);
        }
        List<EnumPaleoPages> pages = EnumPaleoPages.containedPages(EnumPaleoPages.toList(book.func_77978_p().func_74759_k("Pages")));
        Iterator iterator = allPages.iterator();
        if (iterator.hasNext()) {
            EnumPaleoPages page = (EnumPaleoPages)((Object)iterator.next());
            return !pages.contains((Object)page);
        }
        return false;
    }

    public static List<Integer> enumToInt(List<EnumPaleoPages> pages) {
        Iterator<EnumPaleoPages> itr = pages.iterator();
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (itr.hasNext()) {
            list.add(EnumPaleoPages.values()[itr.next().ordinal()].ordinal());
        }
        return list;
    }

    public static EnumPaleoPages getRand() {
        return EnumPaleoPages.values()[new Random().nextInt(EnumPaleoPages.values().length)];
    }

    public static void addRandomPage(ItemStack book) {
        List<EnumPaleoPages> list;
        if (book.func_77973_b() instanceof PaleopediaItem && (list = EnumPaleoPages.possiblePages(book)) != null && !list.isEmpty()) {
            EnumPaleoPages.addPage(list.get(new Random().nextInt(list.size())), book);
        }
    }

    public static List<EnumPaleoPages> possiblePages(ItemStack book) {
        if (book.func_77973_b() instanceof PaleopediaItem) {
            CompoundNBT tag = book.func_77978_p();
            ArrayList<EnumPaleoPages> allPages = new ArrayList<EnumPaleoPages>();
            for (EnumPaleoPages page : EnumPaleoPages.values()) {
                allPages.add(page);
            }
            List<EnumPaleoPages> containedPages = EnumPaleoPages.containedPages(EnumPaleoPages.toList(tag.func_74759_k("Pages")));
            ArrayList<EnumPaleoPages> possiblePages = new ArrayList<EnumPaleoPages>();
            for (EnumPaleoPages page : allPages) {
                if (containedPages.contains((Object)page)) continue;
                possiblePages.add(page);
            }
            return possiblePages;
        }
        return null;
    }

    public static boolean addPage(EnumPaleoPages page, ItemStack book) {
        boolean flag = false;
        if (book.func_77973_b() instanceof PaleopediaItem) {
            CompoundNBT tag = book.func_77978_p();
            List<EnumPaleoPages> enumlist = EnumPaleoPages.containedPages(EnumPaleoPages.toList(tag.func_74759_k("Pages")));
            if (!enumlist.contains((Object)page)) {
                enumlist.add(page);
                flag = true;
            }
            tag.func_74783_a("Pages", EnumPaleoPages.fromList(EnumPaleoPages.enumToInt(enumlist)));
        }
        return flag;
    }

    @Nullable
    public static EnumPaleoPages fromInt(int index) {
        if (index < 0) {
            return null;
        }
        int length = EnumPaleoPages.values().length;
        return EnumPaleoPages.values()[index % length];
    }
}

