/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.util;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;
import superlord.prehistoricfauna.block.CretaceousPortalBlock;
import superlord.prehistoricfauna.block.JurassicPortalBlock;
import superlord.prehistoricfauna.block.TriassicPortalBlock;
import superlord.prehistoricfauna.init.BlockInit;

public class TeleporterTriassic
implements ITeleporter {
    protected final Map<ColumnPos, PortalPosition> destinationCoordinateCache = Maps.newHashMapWithExpectedSize((int)4096);
    private final Object2LongMap<ColumnPos> columnMap = new Object2LongOpenHashMap();

    public boolean placeInPortal(ServerWorld world, Entity entity, float yaw) {
        Vec3d vec3d = entity.func_181014_aG();
        Direction direction = entity.func_181012_aH();
        BlockPattern.PortalInfo pattern = this.placeInExistingPortal(world, new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()), entity.func_213322_ci(), direction, vec3d.field_72450_a, vec3d.field_72448_b, entity instanceof PlayerEntity);
        if (pattern == null) {
            return false;
        }
        Vec3d position = pattern.field_222505_a;
        Vec3d motion = pattern.field_222506_b;
        entity.func_213317_d(motion);
        entity.field_70177_z = yaw + (float)pattern.field_222507_c;
        entity.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        return true;
    }

    @Nullable
    public BlockPattern.PortalInfo placeInExistingPortal(ServerWorld world, BlockPos pos, Vec3d motion, Direction direction, double x, double y, boolean isPlayer) {
        boolean isFrame = true;
        BlockPos blockpos = null;
        ColumnPos columnpos = new ColumnPos(pos);
        if (!isPlayer && this.columnMap.containsKey((Object)columnpos)) {
            return null;
        }
        PortalPosition position = this.destinationCoordinateCache.get(columnpos);
        if (position != null) {
            blockpos = position.pos;
            position.lastUpdateTime = world.func_82737_E();
            isFrame = false;
        } else {
            double d0 = Double.MAX_VALUE;
            for (int eX = -128; eX <= 128; ++eX) {
                for (int eZ = -128; eZ <= 128; ++eZ) {
                    BlockPos blockpos1 = pos.func_177982_a(eX, world.func_72940_L() - 1 - pos.func_177956_o(), eZ);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (world.func_180495_p(blockpos1).func_177230_c() == BlockInit.JURASSIC_PORTAL.get()) {
                            blockpos2 = blockpos1.func_177977_b();
                            while (world.func_180495_p(blockpos2).func_177230_c() == BlockInit.JURASSIC_PORTAL.get()) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.func_177977_b();
                            }
                            double distance = blockpos1.func_177951_i((Vec3i)pos);
                            if (d0 < 0.0 || distance < d0) {
                                d0 = distance;
                                blockpos = blockpos1;
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (blockpos == null) {
            long factor = world.func_82737_E() + 300L;
            this.columnMap.put((Object)columnpos, factor);
            return null;
        }
        if (isFrame) {
            this.destinationCoordinateCache.put(columnpos, new PortalPosition(blockpos, world.func_82737_E()));
            world.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, (Object)new BlockPos(columnpos.field_219439_a, blockpos.func_177956_o(), columnpos.field_219440_b));
        }
        BlockPattern.PatternHelper helper = JurassicPortalBlock.createPatternHelper((IWorld)world, blockpos);
        return helper.func_222504_a(direction, blockpos, y, motion, x);
    }

    public void makePortal(ServerWorld world, Entity entity) {
        Random random = new Random(world.func_72905_C());
        double d0 = -1.0;
        int entityX = MathHelper.func_76128_c((double)entity.func_226277_ct_());
        int entityY = MathHelper.func_76128_c((double)entity.func_226278_cu_());
        int entityZ = MathHelper.func_76128_c((double)entity.func_226281_cx_());
        int xPos = entityX;
        int yPos = entityY;
        int zPos = entityZ;
        int baseAxis = 0;
        int randAxis = random.nextInt(4);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int startX = entityX - 16; startX <= entityX + 16; ++startX) {
            double ePosX = (double)startX + 0.5 - entity.func_226277_ct_();
            for (int startZ = entityZ - 16; startZ <= entityZ + 16; ++startZ) {
                double ePosZ = (double)startZ + 0.5 - entity.func_226281_cx_();
                block2: for (int startY = world.func_72940_L() - 1; startY >= 0; --startY) {
                    if (!world.func_175623_d((BlockPos)mutable.func_181079_c(startX, startY, startZ))) continue;
                    while (startY > 0 && world.func_175623_d((BlockPos)mutable.func_181079_c(startX, startY - 1, startZ))) {
                        --startY;
                    }
                    for (int k3 = randAxis; k3 < randAxis + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int portalHeight = -1; portalHeight < 4; ++portalHeight) {
                                    int sPosX = startX + (k4 - 1) * l3 + j4 * i4;
                                    int sPosY = startY + portalHeight;
                                    int sPosZ = startZ + (k4 - 1) * i4 - j4 * l3;
                                    mutable.func_181079_c(sPosX, sPosY, sPosZ);
                                    System.out.println(world.func_180495_p((BlockPos)mutable));
                                    if (portalHeight < 0 && !world.func_180495_p((BlockPos)mutable).func_185904_a().func_76220_a() || portalHeight >= 0 && !world.func_175623_d((BlockPos)mutable)) continue block2;
                                }
                            }
                        }
                        double ePosY = (double)startY + 0.5 - entity.func_226278_cu_();
                        double eArea = ePosX * ePosX + ePosY * ePosY + ePosZ * ePosZ;
                        if (!(d0 < 0.0) && !(eArea < d0)) continue;
                        d0 = eArea;
                        xPos = startX;
                        yPos = startY;
                        zPos = startZ;
                        baseAxis = k3 % 4;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (int startX2 = entityX - 16; startX2 <= entityX + 16; ++startX2) {
                double ePosX2 = (double)startX2 + 0.5 - entity.func_226277_ct_();
                for (int startZ2 = entityZ - 16; startZ2 <= entityZ + 16; ++startZ2) {
                    double ePosZ2 = (double)startZ2 + 0.5 - entity.func_226281_cx_();
                    block10: for (int startY2 = world.func_72940_L() - 1; startY2 >= 0; --startY2) {
                        if (!world.func_175623_d((BlockPos)mutable.func_181079_c(startX2, startY2, startZ2))) continue;
                        while (startY2 > 0 && world.func_175623_d((BlockPos)mutable.func_181079_c(startX2, startY2 - 1, startZ2))) {
                            --startY2;
                        }
                        for (int l7 = randAxis; l7 < randAxis + 2; ++l7) {
                            int l8 = l7 % 2;
                            int k9 = 1 - l8;
                            for (int i10 = 0; i10 < 4; ++i10) {
                                for (int portalHeight2 = -1; portalHeight2 < 4; ++portalHeight2) {
                                    int sPosX2 = startX2 + (i10 - 1) * l8;
                                    int sPosY2 = startY2 + portalHeight2;
                                    int sPosZ2 = startZ2 + (i10 - 1) * k9;
                                    mutable.func_181079_c(sPosX2, sPosY2, sPosZ2);
                                    if (portalHeight2 < 0 && !world.func_180495_p((BlockPos)mutable).func_185904_a().func_76220_a() || portalHeight2 >= 0 && !world.func_175623_d((BlockPos)mutable)) continue block10;
                                }
                            }
                            double ePosY2 = (double)startY2 + 0.5 - entity.func_226278_cu_();
                            double eArea2 = ePosX2 * ePosX2 + ePosY2 * ePosY2 + ePosZ2 * ePosZ2;
                            if (!(d0 < 0.0) && !(eArea2 < d0)) continue;
                            d0 = eArea2;
                            xPos = startX2;
                            yPos = startY2;
                            zPos = startZ2;
                            baseAxis = l7 % 2;
                        }
                    }
                }
            }
        }
        int baseX = xPos;
        int baseY = yPos;
        int baseZ = zPos;
        int xAxis = baseAxis % 2;
        int zAxis = 1 - xAxis;
        if (baseAxis % 4 >= 2) {
            xAxis = -xAxis;
            zAxis = -zAxis;
        }
        if (d0 < 0.0) {
            baseY = yPos = MathHelper.func_76125_a((int)yPos, (int)70, (int)(world.func_72940_L() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int i8 = 1; i8 < 3; ++i8) {
                    for (int i9 = -1; i9 < 3; ++i9) {
                        int frameX = baseX + (i8 - 1) * xAxis + j7 * zAxis;
                        int frameY = baseY + i9;
                        int frameZ = baseZ + (i8 - 1) * zAxis - j7 * xAxis;
                        boolean flag = i9 < 0;
                        mutable.func_181079_c(frameX, frameY, frameZ);
                        world.func_175656_a((BlockPos)mutable, flag ? BlockInit.PORTAL_FRAME.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        for (int fWidth = -2; fWidth < 3; ++fWidth) {
            for (int fHeight = -1; fHeight < 4; ++fHeight) {
                if (fWidth != -2 && fWidth != 2 && fHeight != -1 && fHeight != 3) continue;
                mutable.func_181079_c(baseX + fWidth * xAxis, baseY + fHeight, baseZ + fWidth * zAxis);
                world.func_180501_a((BlockPos)mutable, BlockInit.PORTAL_FRAME.func_176223_P(), 3);
            }
        }
        BlockState portal = (BlockState)((TriassicPortalBlock)BlockInit.TRIASSIC_PORTAL.get()).func_176223_P().func_206870_a(CretaceousPortalBlock.AXIS, (Comparable)(xAxis == 0 ? Direction.Axis.Z : Direction.Axis.X));
        for (int pWidth = -1; pWidth < 2; ++pWidth) {
            for (int pHeight = 0; pHeight < 3; ++pHeight) {
                mutable.func_181079_c(baseX + pWidth * xAxis, baseY + pHeight, baseZ + pWidth * zAxis);
                world.func_180501_a((BlockPos)mutable, portal, 18);
            }
        }
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        return repositionEntity.apply(false);
    }

    static class PortalPosition {
        public final BlockPos pos;
        public long lastUpdateTime;

        public PortalPosition(BlockPos pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

