/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.util;

import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.loading.FMLPaths;

public class TreeParserUtils {
    public static final String FILE_BLUEPRINT = "import com.mojang.datafixers.Dynamic;\n\nimport net.minecraft.util.Direction;\r\nimport net.minecraft.util.math.BlockPos;\nimport net.minecraft.util.math.MutableBoundingBox;\nimport net.minecraft.world.IWorld;\nimport superlord.prehistoricfauna.world.feature.config.PHFTreeConfig;\nimport superlord.prehistoricfauna.world.feature.util.PHFAbstractTreeFeature;\n\nimport java.util.Random;\nimport java.util.Set;\nimport java.util.function.Function;\n\npublic class EmptyTree extends PHFAbstractTreeFeature<PHFTreeConfig> {\n\n    public EmptyTree(Function<Dynamic<?>, ? extends PHFTreeConfig> configIn) {\n        super(configIn);\n    }\n\n\tprotected boolean generate(Set<BlockPos> changedBlocks, IWorld world, Random rand, BlockPos pos, MutableBoundingBox boundsIn, boolean isSapling, PHFTreeConfig config) {\n\n        int randTreeHeight = config.getMinHeight() + rand.nextInt(config.getMaxPossibleHeight());\n        BlockPos.Mutable mainmutable = new BlockPos.Mutable().setPos(pos);\n\n        if (pos.getY() + randTreeHeight + 1 < world.getHeight()) {\n            if (!isDesiredGroundwDirtTag(world, pos.down(), config)) {\n                return false;\n            } else if (!this.isAnotherTreeNearby(world, pos, randTreeHeight, 0, isSapling)) {\n                return false;\n            } else if (!this.doesSaplingHaveSpaceToGrow(world, pos, randTreeHeight, 7, 5, 5, isSapling)) {\n                return false;\n            } else {\n            filler\ntrunk\ndataaa\n            }\n        }\n        return true;\n    }\n}";
    public static final String TRUNK_BUILDER = "            \tfor (int buildTrunk = 0; buildTrunk <= randTreeHeight; buildTrunk++) {\n\t\t\t\t\tplaceTrunk(config, rand, changedBlocks, world, mainmutable, boundsIn);\n\t\t\t\t\tmainmutable.move(Direction.UP);\n\t\t\t\t}\n\t\t\t\t\n            \tmainmutable.setPos(pos);\n\t\t\t\t";
    static String cachePrevious = "";

    public static void processTreeNBTData(IWorld world, BlockPos featureStartPos, List<Pair<BlockPos, CompoundNBT>> list2) {
        TreeParserUtils.translateTreeNBTData(world, featureStartPos, list2, 14, true);
    }

    public static void translateTreeNBTData(IWorld world, BlockPos featureStartPos, List<Pair<BlockPos, CompoundNBT>> list2, int treeHeight, boolean useRandTreeHeight) {
        ArrayList treeLeaveList = new ArrayList();
        ArrayList trunkLogList = new ArrayList();
        ArrayList treeBranchList = new ArrayList();
        StringBuilder builder = new StringBuilder();
        StringBuilder trunkFillerBuilder = new StringBuilder();
        trunkFillerBuilder.append("buildTrunkBase(pos, changedBlocks, world, config, rand, boundsIn, ");
        list2.forEach(o -> {
            int featureX = ((BlockPos)o.getFirst()).func_177958_n();
            int featureY = ((BlockPos)o.getFirst()).func_177956_o();
            int featureZ = ((BlockPos)o.getFirst()).func_177952_p();
            BlockPos pos = new BlockPos(featureX, featureY, featureZ);
            BlockState state = world.func_180495_p((BlockPos)o.getFirst());
            boolean trunk1x1 = pos.func_177958_n() == 0 && pos.func_177952_p() == 0;
            boolean trunk2x2 = pos.func_177958_n() == 0 && pos.func_177952_p() == 1 || pos.func_177958_n() == 0 && pos.func_177952_p() == -1 || pos.func_177958_n() == 1 && pos.func_177952_p() == 0 || pos.func_177958_n() == -1 && pos.func_177952_p() == 0;
            boolean trunkCross = pos.func_177958_n() == 0 && pos.func_177952_p() == 0 || pos.func_177958_n() == 1 && pos.func_177952_p() == 0 || pos.func_177958_n() == -1 && pos.func_177952_p() == 0 || pos.func_177958_n() == 0 && pos.func_177952_p() == 1 || pos.func_177958_n() == 0 && pos.func_177952_p() == -1;
            Block blockCheck = state.func_177230_c();
            int nbtY = featureY - 100;
            String modifiedY = String.valueOf(nbtY);
            if (useRandTreeHeight) {
                modifiedY = treeHeight > nbtY ? "randTreeHeight - " + (treeHeight - nbtY) : (treeHeight < nbtY ? "randTreeHeight + " + Math.abs(nbtY - treeHeight) : "randTreeHeight");
            }
            if (blockCheck.getRegistryName().toString().contains("log")) {
                if (nbtY == 0) {
                    trunkFillerBuilder.append("mainmutable.setPos(pos).move(").append(featureX).append(", ").append(0).append(", ").append(featureZ).append(").toImmutable(), ");
                }
                if (trunk1x1) {
                    trunkLogList.add("\t\t\t\tplaceTrunk(config, rand, changedBlocks, world, mainmutable.setPos(pos).move(" + featureX + ", " + nbtY + ", " + featureZ + "), boundsIn);\n");
                } else {
                    treeBranchList.add("\t\t\t\tplaceBranch(config, rand, changedBlocks, world, mainmutable.setPos(pos).move(" + featureX + ", " + modifiedY + ", " + featureZ + "), boundsIn);\n");
                }
            }
            if (state.func_196959_b((IProperty)LeavesBlock.field_208494_a) && (Integer)state.func_177229_b((IProperty)LeavesBlock.field_208494_a) <= 6 && blockCheck.getRegistryName().toString().contains("leaves")) {
                treeLeaveList.add("\t\t\t\tplaceLeaves(config, rand, changedBlocks, world, mainmutable.setPos(pos).move(" + featureX + ", " + modifiedY + ", " + featureZ + "), boundsIn);\n");
            }
        });
        trunkFillerBuilder.append(");");
        trunkLogList.forEach(builder::append);
        treeBranchList.forEach(builder::append);
        treeLeaveList.forEach(builder::append);
        TreeParserUtils.generateTreeFile(builder.toString(), trunkFillerBuilder.toString().replace(", );", ");"), "Protopiceoxylon7", true, featureStartPos.func_177956_o() - 100, 32, treeHeight, useRandTreeHeight);
    }

    private static void generateTreeFile(String fileData, String fillerData, String treeName, boolean processAsJavaFile, int featureY, int nbtYsize, int treeHeight, boolean usesRandTreeHeight) {
        String output = FILE_BLUEPRINT;
        output = output.replace("dataaa", fileData + "\n data2");
        output = output.replace("EmptyTree", treeName);
        output = output.replace("rth", String.valueOf(treeHeight));
        output = output.replace("filler", "\t" + fillerData);
        output = usesRandTreeHeight ? output.replace("trunk", TRUNK_BUILDER) : output.replace("trunk", "");
        if (featureY == nbtYsize) {
            output = cachePrevious.replace("data2", fileData);
        }
        if (processAsJavaFile) {
            try {
                Path file = FMLPaths.CONFIGDIR.get().resolve(treeName + ".java");
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, output.getBytes(), new OpenOption[0]);
                cachePrevious = output;
            }
            catch (IOException file) {}
        } else {
            try {
                Path file = FMLPaths.CONFIGDIR.get().resolve("tree_output.txt");
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, fileData.getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

