/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import superlord.prehistoricfauna.PrehistoricFauna;
import superlord.prehistoricfauna.init.BlockInit;
import superlord.prehistoricfauna.world.placement.GeologistCampPieces;
import superlord.prehistoricfauna.world.placement.HellCreekHutPieces;
import superlord.prehistoricfauna.world.placement.IschigualastoHutPieces;
import superlord.prehistoricfauna.world.placement.MorrisonHutPieces;
import superlord.prehistoricfauna.world.placement.PortalChamberPieces;
import superlord.prehistoricfauna.world.placement.TimeTemplePieces;
import superlord.prehistoricfauna.world.structures.GeologistCampStructure;
import superlord.prehistoricfauna.world.structures.HCHutStructure;
import superlord.prehistoricfauna.world.structures.IschigualastoStructure;
import superlord.prehistoricfauna.world.structures.MorrisonHutStructure;
import superlord.prehistoricfauna.world.structures.PortalChamber;
import superlord.prehistoricfauna.world.structures.TimeTempleStructure;

public class PrehistoricFeature {
    public static final DeferredRegister<Feature<?>> FEATURES = new DeferredRegister(ForgeRegistries.FEATURES, "prehistoricfauna");
    public static Structure<NoFeatureConfig> HELL_CREEK_HUT = new HCHutStructure(NoFeatureConfig::func_214639_a);
    public static Structure<NoFeatureConfig> MORRISON_HUT = new MorrisonHutStructure(NoFeatureConfig::func_214639_a);
    public static Structure<NoFeatureConfig> ISCHIGUALASTO_HUT = new IschigualastoStructure(NoFeatureConfig::func_214639_a);
    public static Structure<NoFeatureConfig> TIME_TEMPLE = new TimeTempleStructure(NoFeatureConfig::func_214639_a);
    public static Structure<NoFeatureConfig> PORTAL_CHAMBER = new PortalChamber(NoFeatureConfig::func_214639_a);
    public static Structure<NoFeatureConfig> GEOLOGIST_CAMP = new GeologistCampStructure(NoFeatureConfig::func_214639_a);
    public static IStructurePieceType HCHUT_PIECE = HellCreekHutPieces.Piece::new;
    public static IStructurePieceType MORRISON_HUT_PIECE = MorrisonHutPieces.Piece::new;
    public static IStructurePieceType ISCHIGUALASTO_HUT_PIECE = IschigualastoHutPieces.Piece::new;
    public static IStructurePieceType TIME_TEMPLE_PIECE = TimeTemplePieces.Piece::new;
    public static IStructurePieceType PORTAL_CHAMBER_PIECE = PortalChamberPieces.Piece::new;
    public static IStructurePieceType GEOLOGIST_CAMP_PIECE = GeologistCampPieces.Piece::new;

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        PrehistoricFauna.register(registry, HELL_CREEK_HUT, "hell_creek_hut");
        PrehistoricFauna.register(registry, MORRISON_HUT, "morrison_hut");
        PrehistoricFauna.register(registry, ISCHIGUALASTO_HUT, "ischigualasto_hut");
        PrehistoricFauna.register(registry, TIME_TEMPLE, "time_temple");
        PrehistoricFauna.register(registry, PORTAL_CHAMBER, "portal_chamber");
        PrehistoricFauna.register(registry, GEOLOGIST_CAMP, "geologist_camp");
        PrehistoricFeature.register(HCHUT_PIECE, "HCHUT_PIECE");
        PrehistoricFeature.register(MORRISON_HUT_PIECE, "MORRISON_HUT_PIECE");
        PrehistoricFeature.register(ISCHIGUALASTO_HUT_PIECE, "ISCHIGUALASTO_HUT_PIECE");
        PrehistoricFeature.register(TIME_TEMPLE_PIECE, "TIME_TEMPLE_PIECE");
        PrehistoricFeature.register(PORTAL_CHAMBER_PIECE, "PORTAL_CHAMBER_PIECE");
        PrehistoricFeature.register(GEOLOGIST_CAMP_PIECE, "GEOLOGIST_CAMP_PIECE");
    }

    static IStructurePieceType register(IStructurePieceType structurePiece, String key) {
        return (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)key.toLowerCase(Locale.ROOT), (Object)structurePiece);
    }

    public static void addSedimentDisks(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(Blocks.field_150354_m.func_176223_P(), 7, 2, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_196660_k.func_176223_P(), BlockInit.MOSSY_DIRT.func_176223_P(), Blocks.field_196661_l.func_176223_P()}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(Blocks.field_150435_aG.func_176223_P(), 4, 1, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_196660_k.func_176223_P(), Blocks.field_150435_aG.func_176223_P()}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(Blocks.field_150351_n.func_176223_P(), 6, 2, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_196660_k.func_176223_P()}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    private static <C extends IFeatureConfig, F extends Feature<C>> F register(String key, F value) {
        return (F)((Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)key, value));
    }

    private static <C extends ISurfaceBuilderConfig, F extends SurfaceBuilder<C>> F register(String key, F builderIn) {
        return (F)((SurfaceBuilder)Registry.func_218325_a((Registry)Registry.field_218378_p, (String)key, builderIn));
    }
}

