/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biomes;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.core.world.PHFConfiguredFeatures;
import superlord.prehistoricfauna.core.world.PHFSurfaceBuilders;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.world.PrehistoricFeature;
import superlord.prehistoricfauna.world.biomes.BiomeExtender;
import superlord.prehistoricfauna.world.biomes.PHFDefaultBiomeFeatures;

public class CretaceousBiomes {
    public static Biome hellCreek(float scale, float depth, boolean isClearing, boolean isHills) {
        BiomeExtender biome = new BiomeExtender(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205420_b(scale).func_205414_c(0.7f).func_205421_a(depth).func_205417_d(0.8f).func_205419_a(Biome.Category.TAIGA).func_205412_a(4159204).func_205413_b(329011).func_222351_a(PHFSurfaceBuilders.HELL_CREEK, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_196660_k.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_150435_aG.func_176223_P())).func_205418_a(null)).setSkyColor(8306591).setGrassColor(5468447).setFoliageColor(5468447);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.MARCHANTIA);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.OSMUNDA);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.HORSETAIL);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.OSMUNDA_DOUBLE);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.HORSETAIL_DOUBLE);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.CRASSOSTREA_OYSTERS);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.ALGAE);
        if (isClearing) {
            PHFDefaultBiomeFeatures.addSparseHellCreekVegetation(biome);
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.THESCELOSAURUS_ENTITY, PrehistoricFaunaConfig.thescelosaurusClearingSpawnWeight, 2, 4));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.TRICERATOPS_ENTITY, PrehistoricFaunaConfig.triceratopsClearingSpawnWeight, 2, 3));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.ANKYLOSAURUS_ENTITY, PrehistoricFaunaConfig.ankylosaurusClearingSpawnWeight, 1, 2));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.TYRANNOSAURUS_ENTITY, PrehistoricFaunaConfig.tyrannosaurusSpawnWeight, 1, 1));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.BASILEMYS_ENTITY, PrehistoricFaunaConfig.basilemysClearingSpawnWeight, 1, 2));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.DAKOTARAPTOR_ENTITY, PrehistoricFaunaConfig.dakotaraptorSpawnWeight, 1, 3));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.DIDELPHODON_ENTITY, PrehistoricFaunaConfig.didelphodonSpawnWeight, 1, 3));
        } else if (isHills) {
            PHFDefaultBiomeFeatures.addLiriodendritesForestVegetation(biome);
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.MOSS);
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.CLUBMOSS);
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.THESCELOSAURUS_ENTITY, PrehistoricFaunaConfig.thescelosaurusSpawnWeight, 2, 4));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.TRICERATOPS_ENTITY, PrehistoricFaunaConfig.triceratopsSpawnWeight, 2, 3));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.ANKYLOSAURUS_ENTITY, PrehistoricFaunaConfig.ankylosaurusSpawnWeight, 1, 2));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.TYRANNOSAURUS_ENTITY, PrehistoricFaunaConfig.tyrannosaurusSpawnWeight, 1, 1));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.BASILEMYS_ENTITY, PrehistoricFaunaConfig.basilemysSpawnWeight, 1, 2));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.DAKOTARAPTOR_ENTITY, PrehistoricFaunaConfig.dakotaraptorSpawnWeight, 1, 3));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.DIDELPHODON_ENTITY, PrehistoricFaunaConfig.didelphodonSpawnWeight, 1, 3));
        } else {
            PHFDefaultBiomeFeatures.addHellCreekVegetation(biome);
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.MOSS);
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.CLUBMOSS);
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.THESCELOSAURUS_ENTITY, PrehistoricFaunaConfig.thescelosaurusSpawnWeight, 2, 4));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.TRICERATOPS_ENTITY, PrehistoricFaunaConfig.triceratopsSpawnWeight, 2, 3));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.ANKYLOSAURUS_ENTITY, PrehistoricFaunaConfig.ankylosaurusSpawnWeight, 1, 2));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.TYRANNOSAURUS_ENTITY, PrehistoricFaunaConfig.tyrannosaurusSpawnWeight, 1, 1));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.BASILEMYS_ENTITY, PrehistoricFaunaConfig.basilemysSpawnWeight, 1, 2));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.DAKOTARAPTOR_ENTITY, PrehistoricFaunaConfig.dakotaraptorSpawnWeight, 1, 3));
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.DIDELPHODON_ENTITY, PrehistoricFaunaConfig.didelphodonSpawnWeight, 1, 3));
        }
        PHFDefaultBiomeFeatures.addHellCreekHut(biome);
        PHFConfiguredFeatures.addHCRocks(biome);
        DefaultBiomeFeatures.func_222326_g((Biome)biome);
        DefaultBiomeFeatures.func_222288_h((Biome)biome);
        DefaultBiomeFeatures.func_222300_a((Biome)biome);
        PrehistoricFeature.addSedimentDisks(biome);
        PHFConfiguredFeatures.addWaterLakesandSprings(biome);
        PHFConfiguredFeatures.addLavaLakesandSprings(biome);
        return biome;
    }

    public static Biome hellCreekRiver(float scale, float depth) {
        BiomeExtender biome = new BiomeExtender(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205420_b(scale).func_205414_c(0.7f).func_205421_a(depth).func_205417_d(0.8f).func_205419_a(Biome.Category.TAIGA).func_205412_a(4159204).func_205413_b(329011).func_222351_a(PHFSurfaceBuilders.HELL_CREEK, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_196660_k.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_150435_aG.func_176223_P())).func_205418_a(null)).setSkyColor(8306591).setGrassColor(5468447).setFoliageColor(5468447);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.ALGAE);
        DefaultBiomeFeatures.func_222313_n((Biome)biome);
        DefaultBiomeFeatures.func_222326_g((Biome)biome);
        DefaultBiomeFeatures.func_222288_h((Biome)biome);
        DefaultBiomeFeatures.func_222300_a((Biome)biome);
        PrehistoricFeature.addSedimentDisks(biome);
        PHFDefaultBiomeFeatures.addHellCreekHut(biome);
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.THESCELOSAURUS_ENTITY, PrehistoricFaunaConfig.thescelosaurusSpawnWeight, 2, 4));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.TRICERATOPS_ENTITY, PrehistoricFaunaConfig.triceratopsSpawnWeight, 2, 3));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.ANKYLOSAURUS_ENTITY, PrehistoricFaunaConfig.ankylosaurusSpawnWeight, 1, 2));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.TYRANNOSAURUS_ENTITY, PrehistoricFaunaConfig.tyrannosaurusSpawnWeight, 1, 1));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.BASILEMYS_ENTITY, PrehistoricFaunaConfig.basilemysSpawnWeight, 1, 2));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.DAKOTARAPTOR_ENTITY, PrehistoricFaunaConfig.dakotaraptorSpawnWeight, 1, 3));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.DIDELPHODON_ENTITY, PrehistoricFaunaConfig.didelphodonSpawnWeight, 1, 3));
        return biome;
    }
}

