/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.biomes;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.core.world.PHFConfiguredFeatures;
import superlord.prehistoricfauna.core.world.PHFSurfaceBuilders;
import superlord.prehistoricfauna.init.ModEntityTypes;
import superlord.prehistoricfauna.world.PrehistoricFeature;
import superlord.prehistoricfauna.world.biomes.BiomeExtender;
import superlord.prehistoricfauna.world.biomes.PHFDefaultBiomeFeatures;

public class TriassicBiomes {
    public static Biome ischigualastoForest(float scale, float depth, boolean isClearing) {
        BiomeExtender biome = new BiomeExtender(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205420_b(scale).func_205414_c(0.75f).func_205421_a(depth).func_205417_d(0.9f).func_205419_a(Biome.Category.FOREST).func_205412_a(4159204).func_205413_b(329011).func_222351_a(PHFSurfaceBuilders.ISCHIGUALASTO, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_196660_k.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_150435_aG.func_176223_P())).func_205418_a(null));
        if (!isClearing) {
            PHFDefaultBiomeFeatures.addIschigualastoVegetation(biome);
        }
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.MICHELILLOA);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.JOHNSTONIA);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.DICROIDIUM);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.CLADOPHLEBIS);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.SCYTOPHYLLUM);
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.EXAERETODON_ENTITY, PrehistoricFaunaConfig.exaeretodonSpawnWeight, 1, 3));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.CHROMOGISAURUS_ENTITY, PrehistoricFaunaConfig.chromogisaurusSpawnWeight, 1, 4));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.HERRERASAURUS_ENTITY, PrehistoricFaunaConfig.herrerasaurusSpawnWeight, 1, 2));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.HYPERODAPEDON_ENTITY, PrehistoricFaunaConfig.hyperodapedonSpawnWeight, 2, 4));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.SILLOSUCHUS_ENTITY, PrehistoricFaunaConfig.sillosuchusSpawnWeight, 1, 3));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.SAUROSUCHUS_ENTITY, PrehistoricFaunaConfig.saurosuchusSpawnWeight, 1, 2));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.ISCHIGUALASTIA_ENTITY, PrehistoricFaunaConfig.ischigualastiaSpawnWeight, 2, 5));
        DefaultBiomeFeatures.func_222326_g((Biome)biome);
        DefaultBiomeFeatures.func_222288_h((Biome)biome);
        DefaultBiomeFeatures.func_222300_a((Biome)biome);
        PrehistoricFeature.addSedimentDisks(biome);
        PHFDefaultBiomeFeatures.addIschigualastoCHut(biome);
        PHFConfiguredFeatures.addWaterLakesandSprings(biome);
        PHFConfiguredFeatures.addLavaLakesandSprings(biome);
        return biome;
    }

    public static Biome ischigualastoRiver(float scale, float depth) {
        BiomeExtender biome = new BiomeExtender(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205420_b(scale).func_205414_c(0.75f).func_205421_a(depth).func_205417_d(0.9f).func_205419_a(Biome.Category.FOREST).func_205412_a(4159204).func_205413_b(329011).func_222351_a(PHFSurfaceBuilders.ISCHIGUALASTO, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_196660_k.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_150435_aG.func_176223_P())).func_205418_a(null));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, PHFConfiguredFeatures.ALGAE);
        DefaultBiomeFeatures.func_222326_g((Biome)biome);
        DefaultBiomeFeatures.func_222288_h((Biome)biome);
        DefaultBiomeFeatures.func_222300_a((Biome)biome);
        PrehistoricFeature.addSedimentDisks(biome);
        PHFDefaultBiomeFeatures.addIschigualastoCHut(biome);
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.EXAERETODON_ENTITY, PrehistoricFaunaConfig.exaeretodonSpawnWeight, 1, 3));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.CHROMOGISAURUS_ENTITY, PrehistoricFaunaConfig.chromogisaurusSpawnWeight, 1, 4));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.HERRERASAURUS_ENTITY, PrehistoricFaunaConfig.herrerasaurusSpawnWeight, 1, 2));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.HYPERODAPEDON_ENTITY, PrehistoricFaunaConfig.hyperodapedonSpawnWeight, 2, 4));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.SILLOSUCHUS_ENTITY, PrehistoricFaunaConfig.sillosuchusSpawnWeight, 1, 3));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.SAUROSUCHUS_ENTITY, PrehistoricFaunaConfig.saurosuchusSpawnWeight, 1, 2));
        biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ModEntityTypes.ISCHIGUALASTIA_ENTITY, PrehistoricFaunaConfig.ischigualastiaSpawnWeight, 2, 5));
        return biome;
    }
}

