/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.dimension.jurassic;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import superlord.prehistoricfauna.core.world.PHFBiomes;
import superlord.prehistoricfauna.mixin.access.BiomeSourceAccess;
import superlord.prehistoricfauna.world.dimension.MasterLayer;
import superlord.prehistoricfauna.world.feature.cretaceous.PHFHillsLayer;

public class JurassicBiomeProvider
extends BiomeProvider {
    private final Int2ObjectMap<WeightedList<ResourceLocation>> hills = new Int2ObjectArrayMap();
    private final Registry<Biome> biomeRegistry;
    private final Layer layers;
    public static final List<ResourceLocation> BIOMES = new ArrayList<ResourceLocation>();

    protected JurassicBiomeProvider(Registry<Biome> biomeRegistry, long seed) {
        super(BIOMES.stream().map(arg_0 -> ((Registry)Registry.field_212624_m).func_82594_a(arg_0)).collect(Collectors.toSet()));
        this.biomeRegistry = biomeRegistry;
        this.layers = this.jurassicBiomeLayer(biomeRegistry, seed);
        this.fillHillsList();
        this.hills.forEach((integer, resourceLocationWeightedList) -> resourceLocationWeightedList.field_220658_a.forEach(entry -> {
            ResourceLocation resourceLocation = (ResourceLocation)entry.func_220647_b();
            ((BiomeSourceAccess)((Object)this)).getBiomes().add((Biome)biomeRegistry.func_82594_a(resourceLocation));
        }));
    }

    public Layer jurassicBiomeLayer(Registry<Biome> biomeRegistry, long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory layer = new MasterLayer(biomeRegistry, seed, BIOMES).func_202823_a(randomProvider.apply(485868686L));
        int size = 2;
        for (int biomeSize = 0; biomeSize <= size; ++biomeSize) {
            layer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28585L + (long)biomeSize), layer);
        }
        layer = new PHFHillsLayer(biomeRegistry, this.hills).func_202707_a(randomProvider.apply(19394585865L), layer, layer);
        layer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(285368899L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(285368899L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(596969L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(183765656L), layer);
        layer = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(958687L), layer);
        layer = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(19375756L), layer);
        return new Layer(layer);
    }

    public void fillHillsList() {
        WeightedList morrison_sub_biomes = new WeightedList();
        morrison_sub_biomes.func_226313_a_((Object)this.biomeRegistry.func_177774_c((Object)PHFBiomes.MORRISON_HILLS), 5);
        this.hills.put(JurassicBiomeProvider.getRawIdFromKey(this.biomeRegistry, this.biomeRegistry.func_177774_c((Object)PHFBiomes.MORRISON_SAVANNAH)), (Object)morrison_sub_biomes);
    }

    public static int getRawIdFromKey(Registry<Biome> biomeRegistry, ResourceLocation location) {
        return biomeRegistry.func_148757_b(biomeRegistry.func_82594_a(location));
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.layers.func_215738_a(x, z);
    }

    static {
        BIOMES.add(Registry.field_212624_m.func_177774_c((Object)PHFBiomes.MORRISON_SAVANNAH));
        BIOMES.add(Registry.field_212624_m.func_177774_c((Object)PHFBiomes.MORRISON_HILLS));
    }
}

