/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraftforge.common.IPlantable;
import superlord.prehistoricfauna.world.feature.generator.PrehistoricGiantTreeFeatureConfig;

public abstract class PrehistoricTreeFeature<T extends BaseTreeFeatureConfig>
extends AbstractTreeFeature<T> {
    public PrehistoricTreeFeature(Function<Dynamic<?>, ? extends T> p_i225810_1_) {
        super(p_i225810_1_);
    }

    protected int func_227256_a_(Random p_227256_1_, PrehistoricGiantTreeFeatureConfig p_227256_2_) {
        int i = p_227256_1_.nextInt(3) + p_227256_2_.field_227371_p_;
        if (p_227256_2_.heightInterval > 1) {
            i += p_227256_1_.nextInt(p_227256_2_.heightInterval);
        }
        return i;
    }

    private boolean isSpaceAt(IWorldGenerationBaseReader worldIn, BlockPos leavesPos, int height) {
        boolean flag = true;
        if (leavesPos.func_177956_o() >= 1 && leavesPos.func_177956_o() + height + 1 <= worldIn.getMaxHeight()) {
            for (int i = 0; i <= 1 + height; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + height - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        if (leavesPos.func_177956_o() + i >= 0 && leavesPos.func_177956_o() + i < worldIn.getMaxHeight() && PrehistoricTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)leavesPos.func_177982_a(k, i, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean validSoil(IWorldGenerationReader worldIn, BlockPos pos, IPlantable sapling) {
        BlockPos blockpos = pos.func_177977_b();
        if (PrehistoricTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos, (IPlantable)sapling) && pos.func_177956_o() >= 2) {
            this.setDirtAt(worldIn, blockpos, pos);
            this.setDirtAt(worldIn, blockpos.func_177974_f(), pos);
            this.setDirtAt(worldIn, blockpos.func_177968_d(), pos);
            this.setDirtAt(worldIn, blockpos.func_177968_d().func_177974_f(), pos);
            return true;
        }
        return false;
    }

    @Deprecated
    protected boolean func_203427_a(IWorldGenerationReader worldIn, BlockPos p_203427_2_, int p_203427_3_) {
        return this.isSpaceAt((IWorldGenerationBaseReader)worldIn, p_203427_2_, p_203427_3_) && this.validSoil(worldIn, p_203427_2_, (IPlantable)Blocks.field_196674_t);
    }

    protected boolean hasRoom(IWorldGenerationReader world, BlockPos pos, int height, BaseTreeFeatureConfig config) {
        return this.isSpaceAt((IWorldGenerationBaseReader)world, pos, height) && this.validSoil(world, pos, config.getSapling());
    }

    protected void func_227255_a_(IWorldGenerationReader p_227255_1_, Random p_227255_2_, BlockPos p_227255_3_, int p_227255_4_, Set<BlockPos> p_227255_5_, MutableBoundingBox p_227255_6_, BaseTreeFeatureConfig p_227255_7_) {
        int i = p_227255_4_ * p_227255_4_;
        for (int j = -p_227255_4_; j <= p_227255_4_ + 1; ++j) {
            for (int k = -p_227255_4_; k <= p_227255_4_ + 1; ++k) {
                int i1;
                int l = Math.min(Math.abs(j), Math.abs(j - 1));
                if (l + (i1 = Math.min(Math.abs(k), Math.abs(k - 1))) >= 7 || l * l + i1 * i1 > i) continue;
                this.func_227219_b_(p_227255_1_, p_227255_2_, p_227255_3_.func_177982_a(j, 0, k), p_227255_5_, p_227255_6_, p_227255_7_);
            }
        }
    }

    protected void func_227257_b_(IWorldGenerationReader p_227257_1_, Random p_227257_2_, BlockPos p_227257_3_, int p_227257_4_, Set<BlockPos> p_227257_5_, MutableBoundingBox p_227257_6_, BaseTreeFeatureConfig p_227257_7_) {
        int i = p_227257_4_ * p_227257_4_;
        for (int j = -p_227257_4_; j <= p_227257_4_; ++j) {
            for (int k = -p_227257_4_; k <= p_227257_4_; ++k) {
                if (j * j + k * k > i) continue;
                this.func_227219_b_(p_227257_1_, p_227257_2_, p_227257_3_.func_177982_a(j, 0, k), p_227257_5_, p_227257_6_, p_227257_7_);
            }
        }
    }

    protected void func_227254_a_(IWorldGenerationReader p_227254_1_, Random p_227254_2_, BlockPos p_227254_3_, int p_227254_4_, Set<BlockPos> p_227254_5_, MutableBoundingBox p_227254_6_, PrehistoricGiantTreeFeatureConfig p_227254_7_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i < p_227254_4_; ++i) {
            blockpos$mutable.func_189533_g((Vec3i)p_227254_3_).func_196234_d(0, i, 0);
            if (PrehistoricTreeFeature.func_214587_a((IWorldGenerationBaseReader)p_227254_1_, (BlockPos)blockpos$mutable)) {
                this.func_227216_a_(p_227254_1_, p_227254_2_, (BlockPos)blockpos$mutable, p_227254_5_, p_227254_6_, p_227254_7_);
            }
            if (i >= p_227254_4_ - 1) continue;
            blockpos$mutable.func_189533_g((Vec3i)p_227254_3_).func_196234_d(1, i, 0);
            if (PrehistoricTreeFeature.func_214587_a((IWorldGenerationBaseReader)p_227254_1_, (BlockPos)blockpos$mutable)) {
                this.func_227216_a_(p_227254_1_, p_227254_2_, (BlockPos)blockpos$mutable, p_227254_5_, p_227254_6_, p_227254_7_);
            }
            blockpos$mutable.func_189533_g((Vec3i)p_227254_3_).func_196234_d(1, i, 1);
            if (PrehistoricTreeFeature.func_214587_a((IWorldGenerationBaseReader)p_227254_1_, (BlockPos)blockpos$mutable)) {
                this.func_227216_a_(p_227254_1_, p_227254_2_, (BlockPos)blockpos$mutable, p_227254_5_, p_227254_6_, p_227254_7_);
            }
            blockpos$mutable.func_189533_g((Vec3i)p_227254_3_).func_196234_d(0, i, 1);
            if (!PrehistoricTreeFeature.func_214587_a((IWorldGenerationBaseReader)p_227254_1_, (BlockPos)blockpos$mutable)) continue;
            this.func_227216_a_(p_227254_1_, p_227254_2_, (BlockPos)blockpos$mutable, p_227254_5_, p_227254_6_, p_227254_7_);
        }
    }
}

