/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.feature.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class NoisySphereConfig
implements IFeatureConfig {
    private final BlockStateProvider blockProvider;
    private final BlockStateProvider topBlockProvider;
    private final int minHeight;
    private final int maxHeight;
    private final int minXRadius;
    private final int maxXRadius;
    private final int minYRadius;
    private final int maxYRadius;
    private final int minZRadius;
    private final int maxZRadius;
    private final double radiusDivisorPerStack;
    private final double noiseFrequency;
    private final Set<ResourceLocation> whitelistedDimensions;

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("block_provider"), this.blockProvider.func_218175_a(ops)).put(ops.createString("top_block_provider"), this.topBlockProvider.func_218175_a(ops)).put(ops.createString("min_stack_height"), ops.createInt(this.minHeight)).put(ops.createString("max_stack_height"), ops.createInt(this.maxHeight)).put(ops.createString("min_x_radius"), ops.createInt(this.minXRadius)).put(ops.createString("min_y_radius"), ops.createInt(this.minYRadius)).put(ops.createString("min_z_radius"), ops.createInt(this.minZRadius)).put(ops.createString("max_x_radius"), ops.createInt(this.maxXRadius)).put(ops.createString("max_y_radius"), ops.createInt(this.maxYRadius)).put(ops.createString("max_z_radius"), ops.createInt(this.maxZRadius)).put(ops.createString("radius_divisor_per_stack"), ops.createDouble(this.radiusDivisorPerStack)).put(ops.createString("noise_frequency"), ops.createDouble(this.noiseFrequency)).put(ops.createString("dimension_whitelist"), ops.createString(this.whitelistedDimensions.stream().map(ResourceLocation::toString).collect(Collectors.joining(","))));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> NoisySphereConfig deserialize(Dynamic<T> ops) {
        BlockStateProvider blockProvider = ((BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("block_provider").get("type").asString().orElseThrow(RuntimeException::new)))).func_227399_a_(ops.get("block_provider").orElseEmptyMap());
        BlockStateProvider topBlockProvider = ((BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("top_block_provider").get("type").asString().orElseThrow(RuntimeException::new)))).func_227399_a_(ops.get("top_block_provider").orElseEmptyMap());
        int minHeight = ops.get("min_stack_height").asInt(0);
        int maxHeight = ops.get("max_stack_height").asInt(0);
        int minXRadius = ops.get("min_x_radius").asInt(0);
        int maxXRadius = ops.get("min_y_radius").asInt(0);
        int minYRadius = ops.get("min_z_radius").asInt(0);
        int maxYRadius = ops.get("max_x_radius").asInt(0);
        int minZRadius = ops.get("max_y_radius").asInt(0);
        int maxZRadius = ops.get("max_z_radius").asInt(0);
        double radiusDivisorPerStack = ops.get("radius_divisor_per_stack").asDouble(1.0);
        double noseFreq = ops.get("noise_frequency").asDouble(1.0);
        Set<ResourceLocation> dimensionWhitelist = Arrays.stream(ops.get("dimension_whitelist").asString("minecraft:overworld").trim().replace(" ", "").split(",")).map(ResourceLocation::new).collect(Collectors.toSet());
        return new NoisySphereConfig(blockProvider, topBlockProvider, minHeight, maxHeight, minXRadius, maxXRadius, minYRadius, maxYRadius, minZRadius, maxZRadius, radiusDivisorPerStack, noseFreq, dimensionWhitelist);
    }

    NoisySphereConfig(BlockStateProvider blockProvider, BlockStateProvider topBlockProvider, int minHeight, int maxHeight, int minXRadius, int maxXRadius, int minYRadius, int maxYRadius, int minZRadius, int maxZRadius, double radiusDivisorPerStack, double noiseFrequency, Set<ResourceLocation> whitelistedDimensions) {
        this.blockProvider = blockProvider;
        this.topBlockProvider = topBlockProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.minXRadius = minXRadius;
        this.maxXRadius = maxXRadius;
        this.minYRadius = minYRadius;
        this.maxYRadius = maxYRadius;
        this.minZRadius = minZRadius;
        this.maxZRadius = maxZRadius;
        this.radiusDivisorPerStack = radiusDivisorPerStack;
        this.noiseFrequency = noiseFrequency;
        this.whitelistedDimensions = whitelistedDimensions;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public BlockStateProvider getTopBlockProvider() {
        return this.topBlockProvider;
    }

    public int getMinHeight() {
        return Math.abs(this.minHeight);
    }

    public int getMaxHeight() {
        return Math.abs(this.maxHeight);
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue + 1;
    }

    public int getMinXRadius() {
        return Math.abs(this.minXRadius);
    }

    public int getMaxXRadius() {
        return Math.abs(this.maxXRadius);
    }

    public int getMinYRadius() {
        return this.minYRadius;
    }

    public int getMaxYRadius() {
        return this.maxYRadius;
    }

    public int getMinZRadius() {
        return this.minZRadius;
    }

    public int getMaxZRadius() {
        return this.maxZRadius;
    }

    public int getMaxPossibleXRadius() {
        int returnValue = this.maxXRadius - this.minXRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public int getMaxPossibleYRadius() {
        int returnValue = this.maxYRadius - this.minYRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public int getMaxPossibleZRadius() {
        int returnValue = this.maxZRadius - this.minZRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public int getRandomXRadius(Random rand) {
        return rand.nextInt(this.maxXRadius) + this.minXRadius;
    }

    public int getRandomYRadius(Random rand) {
        return rand.nextInt(this.maxYRadius) + this.minYRadius;
    }

    public int getRandomZRadius(Random rand) {
        return rand.nextInt(this.maxZRadius) + this.minZRadius;
    }

    public double getRadiusDivisorPerStack() {
        return this.radiusDivisorPerStack;
    }

    public double getNoiseFrequency() {
        return this.noiseFrequency;
    }

    public Set<ResourceLocation> getWhitelistedDimensions() {
        return this.whitelistedDimensions;
    }

    public static class Builder {
        private BlockStateProvider blockProvider = new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
        private BlockStateProvider topBlockProvider = new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
        private int minStackHeight = 1;
        private int maxStackHeight = 1;
        private int minXRadius = 1;
        private int maxXRadius = 3;
        private int minYRadius = this.minXRadius;
        private int maxYRadius = this.maxXRadius;
        private int minZRadius = this.minXRadius;
        private int maxZRadius = this.maxXRadius;
        private double radiusDivisorPerStack = 1.0;
        private double noiseFrequency = 0.045;
        private Set<ResourceLocation> whitelistedDimensions = ImmutableSet.of((Object)new ResourceLocation("minecraft:overworld"));

        public Builder setBlock(Block block) {
            this.blockProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBlock(BlockStateProvider provider) {
            this.blockProvider = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setTopBlock(Block block) {
            this.topBlockProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setTopBlock(BlockState state) {
            this.topBlockProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setTopBlock(BlockStateProvider provider) {
            this.topBlockProvider = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setMinStackHeight(int minStackHeight) {
            this.minStackHeight = minStackHeight <= 0 ? 1 : minStackHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxStackHeight = maxPossibleHeight <= 0 ? this.minStackHeight + 1 : maxPossibleHeight;
            return this;
        }

        public Builder setMinXRadius(int minXRadius) {
            this.minXRadius = minXRadius <= 0 ? 1 : minXRadius;
            return this;
        }

        public Builder setMinRadius(int minRadius) {
            if (minRadius <= 0) {
                this.minXRadius = 1;
                this.minYRadius = 1;
                this.minZRadius = 1;
            } else {
                this.minXRadius = minRadius;
                this.minYRadius = minRadius;
                this.minZRadius = minRadius;
            }
            return this;
        }

        public Builder setMaxRadius(int maxRadius) {
            if (maxRadius <= 0) {
                this.maxXRadius = 1;
                this.maxYRadius = 1;
                this.maxZRadius = 1;
            } else {
                this.maxXRadius = maxRadius;
                this.maxYRadius = maxRadius;
                this.maxZRadius = maxRadius;
            }
            return this;
        }

        public Builder setMaxXRadius(int maxXRadius) {
            this.maxXRadius = maxXRadius <= 0 ? this.minXRadius + 1 : maxXRadius;
            return this;
        }

        public Builder setMinYRadius(int minYRadius) {
            this.minYRadius = minYRadius;
            return this;
        }

        public Builder setMaxYRadius(int maxYRadius) {
            this.maxYRadius = maxYRadius;
            return this;
        }

        public Builder setMinZRadius(int minZRadius) {
            this.minZRadius = minZRadius;
            return this;
        }

        public Builder setMaxZRadius(int maxZRadius) {
            this.maxZRadius = maxZRadius;
            return this;
        }

        public Builder setRadiusDivisor(double radiusDivisorPerStack) {
            this.radiusDivisorPerStack = radiusDivisorPerStack;
            return this;
        }

        public Builder setNoiseFrequency(double noiseFrequency) {
            this.noiseFrequency = noiseFrequency;
            return this;
        }

        public Set<ResourceLocation> getWhitelistedDimensions() {
            return this.whitelistedDimensions;
        }

        public Builder setWhitelistedDimensions(String whitelistedDimensions) {
            this.whitelistedDimensions = Arrays.stream(whitelistedDimensions.trim().replace(" ", "").split(",")).map(ResourceLocation::new).collect(Collectors.toSet());
            return this;
        }

        public Builder setWhitelistedDimensions(Set<String> whitelistedDimensions) {
            this.whitelistedDimensions = whitelistedDimensions.stream().map(ResourceLocation::new).collect(Collectors.toSet());
            return this;
        }

        public Builder setWhitelistedDimensions(DimensionType ... whitelistedDimensions) {
            this.whitelistedDimensions = Arrays.stream(whitelistedDimensions).map(arg_0 -> ((Registry)Registry.field_212622_k).func_177774_c(arg_0)).collect(Collectors.toSet());
            return this;
        }

        public Builder copy(NoisySphereConfig config) {
            this.blockProvider = config.blockProvider;
            this.topBlockProvider = config.topBlockProvider;
            this.minStackHeight = config.minHeight;
            this.maxStackHeight = config.maxHeight;
            this.minXRadius = config.minXRadius;
            this.maxXRadius = config.maxXRadius;
            this.minYRadius = config.minYRadius;
            this.maxYRadius = config.maxYRadius;
            this.minZRadius = config.minZRadius;
            this.maxZRadius = config.maxZRadius;
            this.radiusDivisorPerStack = config.radiusDivisorPerStack;
            this.noiseFrequency = config.noiseFrequency;
            return this;
        }

        public NoisySphereConfig build() {
            return new NoisySphereConfig(this.blockProvider, this.topBlockProvider, this.minStackHeight, this.maxStackHeight, this.minXRadius / 2, this.maxXRadius / 2, this.minYRadius / 2, this.maxYRadius / 2, this.minZRadius / 2, this.maxZRadius / 2, this.radiusDivisorPerStack, this.noiseFrequency, this.whitelistedDimensions);
        }
    }
}

