/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class PHFTreeConfig
implements IFeatureConfig {
    private final BlockStateProvider trunkProvider;
    private final BlockStateProvider leavesProvider;
    private final BlockStateProvider groundReplacementProvider;
    private final BlockStateProvider diskProvider;
    private final int minHeight;
    private final int maxHeight;
    private final int diskRadius;
    private final Set<Block> whitelist;
    private boolean forcedPlacement = false;

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("trunk_provider"), this.trunkProvider.func_218175_a(ops)).put(ops.createString("leaves_provider"), this.leavesProvider.func_218175_a(ops)).put(ops.createString("ground_replacement_provider"), this.groundReplacementProvider.func_218175_a(ops)).put(ops.createString("disk_provider"), this.diskProvider.func_218175_a(ops)).put(ops.createString("min_height"), ops.createInt(this.minHeight)).put(ops.createString("max_height"), ops.createInt(this.maxHeight)).put(ops.createString("disk_radius"), ops.createInt(this.diskRadius)).put(ops.createString("whitelist"), ops.createList(this.whitelist.stream().map(block -> BlockState.func_215689_a((DynamicOps)ops, (BlockState)block.func_176223_P()).getValue())));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> PHFTreeConfig deserialize(Dynamic<T> ops) {
        BlockStateProvider trunkProvider = ((BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("trunk_provider").get("type").asString().orElseThrow(RuntimeException::new)))).func_227399_a_(ops.get("trunk_provider").orElseEmptyMap());
        BlockStateProvider leavesProvider = ((BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("leaves_provider").get("type").asString().orElseThrow(RuntimeException::new)))).func_227399_a_(ops.get("leaves_provider").orElseEmptyMap());
        BlockStateProvider groundReplacementProvider = ((BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("ground_replacement_provider").get("type").asString().orElseThrow(RuntimeException::new)))).func_227399_a_(ops.get("ground_replacement_provider").orElseEmptyMap());
        BlockStateProvider diskProvider = ((BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)ops.get("disk_provider").get("type").asString().orElseThrow(RuntimeException::new)))).func_227399_a_(ops.get("disk_provider").orElseEmptyMap());
        int minHeight = ops.get("min_height").asInt(0);
        int maxHeight = ops.get("max_height").asInt(0);
        int diskRadius = ops.get("disk_radius").asInt(0);
        ArrayList<BlockState> whitelist = new ArrayList<BlockState>(ops.get("whitelist").asList(BlockState::func_215698_a));
        return new PHFTreeConfig(trunkProvider, leavesProvider, groundReplacementProvider, diskProvider, minHeight, maxHeight, diskRadius, whitelist);
    }

    PHFTreeConfig(BlockStateProvider trunkProvider, BlockStateProvider leavesProvider, BlockStateProvider groundReplacementProvider, BlockStateProvider diskProvider, int minHeight, int maxHeight, int diskRadius, List<BlockState> whitelist) {
        this.trunkProvider = trunkProvider;
        this.leavesProvider = leavesProvider;
        this.groundReplacementProvider = groundReplacementProvider;
        this.diskProvider = diskProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.diskRadius = diskRadius;
        this.whitelist = whitelist.stream().map(BlockState::func_177230_c).collect(Collectors.toSet());
    }

    public void forcePlacement() {
        this.forcedPlacement = true;
    }

    public BlockStateProvider getTrunkProvider() {
        return this.trunkProvider;
    }

    public BlockStateProvider getLeavesProvider() {
        return this.leavesProvider;
    }

    public BlockStateProvider getGroundReplacementProvider() {
        return this.groundReplacementProvider;
    }

    public BlockStateProvider getDiskProvider() {
        return this.diskProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getDiskRadius() {
        return this.diskRadius;
    }

    public Set<Block> getWhitelist() {
        return this.whitelist;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public boolean isPlacementForced() {
        return this.forcedPlacement;
    }

    public static class Builder {
        private BlockStateProvider trunkProvider = new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
        private BlockStateProvider leavesProvider = new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
        private BlockStateProvider groundReplacementProvider = new SimpleBlockStateProvider(Blocks.field_150346_d.func_176223_P());
        private BlockStateProvider diskProvider = new SimpleBlockStateProvider(Blocks.field_196661_l.func_176223_P());
        private List<Block> whitelist = ImmutableList.of((Object)Blocks.field_196658_i);
        private int minHeight = 15;
        private int maxPossibleHeight = 1;
        private int diskRadius = 0;

        public Builder setTrunkBlock(Block block) {
            this.trunkProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
            return this;
        }

        public Builder setTrunkBlock(BlockState state) {
            this.trunkProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
            return this;
        }

        public Builder setLeavesBlock(Block block) {
            this.leavesProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setLeavesBlock(BlockState state) {
            this.leavesProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setLeavesBlock(BlockStateProvider stateProvider) {
            this.leavesProvider = stateProvider != null ? stateProvider : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setGroundReplacementBlock(Block block) {
            this.groundReplacementProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150346_d.func_176223_P());
            return this;
        }

        public Builder setGroundReplacementBlock(BlockState state) {
            this.groundReplacementProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P());
            return this;
        }

        public Builder setGroundReplacementBlock(BlockStateProvider stateProvider) {
            this.groundReplacementProvider = stateProvider != null ? stateProvider : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setDiskBlock(Block block) {
            this.diskProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P());
            return this;
        }

        public Builder setDiskBlock(BlockState state) {
            this.diskProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P());
            return this;
        }

        public Builder setDiskBlock(BlockStateProvider stateProvider) {
            this.diskProvider = stateProvider != null ? stateProvider : new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHeight = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setDiskRadius(int diskRadius) {
            this.diskRadius = Math.abs(diskRadius);
            return this;
        }

        public Builder setWhitelist(ImmutableList<Block> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(PHFTreeConfig config) {
            this.trunkProvider = config.trunkProvider;
            this.leavesProvider = config.leavesProvider;
            this.groundReplacementProvider = config.groundReplacementProvider;
            this.diskProvider = config.diskProvider;
            this.maxPossibleHeight = config.maxHeight;
            this.minHeight = config.minHeight;
            this.diskRadius = config.diskRadius;
            this.whitelist = ImmutableList.copyOf((Collection)config.whitelist);
            return this;
        }

        public PHFTreeConfig build() {
            return new PHFTreeConfig(this.trunkProvider, this.leavesProvider, this.groundReplacementProvider, this.diskProvider, this.minHeight, this.maxPossibleHeight, this.diskRadius, this.whitelist.stream().map(Block::func_176223_P).collect(Collectors.toList()));
        }
    }
}

