/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.feature.util;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraftforge.common.Tags;

public class FeatureUtil {
    public static boolean isPlant(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_203425_a(BlockTags.field_206952_E) || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_203243_f);
    }

    public static boolean isTerrainOrRock(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_203425_a(Tags.Blocks.STONE) || state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151578_c || state.func_203425_a(BlockTags.field_203436_u) || state.func_203425_a(Tags.Blocks.SAND) || state.func_203425_a(Tags.Blocks.SAND_COLORLESS) || state.func_203425_a(Tags.Blocks.SAND_RED) || state.func_203425_a(Tags.Blocks.SANDSTONE) || state.func_185904_a() == Material.field_151595_p || state.func_177230_c() == Blocks.field_196658_i);
    }

    public static boolean isAir(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, BlockState::func_196958_f);
    }

    public static boolean isAirInRange(IWorldGenerationBaseReader world, BlockPos pos, int xRange, int yRange, int zRange) {
        return FeatureUtil.isAirInRange(world, pos, xRange, yRange, zRange, xRange, yRange, zRange);
    }

    public static boolean isAirInRange(IWorldGenerationBaseReader world, BlockPos pos, int xNegRange, int yNegRange, int zNegRange, int xPosRange, int yPosRange, int zPosRange) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = -xNegRange; x <= xPosRange; ++x) {
            for (int y = -yNegRange; y <= yPosRange; ++y) {
                for (int z = -zNegRange; z <= zPosRange; ++z) {
                    mutable.func_189533_g((Vec3i)pos.func_177982_a(x, y, z));
                    if (FeatureUtil.isAir(world, (BlockPos)mutable)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void transformMutable(BlockPos.Mutable pos, Mirror mirrorIn, Rotation rotationIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                pos.func_223472_q(-pos.func_177952_p());
                break;
            }
            case FRONT_BACK: {
                pos.func_223471_o(-pos.func_177958_n());
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                pos.func_181079_c(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
                break;
            }
            case CLOCKWISE_90: {
                pos.func_181079_c(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
                break;
            }
            case CLOCKWISE_180: {
                pos.func_181079_c(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
        }
    }

    public static BlockPos transform(BlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        int posX = pos.func_177958_n();
        int posZ = pos.func_177952_p();
        boolean mirror = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                posZ = -posZ;
                break;
            }
            case FRONT_BACK: {
                posX = -posX;
                break;
            }
            default: {
                mirror = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(posZ, pos.func_177956_o(), -posX);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-posZ, pos.func_177956_o(), posX);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-posX, pos.func_177956_o(), -posZ);
            }
        }
        return mirror ? new BlockPos(posX, pos.func_177956_o(), posZ) : pos;
    }
}

