/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.feature.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.Tags;
import superlord.prehistoricfauna.util.fastnoise.FastNoise;
import superlord.prehistoricfauna.world.feature.config.PHFTreeConfig;
import superlord.prehistoricfauna.world.feature.util.FeatureUtil;

public abstract class PHFAbstractTreeFeature<TFC extends PHFTreeConfig>
extends Feature<TFC> {
    protected static FastNoise fastNoise;
    protected long seed;
    public static final Map<Block, Block> SPREADABLE_TO_NON_SPREADABLE;

    public PHFAbstractTreeFeature(Function<Dynamic<?>, ? extends TFC> configCodec) {
        super(configCodec);
    }

    public static boolean canLogPlaceHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_185904_a() == Material.field_151579_a || state.func_185904_a() == Material.field_151586_h) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean isAnotherTreeHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_206952_E);
        });
    }

    public boolean isAnotherTreeLikeThisHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos, Block logBlock, Block leafBlock) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block == logBlock || block == leafBlock;
        });
    }

    public void placeTrunk(PHFTreeConfig config, Random random, Set<BlockPos> blockSet, IWorld reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PHFAbstractTreeFeature.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockSet, (IWorldWriter)reader, pos, config.getTrunkProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public void placeBranch(PHFTreeConfig config, Random random, Set<BlockPos> blockSet, IWorld reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PHFAbstractTreeFeature.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockSet, (IWorldWriter)reader, pos, config.getTrunkProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public void placeLeaves(PHFTreeConfig config, Random random, Set<BlockPos> blockSet, IWorld reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PHFAbstractTreeFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockSet, (IWorldWriter)reader, pos, config.getLeavesProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public boolean canSaplingGrowHere(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_206952_E) || state.func_196958_f() || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_203243_f || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151578_c;
        });
    }

    public static boolean isAir(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, BlockState::func_196958_f);
    }

    public boolean isAirOrWater(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_177230_c() == Blocks.field_150355_j);
    }

    public static boolean isDesiredGroundwDirtTag(IWorldGenerationBaseReader reader, BlockPos pos, PHFTreeConfig config) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            Iterator<Block> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                Block block1 = iterator.next();
                return block.func_203417_a(Tags.Blocks.DIRT) || block == block1;
            }
            return block.func_203417_a(Tags.Blocks.DIRT);
        });
    }

    public static boolean isDesiredGroundwSandTag(IWorldGenerationBaseReader reader, BlockPos pos, PHFTreeConfig config) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            Iterator<Block> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                Block block1 = iterator.next();
                return block.func_203417_a(Tags.Blocks.SAND) || block == block1;
            }
            return block.func_203417_a(Tags.Blocks.SAND);
        });
    }

    public boolean isDesiredGround(IWorldGenerationBaseReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return block == block1;
            }
            return false;
        });
    }

    public boolean doesSaplingHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean doesSaplingHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xNegativeDistance, int zNegativeDistance, int xPositiveDistance, int zPositiveDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xNegativeDistance; xOffset <= xPositiveDistance; ++xOffset) {
                    for (int zOffset = -zNegativeDistance; zOffset <= zPositiveDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, boolean isSapling) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherTreeHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeLikeThisNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, Block logBlock, Block leafBlock, boolean isSapling) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherTreeLikeThisHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset), logBlock, leafBlock)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isCliff(IWorldGenerationBaseReader reader, BlockPos ... trunkPositions) {
        return this.isCliff(reader, 5, trunkPositions);
    }

    public boolean isCliff(IWorldGenerationBaseReader reader, int checkDownRange, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutable.func_189533_g((Vec3i)trunkPos);
                for (int moveDown = 0; moveDown <= checkDownRange && (this.isAirOrWater(reader, (BlockPos)mutable) || FeatureUtil.isPlant(reader, (BlockPos)mutable)); ++moveDown) {
                    if (moveDown == checkDownRange) {
                        return true;
                    }
                    mutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return false;
    }

    public void buildTrunkBase(BlockPos centerPos, Set<BlockPos> treeBlocksSet, IWorld reader, PHFTreeConfig config, Random rand, MutableBoundingBox boundingBox, BlockPos ... trunkPositions) {
        if (config.isPlacementForced()) {
            return;
        }
        BlockState ground = reader.func_180495_p(centerPos.func_177972_a(Direction.DOWN));
        if (SPREADABLE_TO_NON_SPREADABLE.containsKey(ground.func_177230_c())) {
            ground = SPREADABLE_TO_NON_SPREADABLE.get(ground.func_177230_c()).func_176223_P();
        }
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vec3i)trunkPos);
                for (int fill = 1; fill <= 25; ++fill) {
                    if (PHFAbstractTreeFeature.canLogPlaceHere((IWorldGenerationBaseReader)reader, (BlockPos)mutableTrunk)) {
                        if (fill <= 15) {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, config.getTrunkProvider().func_225574_a_(rand, (BlockPos)mutableTrunk), boundingBox);
                        } else {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, ground, boundingBox);
                        }
                    } else {
                        if (!this.isDesiredGround((IWorldGenerationBaseReader)reader, (BlockPos)mutableTrunk, config.getTrunkProvider().func_225574_a_(rand, (BlockPos)mutableTrunk).func_177230_c())) {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, ground, boundingBox);
                        }
                        fill = 25;
                    }
                    mutableTrunk.func_189536_c(Direction.DOWN);
                }
            }
        }
    }

    public void setSoil(Set<BlockPos> treeBlocksSet, IWorldGenerationBaseReader reader, PHFTreeConfig config, Random rand, MutableBoundingBox boundingBox, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vec3i)trunkPos);
                if (this.isDesiredGround(reader, (BlockPos)mutableTrunk, config.getTrunkProvider().func_225574_a_(rand, (BlockPos)mutableTrunk).func_177230_c())) continue;
                this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk.func_189536_c(Direction.DOWN), config.getTrunkProvider().func_225574_a_(rand, (BlockPos)mutableTrunk), boundingBox);
            }
        }
    }

    public void setDisk(IWorld world, Random random, BlockPos pos, PHFTreeConfig config) {
        if (config.isPlacementForced() || config.getDiskRadius() <= 0) {
            return;
        }
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vec3i)pos);
        int diskRadius = config.getDiskRadius();
        for (int x = -diskRadius; x <= diskRadius; ++x) {
            for (int z = -diskRadius; z <= diskRadius; ++z) {
                int squaredDistance = x * x + z * z;
                if (squaredDistance > diskRadius * diskRadius) continue;
                mutable.func_189533_g((Vec3i)pos).func_196234_d(x, 0, z);
                double diskRoughnessNoise = fastNoise.GetNoise((float)mutable.func_177958_n() * 0.04f, (float)mutable.func_177956_o() * 0.01f, (float)mutable.func_177952_p() * 0.04f);
                if ((float)squaredDistance > (float)(diskRadius * diskRadius) * 0.8f && diskRoughnessNoise > -0.3 && diskRoughnessNoise < 0.3 || !FeatureUtil.isTerrainOrRock((IWorldGenerationBaseReader)world, (BlockPos)mutable) || !world.func_180495_p(mutable.func_177984_a()).func_196958_f() && !FeatureUtil.isPlant((IWorldGenerationBaseReader)world, mutable.func_177984_a())) continue;
                world.func_180501_a((BlockPos)mutable, config.getDiskProvider().func_225574_a_(random, (BlockPos)mutable), 2);
            }
        }
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    public final void setFinalBlockState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState blockState, MutableBoundingBox boundingBox) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
        boundingBox.func_78888_b(new MutableBoundingBox((Vec3i)pos, (Vec3i)pos));
        if (BlockTags.field_200031_h.func_199685_a_((Object)blockState.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    public void setBlockStateWithoutUpdates(IWorldWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        worldWriter.func_180501_a(blockPos, blockState, 18);
    }

    protected void func_202278_a(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, TFC config) {
        return this.placeTree(worldIn, rand, pos, config);
    }

    public boolean placeTree(IWorld worldIn, Random rand, BlockPos pos, TFC config) {
        HashSet set = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.generate(set, worldIn, rand, pos, mutableboundingbox, ((PHFTreeConfig)config).isPlacementForced(), config);
        if (mutableboundingbox.field_78897_a > mutableboundingbox.field_78893_d) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(mutableboundingbox.func_78883_b(), mutableboundingbox.func_78882_c(), mutableboundingbox.func_78880_d());
        try (BlockPos.PooledMutable blockPosPool = BlockPos.PooledMutable.func_185346_s();){
            if (flag && !set.isEmpty()) {
                for (BlockPos blockpos : Lists.newArrayList((Iterable)set)) {
                    if (mutableboundingbox.func_175898_b((Vec3i)blockpos)) {
                        voxelshapepart.func_199625_a(blockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction : Direction.values()) {
                        BlockState blockstate;
                        blockPosPool.func_189533_g((Vec3i)blockpos).func_189536_c(direction);
                        if (set.contains(blockPosPool) || !(blockstate = worldIn.func_180495_p((BlockPos)blockPosPool)).func_196959_b((IProperty)BlockStateProperties.field_208514_aa)) continue;
                        ((Set)list.get(0)).add(blockPosPool.func_185334_h());
                        this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)blockPosPool, (BlockState)blockstate.func_206870_a((IProperty)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                        if (!mutableboundingbox.func_175898_b((Vec3i)blockPosPool)) continue;
                        voxelshapepart.func_199625_a(blockPosPool.func_177958_n() - mutableboundingbox.field_78897_a, blockPosPool.func_177956_o() - mutableboundingbox.field_78895_b, blockPosPool.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                }
            }
            for (int l = 1; l < 6; ++l) {
                Set set1 = (Set)list.get(l - 1);
                Set set2 = (Set)list.get(l);
                for (BlockPos blockpos1 : set1) {
                    if (mutableboundingbox.func_175898_b((Vec3i)blockpos1)) {
                        voxelshapepart.func_199625_a(blockpos1.func_177958_n() - mutableboundingbox.field_78897_a, blockpos1.func_177956_o() - mutableboundingbox.field_78895_b, blockpos1.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction1 : Direction.values()) {
                        int k;
                        BlockState blockstate1;
                        blockPosPool.func_189533_g((Vec3i)blockpos1).func_189536_c(direction1);
                        if (set1.contains(blockPosPool) || set2.contains(blockPosPool) || !(blockstate1 = worldIn.func_180495_p((BlockPos)blockPosPool)).func_196959_b((IProperty)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((IProperty)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                        BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((IProperty)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                        this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)blockPosPool, blockstate2);
                        if (mutableboundingbox.func_175898_b((Vec3i)blockPosPool)) {
                            voxelshapepart.func_199625_a(blockPosPool.func_177958_n() - mutableboundingbox.field_78897_a, blockPosPool.func_177956_o() - mutableboundingbox.field_78895_b, blockPosPool.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                        }
                        set2.add(blockPosPool.func_185334_h());
                    }
                }
            }
        }
        Template.func_222857_a((IWorld)worldIn, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
        this.setDisk(worldIn, rand, pos.func_177977_b(), (PHFTreeConfig)config);
        return flag;
    }

    protected abstract boolean generate(Set<BlockPos> var1, IWorld var2, Random var3, BlockPos var4, MutableBoundingBox var5, boolean var6, TFC var7);

    static {
        SPREADABLE_TO_NON_SPREADABLE = (Map)Util.func_200696_a(new HashMap(), map -> {
            map.put(Blocks.field_196658_i, Blocks.field_150346_d);
            map.put(Blocks.field_150391_bh, Blocks.field_150346_d);
            map.put(Blocks.field_185774_da, Blocks.field_150346_d);
            map.put(Blocks.field_196661_l, Blocks.field_150346_d);
        });
    }
}

