/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.world.placement;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import superlord.prehistoricfauna.init.PrehistoricProfessionInit;
import superlord.prehistoricfauna.world.PrehistoricFeature;
import superlord.prehistoricfauna.world.PrehistoricLootTables;

public class GeologistCampPieces {
    private static final ResourceLocation PART_1 = new ResourceLocation("prehistoricfauna", "geologist_camp");
    private static final PlacementSettings OVERWRITE = new PlacementSettings().func_186222_a(true).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
    private static final PlacementSettings INSERT = new PlacementSettings().func_186222_a(true).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)PART_1, (Object)new BlockPos(0, 1, 0));

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, PART_1, blockpos, rotation, true));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private boolean villager;
        private ResourceLocation resourceLocation;
        private Rotation rotation;
        private final boolean overwrite;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn, boolean overwrite) {
            super(PrehistoricFeature.GEOLOGIST_CAMP_PIECE, 0);
            this.resourceLocation = resourceLocationIn;
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.overwrite = overwrite;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(PrehistoricFeature.GEOLOGIST_CAMP_PIECE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.overwrite = tagCompound.func_74767_n("OW");
            this.villager = tagCompound.func_74767_n("Villager");
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = (this.overwrite ? OVERWRITE : INSERT).func_186217_a().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("Villager", this.villager);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74757_a("OW", this.overwrite);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            BlockPos blockpos;
            if (function.startsWith("chest") && sbb.func_175898_b((Vec3i)(blockpos = pos.func_177977_b()))) {
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)blockpos, (ResourceLocation)PrehistoricLootTables.GEOLOGIST_CAMP_LOOT_TABLE);
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 0);
        }

        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> chunkGeneratorIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            int k;
            int i1;
            int l;
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            BlockPos blockpos = (BlockPos)OFFSET.get(this.resourceLocation);
            this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(0 - blockpos.func_177958_n(), 0, 0 - blockpos.func_177952_p())));
            if (!this.villager && structureBoundingBoxIn.func_175898_b((Vec3i)new BlockPos(l = this.func_74865_a(2, 5), i1 = this.func_74862_a(1), k = this.func_74873_b(2, 5)))) {
                this.villager = true;
                VillagerEntity villagerEntity = (VillagerEntity)EntityType.field_200756_av.func_200721_a(worldIn.func_201672_e());
                VillagerData villagerData = new VillagerData(IVillagerType.field_221175_c, PrehistoricProfessionInit.GEOLOGIST, 0);
                villagerEntity.func_110163_bv();
                villagerEntity.func_70012_b((double)l + 0.5, (double)i1, (double)k + 0.5, 0.0f, 0.0f);
                villagerEntity.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos(l, i1, k)), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
                worldIn.func_217376_c((Entity)villagerEntity);
                villagerEntity.func_213753_a(villagerData);
            }
            return super.func_225577_a_(worldIn, chunkGeneratorIn, randomIn, structureBoundingBoxIn, chunkPos);
        }
    }
}

