/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo;

import com.mojang.brigadier.CommandDispatcher;
import harmonised.pmmo.commands.PmmoCommand;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.events.EventHandler;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.ftb_quests.FTBQHandler;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.network.WebHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pmmo")
public class ProjectMMOMod {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static boolean serverStarted = false;
    public static boolean jeiLoaded = false;
    public static boolean tinkersLoaded = false;
    public static boolean dynamicTreesLoaded = false;
    public static SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("pmmo", "main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();

    public ProjectMMOMod() {
        WebHandler.updateInfo();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modsLoading);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientLoading);
        if (ModList.get().isLoaded("ftbquests")) {
            FTBQHandler.init();
        }
        jeiLoaded = ModList.get().isLoaded("jei");
        tinkersLoaded = ModList.get().isLoaded("tconstruct");
        dynamicTreesLoaded = ModList.get().isLoaded("dynamictrees");
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        Config.init();
    }

    private void modsLoading(FMLCommonSetupEvent event) {
        XP.initValues();
        NetworkHandler.registerPackets();
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        MinecraftForge.EVENT_BUS.register(AttributeHandler.class);
    }

    private void clientLoading(FMLClientSetupEvent event) {
        ClientHandler.init();
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        serverStarted = false;
        JsonConfig.init();
        ChunkDataHandler.init();
        Config.initServer();
        WorldTickHandler.refreshVein();
    }

    private void serverStarted(FMLServerStartedEvent event) {
        if (Config.forgeConfig.autoGenerateValuesEnabled.get().booleanValue()) {
            AutoValues.setAutoValues();
        }
        serverStarted = true;
    }

    private void registerCommands(RegisterCommandsEvent event) {
        PmmoCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void serverStart(FMLServerStartingEvent event) {
        PmmoSavedData.init(event.getServer());
        if (Config.forgeConfig.craftReqEnabled.get().booleanValue()) {
            ((GameRules.BooleanValue)event.getServer().func_200252_aR().func_223585_a(GameRules.field_223618_u)).func_223570_a(true, event.getServer());
        }
    }

    public static String getCurrentVersion() {
        if (Util.isProduction()) {
            String currentVersion = ProjectMMOMod.class.getPackage().getImplementationVersion();
            int dashIndex = currentVersion.indexOf(45);
            if (dashIndex != -1) {
                currentVersion = currentVersion.substring(dashIndex + 1);
            }
            return currentVersion;
        }
        return "3.55";
    }

    public static boolean isVersionBehind() {
        String latestVersionString = WebHandler.getLatestVersion();
        if (latestVersionString == null) {
            return false;
        }
        String currentVersionString = ProjectMMOMod.getCurrentVersion();
        String[] latestPmmoVersion = latestVersionString.split("[.]");
        String[] currentPmmoVersion = currentVersionString.split("[.]");
        LOGGER.info("Project MMO version: \"" + currentVersionString + "\" Latest: \"" + latestVersionString + "\"");
        for (int i = 0; i < latestPmmoVersion.length; ++i) {
            if (currentPmmoVersion.length <= i) {
                return true;
            }
            try {
                int latestNumber = Integer.parseInt(latestPmmoVersion[i]);
                int givenNumber = Integer.parseInt(currentPmmoVersion[i]);
                if (givenNumber > latestNumber) {
                    return false;
                }
                if (givenNumber >= latestNumber) continue;
                return true;
            }
            catch (Exception e) {
                System.out.println("Error parsing latest/given version number");
                return false;
            }
        }
        return false;
    }
}

