/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api;

import com.google.common.base.Preconditions;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class APIUtils {
    public static void awardXpTrigger(UUID playerID, String triggerKey, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        Preconditions.checkNotNull((Object)playerID);
        Preconditions.checkNotNull((Object)triggerKey);
        Preconditions.checkNotNull((Object)skip);
        Preconditions.checkNotNull((Object)ignoreBonuses);
        XP.awardXpTrigger(playerID, triggerKey, sourceName, skip, ignoreBonuses);
    }

    public static int getLevel(String skill, PlayerEntity player) {
        Preconditions.checkNotNull((Object)skill);
        Preconditions.checkNotNull((Object)player);
        return Skill.getLevel(skill, player);
    }

    public static double getXp(String skill, PlayerEntity player) {
        Preconditions.checkNotNull((Object)skill);
        Preconditions.checkNotNull((Object)player);
        return Skill.getXp(skill, player);
    }

    public static void setLevel(String skill, ServerPlayerEntity player, double amount) {
        Preconditions.checkNotNull((Object)skill);
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)amount);
        Skill.setLevel(skill, player, amount);
    }

    public static void setXp(String skill, ServerPlayerEntity player, double amount) {
        Preconditions.checkNotNull((Object)skill);
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)amount);
        Skill.setXp(skill, player, amount);
    }

    public static void addLevel(String skill, UUID playerID, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        Preconditions.checkNotNull((Object)playerID);
        Preconditions.checkNotNull((Object)skill);
        Preconditions.checkNotNull((Object)amount);
        Preconditions.checkNotNull((Object)skip);
        Preconditions.checkNotNull((Object)ignoreBonuses);
        Skill.addLevel(skill, playerID, amount, sourceName, skip, ignoreBonuses);
    }

    public static void addXp(String skill, UUID playerID, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        Preconditions.checkNotNull((Object)playerID);
        Preconditions.checkNotNull((Object)skill);
        Preconditions.checkNotNull((Object)amount);
        Preconditions.checkNotNull((Object)skip);
        Preconditions.checkNotNull((Object)ignoreBonuses);
        Skill.addXp(skill, playerID, amount, sourceName, skip, ignoreBonuses);
    }

    public static Map<String, Double> getXp(TileEntity tile, JType jType) {
        Preconditions.checkNotNull((Object)tile);
        Preconditions.checkNotNull((Object)((Object)jType));
        return XP.getXp(tile, jType);
    }

    public static Map<String, Double> getXp(ItemStack stack, JType jType) {
        Preconditions.checkNotNull((Object)stack);
        Preconditions.checkNotNull((Object)((Object)jType));
        return XP.getXp(stack, jType);
    }

    public static Map<String, Double> getXp(Entity entity, JType jType) {
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)((Object)jType));
        return XP.getXp(entity, jType);
    }

    public static Map<String, Double> getXp(ResourceLocation registryName, JType jType) {
        Preconditions.checkNotNull((Object)registryName);
        Preconditions.checkNotNull((Object)((Object)jType));
        return XP.getXpBypass(registryName, jType);
    }

    public static Map<String, Map<String, Double>> getXpBoostsMap(PlayerEntity player) {
        if (player.field_70170_p.func_201670_d()) {
            return Config.xpBoosts;
        }
        return PmmoSavedData.get().getPlayerXpBoostsMap(player.func_110124_au());
    }

    public static Map<String, Double> getXpBoostMap(PlayerEntity player, String xpBoostKey) {
        if (player.field_70170_p.func_201670_d()) {
            return Config.xpBoosts.getOrDefault(xpBoostKey, new HashMap());
        }
        return PmmoSavedData.get().getPlayerXpBoostMap(player.func_110124_au(), xpBoostKey);
    }

    public static double getPlayerXpBoost(PlayerEntity player, String skill) {
        double xpBoost = 0.0;
        for (Map.Entry<String, Map<String, Double>> entry : APIUtils.getXpBoostsMap(player).entrySet()) {
            xpBoost += entry.getValue().getOrDefault(skill, 0.0).doubleValue();
        }
        return xpBoost;
    }

    public static void setPlayerXpBoost(ServerPlayerEntity player, String xpBoostKey, Map<String, Double> newXpBoosts) {
        PmmoSavedData.get().setPlayerXpBoost(player.func_110124_au(), xpBoostKey, newXpBoosts);
    }

    public static void removePlayerXpBoost(ServerPlayerEntity player, String xpBoostKey) {
        PmmoSavedData.get().removePlayerXpBoost(player.func_110124_au(), xpBoostKey);
    }

    public static void removeAllPlayerXpBoosts(ServerPlayerEntity player) {
        PmmoSavedData.get().removeAllPlayerXpBoosts(player.func_110124_au());
    }

    @Deprecated
    public static void setPlayerXpBoostsMaps(PlayerEntity player, Map<String, Map<String, Double>> newBoosts) {
        if (player.field_70170_p.func_201670_d()) {
            Config.xpBoosts = newBoosts;
        } else {
            PmmoSavedData.get().setPlayerXpBoostsMaps(player.func_110124_au(), newBoosts);
        }
    }
}

