/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class PredicateRegistry {
    private static Map<String, Predicate<PlayerEntity>> reqPredicates = new HashMap<String, Predicate<PlayerEntity>>();
    private static Map<String, BiPredicate<PlayerEntity, TileEntity>> reqBreakPredicates = new HashMap<String, BiPredicate<PlayerEntity, TileEntity>>();

    public static void registerPredicate(ResourceLocation res, JType jType, Predicate<PlayerEntity> pred) {
        String condition = jType.toString() + ";" + res.toString();
        if (pred == null) {
            return;
        }
        reqPredicates.put(condition, pred);
        XP.LOGGER.info("Predicate Registered: " + condition);
    }

    public static void registerBreakPredicate(ResourceLocation res, JType jType, BiPredicate<PlayerEntity, TileEntity> pred) {
        String condition = jType.toString() + ";" + res.toString();
        if (pred == null) {
            return;
        }
        reqBreakPredicates.put(condition, pred);
        XP.LOGGER.info("Predicate Registered: " + condition);
    }

    public static boolean predicateExists(ResourceLocation res, JType jType) {
        if (jType.equals((Object)JType.REQ_BREAK)) {
            return reqBreakPredicates.containsKey(jType.toString() + ";" + res.toString());
        }
        return reqPredicates.containsKey(jType.toString() + ";" + res.toString());
    }

    public static boolean checkPredicateReq(PlayerEntity player, ResourceLocation res, JType jType) {
        if (!PredicateRegistry.predicateExists(res, jType)) {
            return false;
        }
        return reqPredicates.get(jType.toString() + ";" + res.toString()).test(player);
    }

    public static boolean checkPredicateReq(PlayerEntity player, TileEntity tile, JType jType) {
        ResourceLocation res = tile.func_195044_w().func_177230_c().getRegistryName();
        if (!PredicateRegistry.predicateExists(res, jType)) {
            return false;
        }
        return reqBreakPredicates.get(jType.toString() + ";" + res.toString()).test(player, tile);
    }
}

