/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TooltipSupplier {
    public static final Logger LOGGER = LogManager.getLogger();
    private static Map<JType, Map<ResourceLocation, Function<ItemStack, Map<String, Double>>>> tooltips = new HashMap<JType, Map<ResourceLocation, Function<ItemStack, Map<String, Double>>>>();
    private static Map<JType, Map<ResourceLocation, Function<TileEntity, Map<String, Double>>>> breakTooltips = new HashMap<JType, Map<ResourceLocation, Function<TileEntity, Map<String, Double>>>>();
    private static Map<JType, Map<ResourceLocation, Function<Entity, Map<String, Double>>>> entityTooltips = new HashMap<JType, Map<ResourceLocation, Function<Entity, Map<String, Double>>>>();

    public static void registerTooltipData(ResourceLocation res, JType jType, Function<ItemStack, Map<String, Double>> func) {
        if (func == null) {
            LOGGER.info("Supplied Function Null");
            return;
        }
        if (jType == null) {
            LOGGER.info("Supplied JType Null");
            return;
        }
        if (res == null) {
            LOGGER.info("Supplied ResourceLocation Null");
            return;
        }
        if (!tooltips.containsKey((Object)jType)) {
            LOGGER.info("New tooltip category created for: " + jType.toString() + " " + res.toString());
            tooltips.put(jType, new HashMap());
        }
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return;
        }
        tooltips.get((Object)jType).put(res, func);
    }

    public static void registerBreakTooltipData(ResourceLocation res, JType jType, Function<TileEntity, Map<String, Double>> func) {
        if (func == null) {
            LOGGER.info("Supplied Function Null");
            return;
        }
        if (jType == null) {
            LOGGER.info("Supplied JType Null");
            return;
        }
        if (res == null) {
            LOGGER.info("Supplied ResourceLocation Null");
            return;
        }
        if (!breakTooltips.containsKey((Object)jType)) {
            LOGGER.info("New tooltip category created for: " + jType.toString() + " " + res.toString());
            breakTooltips.put(jType, new HashMap());
        }
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return;
        }
        breakTooltips.get((Object)jType).put(res, func);
    }

    public static void registerEntityTooltipData(ResourceLocation res, JType jType, Function<Entity, Map<String, Double>> func) {
        if (func == null) {
            LOGGER.info("Supplied Function Null");
            return;
        }
        if (jType == null) {
            LOGGER.info("Supplied JType Null");
            return;
        }
        if (res == null) {
            LOGGER.info("Supplied ResourceLocation Null");
            return;
        }
        if (!breakTooltips.containsKey((Object)jType)) {
            LOGGER.info("New tooltip category created for: " + jType.toString() + " " + res.toString());
            entityTooltips.put(jType, new HashMap());
        }
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return;
        }
        entityTooltips.get((Object)jType).put(res, func);
    }

    public static boolean tooltipExists(ResourceLocation res, JType jType) {
        if (jType == null) {
            return false;
        }
        if (res == null) {
            return false;
        }
        if (jType.equals((Object)JType.REQ_BREAK) || jType.equals((Object)JType.XP_VALUE_BREAK)) {
            if (!breakTooltips.containsKey((Object)jType)) {
                return false;
            }
            return breakTooltips.get((Object)jType).containsKey(res);
        }
        if (jType.equals((Object)JType.XP_VALUE_BREED) || jType.equals((Object)JType.XP_VALUE_TAME) || jType.equals((Object)JType.XP_VALUE_KILL)) {
            if (!entityTooltips.containsKey((Object)jType)) {
                return false;
            }
            return entityTooltips.get((Object)jType).containsKey(res);
        }
        if (!tooltips.containsKey((Object)jType)) {
            return false;
        }
        return tooltips.get((Object)jType).containsKey(res);
    }

    public static Map<String, Double> getTooltipData(ResourceLocation res, JType jType, ItemStack stack) {
        if (TooltipSupplier.tooltipExists(res, jType)) {
            HashMap suppliedData = tooltips.get((Object)jType).get(res).apply(stack);
            return suppliedData == null ? new HashMap() : suppliedData;
        }
        return XP.getXpBypass(res, jType);
    }

    public static Map<String, Double> getTooltipData(ResourceLocation res, JType jType, TileEntity tile) {
        if (TooltipSupplier.tooltipExists(res, jType)) {
            HashMap suppliedData = breakTooltips.get((Object)jType).get(res).apply(tile);
            return suppliedData == null ? new HashMap() : suppliedData;
        }
        return XP.getXpBypass(res, jType);
    }

    public static Map<String, Double> getTooltipData(ResourceLocation res, JType jType, Entity entity) {
        if (TooltipSupplier.tooltipExists(res, jType)) {
            HashMap suppliedData = entityTooltips.get((Object)jType).get(res).apply(entity);
            return suppliedData == null ? new HashMap() : suppliedData;
        }
        return XP.getXpBypass(res, jType);
    }
}

