/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api.events;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.util.XP;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class XpEvent
extends PlayerEvent {
    private String skill;
    private double amount;
    private String sourceName;
    private boolean skip;
    private boolean ignoreBonuses;
    private boolean causedByParty;

    public XpEvent(PlayerEntity player, String skill, String sourceName, double amount, boolean skip, boolean ignoreBonuses, boolean causedByParty) {
        super(player);
        this.skill = skill;
        this.amount = amount;
        this.sourceName = sourceName;
        this.skip = skip;
        this.ignoreBonuses = ignoreBonuses;
        this.causedByParty = causedByParty;
    }

    public boolean isCancelable() {
        return true;
    }

    public int startLevel() {
        return XP.levelAtXp(this.amount);
    }

    public int endLevel() {
        return XP.levelAtXp(this.amount + APIUtils.getXp(this.skill, this.getPlayer()));
    }

    public String getSkill() {
        return this.skill;
    }

    public void setSkill(String skill) {
        this.skill = skill;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isIgnoreBonuses() {
        return this.ignoreBonuses;
    }

    public void setIgnoreBonuses(boolean ignoreBonuses) {
        this.ignoreBonuses = ignoreBonuses;
    }

    public boolean isCausedByParty() {
        return this.causedByParty;
    }

    public void setCausedByParty(boolean causedByParty) {
        this.causedByParty = causedByParty;
    }
}

