/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckStatsCommand {
    public static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSource> context) throws CommandException {
        PlayerEntity sender = (PlayerEntity)((CommandSource)context.getSource()).func_197022_f();
        String[] args = context.getInput().split(" ");
        if (sender == null) {
            LOGGER.error("Error: Pmmo checkstats sent by non-player");
            return -1;
        }
        try {
            ServerPlayerEntity target = EntityArgument.func_197089_d(context, (String)"player name");
            CompoundNBT packetxpMap = NBTHelper.mapStringToNbt(Config.getXpMap((PlayerEntity)target));
            packetxpMap.func_74778_a("UUID", target.func_110124_au().toString());
            packetxpMap.func_74778_a("name", target.func_200200_C_().getString());
            NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(packetxpMap, 3), (ServerPlayerEntity)sender);
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Error: Invalid Player requested at CheckStats Command \"" + args[2] + "\"", (Throwable)e);
            sender.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.invalidPlayer", new Object[]{args[2]}).func_230530_a_(XP.textStyle.get("red")), false);
            return -1;
        }
        return 1;
    }
}

