/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.AttributeHandler;
import harmonised.pmmo.util.XP;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClearCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSource> context) throws CommandException {
        Object[] args = context.getInput().split(" ");
        try {
            Collection players = EntityArgument.func_197090_e(context, (String)"target");
            for (ServerPlayerEntity player : players) {
                String playerName = player.func_145748_c_().getString();
                AttributeHandler.updateAll((PlayerEntity)player);
                XP.updateRecipes(player);
                Map<String, Double> xpMap = PmmoSavedData.get().getXpMap(player.func_110124_au());
                for (String skill : new HashSet<String>(xpMap.keySet())) {
                    xpMap.remove(skill);
                }
                NetworkHandler.sendToPlayer(new MessageXp(0.0, "42069", 0.0, true), player);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.skillsCleared"), false);
                LOGGER.info("PMMO Command Clear: " + playerName + " has had their stats wiped!");
            }
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Clear Command Failed to get Players [" + Arrays.toString(args) + "]", (Throwable)e);
        }
        return 1;
    }
}

