/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.party.PartyPendingSystem;
import harmonised.pmmo.util.XP;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InvitePartyCommand {
    public static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSource> context) throws CommandException {
        ServerPlayerEntity targetPlayer;
        PlayerEntity player = (PlayerEntity)((CommandSource)context.getSource()).func_197022_f();
        UUID uuid = player.func_110124_au();
        try {
            targetPlayer = EntityArgument.func_197089_d(context, (String)"target");
        }
        catch (CommandSyntaxException err) {
            LOGGER.error("PMMO Invite Party Command Error: Target player does not exist. How..?");
            return 1;
        }
        int result = PartyPendingSystem.createInvitation(targetPlayer, uuid);
        switch (result) {
            case -4: {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.yourPartyIsFull").func_230530_a_(XP.textStyle.get("red")), false);
                break;
            }
            case -3: {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.youAlreadyInvitedPlayerToYourParty", new Object[]{targetPlayer.func_145748_c_()}).func_230530_a_(XP.textStyle.get("red")), false);
                break;
            }
            case -2: {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.playerAlreadyInAParty").func_230530_a_(XP.textStyle.get("red")), false);
                break;
            }
            case -1: {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.youAreNotInAParty").func_230530_a_(XP.textStyle.get("red")), false);
                break;
            }
            case 0: {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.youHaveInvitedAPlayerToYourParty", new Object[]{targetPlayer.func_145748_c_()}).func_230530_a_(XP.textStyle.get("yellow")), false);
                targetPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.playerInvitedYouToAParty", new Object[]{player.func_145748_c_()}).func_230530_a_(XP.textStyle.get("yellow")), false);
            }
        }
        return 1;
    }
}

