/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.util.XP;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NearbyPowerLevelCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSource> context) throws CommandException {
        String[] args = context.getInput().split(" ");
        ServerPlayerEntity sender = null;
        ServerPlayerEntity target = null;
        try {
            sender = ((CommandSource)context.getSource()).func_197035_h();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (args.length > 3) {
            try {
                target = EntityArgument.func_197089_d(context, (String)"target");
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (sender == null && target == null) {
            LOGGER.error("PMMO NearbyPowerLevel Command: Sender not player, and target is invalid!");
        } else {
            if (target == null) {
                target = sender;
            }
            double totalPowerLevel = 0.0;
            for (PlayerEntity player : XP.getNearbyPlayers((Entity)target)) {
                totalPowerLevel += (double)XP.getPowerLevel(player.func_110124_au());
            }
            LOGGER.info("PMMO NearbyPowerLevel Command Output: " + totalPowerLevel);
            if (sender != null) {
                sender.func_146105_b((ITextComponent)new StringTextComponent(totalPowerLevel + " " + new TranslationTextComponent("pmmo.power").getString()), false);
            }
        }
        return 1;
    }
}

