/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.curios;

import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class Curios {
    private static final boolean isCuriosLoaded = ModList.get().isLoaded("curios");

    public static boolean isLoaded() {
        return isCuriosLoaded;
    }

    public static Stream<ICurioStacksHandler> getCurios(PlayerEntity player) {
        return isCuriosLoaded ? ActualCurios.getCurios(player) : Stream.empty();
    }

    private static class ActualCurios {
        private ActualCurios() {
        }

        public static Stream<ICurioStacksHandler> getCurios(PlayerEntity player) {
            return CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curiosHandler -> curiosHandler.getCurios().values().stream()).orElse(Stream.empty());
        }
    }
}

