/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NetVolumeNode;
import harmonised.pmmo.ProjectMMOMod;
import harmonised.pmmo.api.events.TreasureEvent;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.skills.VeinInfo;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SeaPickleBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockBrokenHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Map<ResourceLocation, Map<BlockPos, Long>> cooldownTracker = new HashMap<ResourceLocation, Map<BlockPos, Long>>();

    public static void handleBroken(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player instanceof FakePlayer)) {
            BlockBrokenHandler.processReq(event);
        }
        ChunkDataHandler.delPos(XP.getDimResLoc((World)event.getWorld()), event.getPos());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processReq(BlockEvent.BreakEvent event) {
        Map<BlockPos, Long> dimCooldownTracker;
        Long cooldownSince;
        PlayerEntity player = event.getPlayer();
        BlockState blockState = event.getState();
        Block block = blockState.func_177230_c();
        BlockPos pos = event.getPos();
        World world = (World)event.getWorld();
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        ResourceLocation dimResLoc = XP.getDimResLoc((World)event.getWorld());
        boolean passedBreakReq = true;
        if (!cooldownTracker.containsKey(dimResLoc)) {
            cooldownTracker.put(dimResLoc, new HashMap());
        }
        if ((cooldownSince = (dimCooldownTracker = cooldownTracker.get(dimResLoc)).get(pos)) != null) {
            if (System.currentTimeMillis() - cooldownSince <= 50L) return;
            dimCooldownTracker.remove(pos);
        } else {
            dimCooldownTracker.put(pos, System.currentTimeMillis());
        }
        if (XP.isHoldingDebugItemInOffhand(player)) {
            player.func_146105_b((ITextComponent)new StringTextComponent(block.getRegistryName().toString()), false);
        }
        if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(blockAbove.getRegistryName().toString()) && blockAbove instanceof IPlantable) {
            passedBreakReq = XP.checkReq(player, blockAbove.getRegistryName(), JType.REQ_BREAK);
        }
        if (!passedBreakReq) {
            block = blockAbove;
        } else {
            passedBreakReq = XP.checkReq(player, block.getRegistryName(), JType.REQ_BREAK);
        }
        if (passedBreakReq) {
            if (!XP.checkReq(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL)) return;
            BlockBrokenHandler.processBroken(event);
            ChunkDataHandler.delPos(XP.getDimResLoc(world), pos);
            return;
        } else {
            if (XP.getHarvestTool(blockState).equals("axe")) {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToChop", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToChop", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            } else if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(blockAbove.getRegistryName().toString()) || block instanceof IPlantable) {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToHarvest", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToHarvest", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            } else {
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToBreak", block.func_149739_a(), "", true, 2), (ServerPlayerEntity)player);
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToBreak", block.func_149739_a(), "", false, 2), (ServerPlayerEntity)player);
            }
            for (Map.Entry<String, Double> entry : JsonConfig.data.get((Object)JType.REQ_BREAK).get(block.getRegistryName().toString()).entrySet()) {
                double entryValue;
                int startLevel = Skill.getLevel(entry.getKey(), player);
                if ((double)startLevel < (entryValue = entry.getValue().doubleValue())) {
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.levelDisplay", "pmmo." + entry.getKey(), "" + (int)Math.floor(entryValue), false, 2), (ServerPlayerEntity)player);
                    continue;
                }
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.levelDisplay", "pmmo." + entry.getKey(), "" + (int)Math.floor(entryValue), false, 1), (ServerPlayerEntity)player);
            }
            event.setCanceled(true);
        }
    }

    private static void processBroken(BlockEvent.BreakEvent event) {
        int gap;
        int extraDrop;
        int guaranteedDrop;
        ItemStack theDropItem;
        boolean veiningAllowed;
        BlockState state = event.getState();
        if (state.func_185904_a().func_76224_d()) {
            return;
        }
        Block block = state.func_177230_c();
        BlockPos pos = event.getPos();
        String regKey = block.getRegistryName().toString();
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        Map<String, Double> xpMap = tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_BREAK) : XP.getXp(tile, JType.XP_VALUE_BREAK);
        World world = (World)event.getWorld();
        TileEntity tileEntity = world.func_175625_s(event.getPos());
        if (tileEntity != null) {
            tileEntity = TileEntity.func_235657_b_((BlockState)state, (CompoundNBT)tileEntity.serializeNBT());
        }
        boolean isRemote = world.func_201670_d();
        PlayerEntity player = event.getPlayer();
        boolean bl = veiningAllowed = Config.getConfig("veiningAllowed") != 0.0;
        if (!Util.isProduction()) {
            BlockState coalState = Blocks.field_150402_ci.func_176223_P();
            BlockState glassState = Blocks.field_150359_w.func_176223_P();
            int n = 10;
        }
        if (XP.isVeining.contains(player.func_110124_au()) && veiningAllowed && !WorldTickHandler.activeVein.containsKey(player)) {
            WorldTickHandler.scheduleVein(player, new VeinInfo(world, state, event.getPos(), player.func_184614_ca()));
        }
        if (!XP.isPlayerSurvival(player) || isRemote) {
            return;
        }
        Material material = event.getState().func_185904_a();
        double blockHardnessLimitForBreaking = Config.forgeConfig.blockHardnessLimitForBreaking.get();
        boolean wasPlaced = ChunkDataHandler.checkPos(world, event.getPos()) != null;
        ItemStack toolUsed = player.func_184614_ca();
        String skill = XP.getSkill(state);
        double hardness = Math.min(blockHardnessLimitForBreaking, (double)state.func_185887_b((IBlockReader)event.getWorld(), event.getPos()));
        boolean isEffective = true;
        String awardMsg = "";
        switch (XP.getSkill(state)) {
            case "mining": {
                awardMsg = "Mining";
                break;
            }
            case "woodcutting": {
                awardMsg = "Chopping";
                break;
            }
            case "excavation": {
                awardMsg = "Digging";
                break;
            }
            case "farming": {
                awardMsg = "Harvesting";
                break;
            }
            default: {
                awardMsg = "Breaking";
            }
        }
        awardMsg = awardMsg + " " + block.getRegistryName();
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)player.func_184614_ca());
        int fortune = 0;
        if (enchants.get(Enchantments.field_185308_t) != null) {
            fortune = (Integer)enchants.get(Enchantments.field_185308_t);
        }
        boolean dropsItself = false;
        List drops = null;
        if (block.canHarvestBlock(state, (IBlockReader)world, player.func_233580_cy_(), player)) {
            try {
                if (world instanceof ServerWorld) {
                    LootContext.Builder builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)player.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)toolUsed).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216021_b(LootParameters.field_216288_h, (Object)tileEntity);
                    if (fortune > 0) {
                        builder.func_186469_a((float)fortune);
                    }
                    drops = block.func_220076_a(event.getState(), builder);
                    if (EnchantmentHelper.func_82781_a((ItemStack)toolUsed).containsKey(Enchantments.field_185306_r)) {
                        List noSilkDrops;
                        ItemStack noEnchantTool = toolUsed.func_77946_l();
                        noEnchantTool.func_196083_e("Enchantments");
                        builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)player.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)noEnchantTool).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216021_b(LootParameters.field_216288_h, (Object)tileEntity);
                        if (fortune > 0) {
                            builder.func_186469_a((float)fortune);
                        }
                        if ((noSilkDrops = block.func_220076_a(event.getState(), builder)).size() > 0 && ((ItemStack)noSilkDrops.get(0)).func_77973_b().equals(block.func_199767_j())) {
                            dropsItself = true;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
        if (drops == null) {
            drops = new ArrayList();
        }
        HashMap<String, Double> award = new HashMap<String, Double>();
        award.put(skill, hardness);
        int dropItemCount = 0;
        if (drops.size() > 0) {
            dropItemCount = ((ItemStack)drops.get(0)).func_190916_E();
            if (((ItemStack)drops.get(0)).func_77973_b().equals(block.func_199767_j())) {
                dropsItself = true;
            }
        }
        if (!wasPlaced) {
            XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(xpMap, Math.max(dropItemCount, 1)));
        }
        ItemStack itemStack = theDropItem = drops.size() > 0 ? (ItemStack)drops.get(0) : ItemStack.field_190927_a;
        if (JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(regKey) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(regKey).containsKey("growsUpwards")) {
            Block baseBlock = event.getState().func_177230_c();
            BlockPos baseBlockPos = event.getPos();
            double extraChance = XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_PLANT, false) / 100.0;
            int totalDrops = 0;
            guaranteedDrop = 0;
            extraDrop = 0;
            int rewardable = 0;
            int guaranteedDropEach = (int)Math.floor(extraChance);
            extraChance = (extraChance - Math.floor(extraChance)) * 100.0;
            int height = 0;
            BlockPos curBlockPos = new BlockPos(baseBlockPos.func_177958_n(), baseBlockPos.func_177956_o() + height, baseBlockPos.func_177952_p());
            block = world.func_180495_p(curBlockPos).func_177230_c();
            boolean correctBlock = block.equals(baseBlock);
            while (correctBlock) {
                BlockPos nextPos;
                Block nextBlock;
                boolean bl2 = wasPlaced = ChunkDataHandler.checkPos(world, curBlockPos) != null;
                if (!wasPlaced) {
                    ++rewardable;
                    guaranteedDrop += guaranteedDropEach;
                    if (Math.ceil(Math.random() * 1000.0) <= extraChance * 10.0) {
                        ++extraDrop;
                    }
                }
                if ((nextBlock = world.func_180495_p(nextPos = new BlockPos(baseBlockPos.func_177958_n(), baseBlockPos.func_177956_o() + ++height, baseBlockPos.func_177952_p())).func_177230_c()).equals(baseBlock)) {
                    curBlockPos = nextPos;
                    block = nextBlock;
                    continue;
                }
                correctBlock = false;
            }
            int dropsLeft = guaranteedDrop + extraDrop;
            if (dropsLeft > 0) {
                XP.dropItems(dropsLeft, block.func_199767_j(), world, event.getPos());
                NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + dropsLeft, theDropItem.func_77977_a(), true, 1), (ServerPlayerEntity)player);
            }
            totalDrops = rewardable + dropsLeft;
            award.put(skill, hardness);
            XP.addMapsAnyDouble(award, xpMap);
            XP.multiplyMapAnyDouble(award, totalDrops);
            awardMsg = "removing " + height + " + " + (guaranteedDrop + extraDrop) + " extra " + block.getRegistryName();
        } else if ((material.equals(Material.field_151585_k) || material.equals(Material.field_203243_f) || material.equals(Material.field_151582_l)) && drops.size() > 0) {
            award = new HashMap();
            award.put(skill, hardness);
            int age = -1;
            int maxAge = -1;
            if (state.func_235901_b_((Property)BlockStateProperties.field_222512_Y)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_222512_Y);
                maxAge = 1;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208167_T)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208167_T);
                maxAge = 2;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208168_U)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208168_U);
                maxAge = 3;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208169_V)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208169_V);
                maxAge = 5;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208170_W)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208170_W);
                maxAge = 7;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208171_X)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208171_X);
                maxAge = 15;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208172_Y)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208172_Y);
                maxAge = 25;
            } else if (state.func_235901_b_((Property)BlockStateProperties.field_208135_aj)) {
                age = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208135_aj);
                maxAge = 4;
                if (wasPlaced) {
                    return;
                }
            }
            if (age == maxAge && age >= 0 || block instanceof SeaPickleBlock) {
                double extraChance = XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_PLANT, false) / 100.0;
                guaranteedDrop = (int)extraChance;
                int totalExtraDrops = guaranteedDrop + (extraDrop = XP.rollChance(extraChance % 1.0) ? 1 : 0);
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop + extraDrop, theDropItem.func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                awardMsg = "Harvesting " + dropItemCount + " + " + totalExtraDrops + " " + block.getRegistryName();
                XP.multiplyMapAnyDouble(XP.addMapsAnyDouble(award, xpMap), dropItemCount + totalExtraDrops);
            } else if (!wasPlaced) {
                awardMsg = "Breaking " + block.getRegistryName();
                XP.multiplyMapAnyDouble(XP.addMapsAnyDouble(award, xpMap), dropItemCount);
            }
        }
        if (XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_ORE, false) > 0.0) {
            boolean isSilk;
            award = new HashMap();
            award.put(skill, hardness);
            boolean bl3 = isSilk = enchants.get(Enchantments.field_185306_r) != null;
            if (!wasPlaced && !isSilk) {
                XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_BREAK) : XP.getXp(tile, JType.XP_VALUE_BREAK), theDropItem.func_190916_E()));
            }
            if (dropsItself && !wasPlaced || !dropsItself && !isSilk) {
                double extraChance = XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_ORE, false) / 100.0;
                int guaranteedDrop2 = (int)extraChance;
                int extraDrop2 = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop2 + extraDrop2;
                if (!dropsItself && wasPlaced) {
                    XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_BREAK) : XP.getXp(tile, JType.XP_VALUE_BREAK), theDropItem.func_190916_E()));
                }
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop2 + extraDrop2, theDropItem.func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_BREAK) : XP.getXp(tile, JType.XP_VALUE_BREAK), totalExtraDrops));
            }
            awardMsg = "Mining " + block.getRegistryName();
        }
        if (ProjectMMOMod.dynamicTreesLoaded && block instanceof BranchBlock) {
            BranchBlock branchBlock = (BranchBlock)block;
            MapSignal signal = branchBlock.analyse(state, (IWorld)world, pos, null, new MapSignal());
            NetVolumeNode volumeNet = new NetVolumeNode();
            branchBlock.analyse(state, (IWorld)world, pos, signal.localRootDir, new MapSignal(new INodeInspector[]{volumeNet}));
            NetVolumeNode.Volume volume = volumeNet.getVolume();
            float volumeFloat = volume.getVolume();
            drops = branchBlock.getLogDrops(world, pos, branchBlock.getFamily().getSpeciesForLocation((IWorld)world, pos), volume);
            award = new HashMap();
            for (ItemStack itemStack2 : drops) {
                try {
                    ResourceLocation resLoc = itemStack2.func_77973_b().getRegistryName();
                    double extraChance = XP.getExtraChance(player.func_110124_au(), resLoc, JType.INFO_LOG, false);
                    int extraDrops = (int)((double)itemStack2.func_190916_E() * extraChance / 100.0);
                    XP.addMapsAnyDouble(award, XP.multiplyMapAnyDouble(XP.getXpBypass(resLoc, JType.XP_VALUE_BREAK), volumeFloat + (float)extraDrops));
                    if (extraDrops <= 0) continue;
                    ItemStack extraDropStack = itemStack2.func_77946_l();
                    extraDropStack.func_190920_e(extraDrops);
                    XP.dropItemStack(extraDropStack, world, pos);
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + extraDrops, extraDropStack.func_77977_a(), true, 1), (ServerPlayerEntity)player);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
        } else if (XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_LOG, false) > 0.0 && isEffective) {
            if (!wasPlaced) {
                award = new HashMap();
                award.put(skill, hardness);
                double extraChance = XP.getExtraChance(player.func_110124_au(), block.getRegistryName(), JType.INFO_LOG, false) / 100.0;
                int guaranteedDrop3 = (int)extraChance;
                int extraDrop3 = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop3 + extraDrop3;
                if (totalExtraDrops > 0) {
                    XP.dropItems(guaranteedDrop3 + extraDrop3, theDropItem.func_77973_b(), world, event.getPos());
                    NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.extraDrop", "" + totalExtraDrops, theDropItem.func_77973_b().func_77658_a(), true, 1), (ServerPlayerEntity)player);
                }
                XP.multiplyMapAnyDouble(XP.addMapsAnyDouble(award, xpMap), dropItemCount + totalExtraDrops);
            }
            awardMsg = "Chopping " + block.getRegistryName().toString();
        }
        if (JsonConfig.data2.get((Object)JType.TREASURE).containsKey(block.getRegistryName().toString()) && !wasPlaced) {
            Map<String, Map<String, Double>> treasurePool = JsonConfig.data2.get((Object)JType.TREASURE).get(block.getRegistryName().toString());
            int excavationLevel = Skill.getLevel(Skill.EXCAVATION.toString(), player);
            for (Map.Entry<String, Map<String, Double>> treasureItem : treasurePool.entrySet()) {
                boolean foundTreasure = false;
                Map<String, Double> treasureItemMap = treasureItem.getValue();
                double chance = BlockBrokenHandler.getTreasureItemChance(excavationLevel, treasureItemMap);
                if (Math.ceil(Math.random() * 10000.0) <= chance * 100.0) {
                    Item item = XP.getItem(treasureItem.getKey());
                    int minCount = (int)Math.floor(treasureItemMap.get("minCount"));
                    int maxCount = (int)Math.floor(treasureItemMap.get("maxCount"));
                    int count = (int)Math.floor(Math.random() * (double)maxCount + (double)minCount);
                    Map<String, Double> treasureAward = new HashMap<String, Double>();
                    treasureAward.put(Skill.EXCAVATION.toString(), treasureItemMap.get("xpPerItem") * (double)count);
                    BlockPos treasurePos = event.getPos();
                    ItemStack itemStack3 = new ItemStack((IItemProvider)item, count);
                    TreasureEvent treasureEvent = new TreasureEvent(player, treasurePos, itemStack3, treasureAward);
                    if (MinecraftForge.EVENT_BUS.post((Event)treasureEvent)) {
                        return;
                    }
                    treasurePos = treasureEvent.getBlockPos();
                    itemStack3 = treasureEvent.getItemStack();
                    treasureAward = treasureEvent.getAward();
                    XP.dropItemStack(itemStack3, world, treasurePos);
                    foundTreasure = true;
                    XP.addMapsAnyDouble(award, treasureAward);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.youFoundTreasureItem", new Object[]{count, new TranslationTextComponent(itemStack3.func_77977_a())}).func_230530_a_(XP.textStyle.get("green")), false);
                    LOGGER.debug(player.func_145748_c_().getString() + " found Treasure! " + count + " " + treasureItem.getKey() + " " + event.getPos());
                }
                if (!foundTreasure) continue;
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.youFoundTreasure").func_230530_a_(XP.textStyle.get("green")), true);
            }
        }
        if ((gap = XP.getSkillReqGap(player, player.func_184614_ca().func_77973_b().getRegistryName(), JType.REQ_TOOL)) > 0) {
            player.func_184614_ca().func_222118_a(gap - 1, (LivingEntity)player, a -> a.func_213334_d(Hand.MAIN_HAND));
        }
        ResourceLocation dimResLoc = XP.getDimResLoc(world);
        for (String awardSkillName : award.keySet()) {
            double xp = (Double)award.get(awardSkillName) / (double)(gap + 1);
            if ((int)(Math.random() * 152369.0) == 0) {
                for (int i = 0; i < 1000; ++i) {
                    WorldText worldText = WorldText.fromBlockPos(XP.getDimResLoc(world), pos.func_177965_g((int)(Math.random() * 30.0 - 15.0)).func_177964_d((int)(Math.random() * 30.0 - 15.0)), pos.func_177965_g((int)(Math.random() * 60.0 - 30.0)).func_177964_d((int)(Math.random() * 60.0 - 30.0)).func_177981_b(25));
                    worldText.setMaxOffset(0.25f);
                    String text = "";
                    switch ((int)(Math.random() * 4.0)) {
                        case 0: {
                            text = "owo";
                            break;
                        }
                        case 1: {
                            text = "OwO";
                            break;
                        }
                        case 2: {
                            text = "uwu";
                            break;
                        }
                        case 3: {
                            text = "UwU";
                        }
                    }
                    worldText.setText(text);
                    worldText.setHueColor(true);
                    worldText.setEndHue(1080.0f);
                    worldText.setStartSize(0.0f);
                    worldText.setEndSize(50.0f);
                    worldText.setSecondsLifespan((float)(10.0 + Math.random() * 50.0));
                    worldText.setStartRot((float)(Math.random() * 360.0 - 180.0));
                    worldText.setEndRot((float)(Math.random() * 360.0 - 180.0));
                    XP.addWorldTextRadius(dimResLoc, worldText, 128.0);
                }
            }
            WorldXpDrop xpDrop = WorldXpDrop.fromBlockPos(XP.getDimResLoc(world), pos, 0.25, xp, awardSkillName);
            xpDrop.setDecaySpeed(1.25);
            XP.addWorldXpDrop(xpDrop, (ServerPlayerEntity)player);
            Skill.addXp(awardSkillName, (ServerPlayerEntity)player, (double)((Double)award.get(awardSkillName)), awardMsg, false, false);
        }
    }

    public static double getTreasureItemChance(int level, Map<String, Double> map) {
        return Util.mapCapped(level, map.get("startLevel"), map.get("endLevel"), map.get("startChance"), map.get("endChance"));
    }
}

