/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.MessageGrow;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;

public class BlockPlacedHandler {
    private static Map<UUID, BlockPos> lastPosPlaced = new HashMap<UUID, BlockPos>();

    public static boolean handlePlaced(Entity entity, BlockState state, World world, BlockPos pos) {
        if (entity instanceof ServerPlayerEntity && !(entity instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (XP.isHoldingDebugItemInOffhand((PlayerEntity)player)) {
                player.func_146105_b((ITextComponent)new StringTextComponent(state.func_177230_c().getRegistryName().toString()), false);
            }
            if (XP.isPlayerSurvival((PlayerEntity)player)) {
                Block block = state.func_177230_c();
                if (block.equals(Blocks.field_150357_h)) {
                    Config.getAbilitiesMap((PlayerEntity)player).put("veinLeft", Config.forgeConfig.maxVeinCharge.get());
                }
                if (block.equals(Blocks.field_150355_j)) {
                    XP.awardXp(player, Skill.MAGIC.toString(), "Walking on water -gasp-", Config.forgeConfig.jesusXp.get(), true, false, false);
                    return false;
                }
                if (XP.checkReq((PlayerEntity)player, block.getRegistryName(), JType.REQ_PLACE)) {
                    double blockHardnessLimitForPlacing = Config.forgeConfig.blockHardnessLimitForPlacing.get();
                    double blockHardness = state.func_185887_b((IBlockReader)world, pos);
                    if (blockHardness > blockHardnessLimitForPlacing) {
                        blockHardness = blockHardnessLimitForPlacing;
                    }
                    UUID playerUUID = player.func_110124_au();
                    Map<Object, Object> award = new HashMap();
                    String sourceName = "Placing a Block";
                    if (!lastPosPlaced.containsKey(playerUUID) || !lastPosPlaced.get(playerUUID).equals((Object)pos)) {
                        TileEntity tile = world.func_175625_s(pos);
                        Map<String, Double> map = award = tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_PLACE) : XP.getXp(tile, JType.XP_VALUE_PLACE);
                        if (award.size() == 0) {
                            if (block.equals(Blocks.field_150458_ak)) {
                                award.put(Skill.FARMING.toString(), blockHardness);
                                sourceName = "Tilting Dirt";
                            } else {
                                award.put(Skill.BUILDING.toString(), blockHardness);
                            }
                        }
                    }
                    for (String awardSkillName : award.keySet()) {
                        WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.523, (double)pos.func_177952_p() + 0.5, 0.35, (Double)award.get(awardSkillName), awardSkillName);
                        XP.addWorldXpDrop(xpDrop, player);
                        Skill.addXp(awardSkillName, player, (double)((Double)award.get(awardSkillName)), sourceName, false, false);
                    }
                    if (lastPosPlaced.containsKey(playerUUID)) {
                        lastPosPlaced.replace(playerUUID, pos);
                    } else {
                        lastPosPlaced.put(playerUUID, pos);
                    }
                } else {
                    ItemStack mainItemStack = player.func_184614_ca();
                    ItemStack offItemStack = player.func_184592_cb();
                    if (mainItemStack.func_77973_b() instanceof BlockItem) {
                        NetworkHandler.sendToPlayer(new MessageGrow(0, mainItemStack.func_190916_E()), player);
                    }
                    if (offItemStack.func_77973_b() instanceof BlockItem) {
                        NetworkHandler.sendToPlayer(new MessageGrow(1, offItemStack.func_190916_E()), player);
                    }
                    if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(block.getRegistryName().toString()) || block instanceof IPlantable) {
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToPlant", block.func_149739_a(), "", true, 2), player);
                    } else {
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToPlaceDown", block.func_149739_a(), "", true, 2), player);
                    }
                    return true;
                }
            }
        }
        ChunkDataHandler.addPos(XP.getDimResLoc(world), pos, entity.func_110124_au());
        return false;
    }
}

