/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.TooltipSupplier;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class BreakSpeedHandler {
    public static void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        boolean breakReqMet;
        PlayerEntity player = event.getPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        String skill = XP.getSkill(event.getState()).toLowerCase();
        ItemStack itemStack = player.func_184614_ca();
        ResourceLocation resLoc = itemStack.func_77973_b().getRegistryName();
        if (resLoc == null) {
            return;
        }
        Map<String, Double> toolReq = TooltipSupplier.getTooltipData(resLoc, JType.REQ_TOOL, itemStack);
        if (Config.getConfig("toolReqEnabled") != 0.0 && Config.getConfig("autoGenerateValuesEnabled") != 0.0 && Config.getConfig("autoGenerateToolReqDynamicallyEnabled") != 0.0) {
            Map<String, Double> dynToolReq = AutoValues.getToolReqFromStack(itemStack);
            for (Map.Entry<String, Double> entry : dynToolReq.entrySet()) {
                if (toolReq.containsKey(entry.getKey())) continue;
                toolReq.put(entry.getKey(), Math.max(1.0, entry.getValue()));
            }
        }
        int toolGap = XP.getSkillReqGap(player, toolReq);
        int enchantGap = XP.getSkillReqGap(player, XP.getEnchantsUseReq(player.func_184614_ca()));
        int gap = Math.max(toolGap, enchantGap);
        boolean bl = breakReqMet = event.getState().hasTileEntity() ? XP.checkReq(player, event.getEntity().func_130014_f_().func_175625_s(event.getPos()), JType.REQ_BREAK) : XP.checkReq(player, event.getState().func_177230_c().getRegistryName(), JType.REQ_BREAK);
        if (!breakReqMet) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToBreak", new Object[]{new TranslationTextComponent(event.getState().func_177230_c().func_149739_a())}).func_230530_a_(XP.textStyle.get("red")), true);
            event.setCanceled(true);
            return;
        }
        if (gap > 0) {
            if (enchantGap < gap) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("pmmo.notSkilledEnoughToUseAsTool", new Object[]{new TranslationTextComponent(player.func_184614_ca().func_77977_a())}).func_230530_a_(XP.textStyle.get("red")), true);
            }
            if (Config.getConfig("strictReqTool") == 1.0) {
                event.setCanceled(true);
                return;
            }
        }
        int startLevel = Skill.getLevel(skill, player);
        switch (XP.getHarvestTool(event.getState())) {
            case "pickaxe": {
                double blocksToUnbreakableY;
                double heightMultiplier;
                float height = event.getPos().func_177956_o();
                if (height < 0.0f) {
                    height = -height;
                }
                if ((heightMultiplier = 1.0 - (double)height / (blocksToUnbreakableY = Config.forgeConfig.blocksToUnbreakableY.get().doubleValue())) < Config.forgeConfig.minBreakSpeed.get()) {
                    heightMultiplier = Config.forgeConfig.minBreakSpeed.get();
                }
                double speedBonus = Config.forgeConfig.miningBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus) * (float)heightMultiplier);
                break;
            }
            case "axe": {
                double speedBonus = Config.forgeConfig.woodcuttingBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            case "shovel": {
                double speedBonus = Config.forgeConfig.excavationBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            case "hoe": {
                double speedBonus = Config.forgeConfig.farmingBonusSpeed.get() / 100.0;
                event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)(startLevel - toolGap) * (float)speedBonus));
                break;
            }
            default: {
                event.setNewSpeed(event.getOriginalSpeed());
            }
        }
        event.setNewSpeed(event.getNewSpeed() / (float)(toolGap + 1));
    }
}

