/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;

public class BreedHandler {
    public static void handleBreedEvent(BabyEntitySpawnEvent event) {
        if (event.getChild() != null && event.getCausedByPlayer() != null && event.getCausedByPlayer() instanceof ServerPlayerEntity && !(event.getCausedByPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity causedByPlayer = (ServerPlayerEntity)event.getCausedByPlayer();
            double defaultBreedingXp = Config.forgeConfig.defaultBreedingXp.get();
            String regKey = event.getChild().func_70022_Q();
            Vector3d midPos = Util.getMidVec(event.getParentA().func_213303_ch(), event.getParentB().func_213303_ch());
            Vector3d xpDropPos = new Vector3d(midPos.func_82615_a(), midPos.func_82617_b() + (double)event.getChild().func_70047_e() + 0.523, midPos.func_82616_c());
            Map<String, Double> award = XP.getXp((Entity)event.getChild(), JType.XP_VALUE_BREED);
            if (award.size() == 0) {
                award.put(Skill.FARMING.toString(), defaultBreedingXp);
            }
            if (XP.isHoldingDebugItemInOffhand((PlayerEntity)causedByPlayer)) {
                causedByPlayer.func_146105_b((ITextComponent)new StringTextComponent(regKey), false);
            }
            for (String awardSkillName : award.keySet()) {
                WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((World)causedByPlayer.func_71121_q()), xpDropPos.func_82615_a(), xpDropPos.func_82617_b(), xpDropPos.func_82616_c(), 0.5, award.get(awardSkillName), awardSkillName);
                XP.addWorldXpDrop(xpDrop, causedByPlayer);
                Skill.addXp(awardSkillName, causedByPlayer, (double)award.get(awardSkillName), "breeding " + regKey, false, false);
            }
        }
    }
}

